/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.userutil;

import com.mirth.connect.model.datatype.DataTypeProperties;
import com.mirth.connect.plugins.DataTypeServerPlugin;
import com.mirth.connect.server.controllers.ControllerFactory;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ACKGenerator {
    private static final String DEFAULTDATEFORMAT = "yyyyMMddHHmmss";
    private static Logger logger = LogManager.getLogger(ACKGenerator.class);

    @Deprecated
    public ACKGenerator() {
        logger.error("The ACKGenerator constructor is now deprecated and will soon be removed. Please call ACKGenerator methods statically (e.g. ACKGenerator.generateAckResponse(message, ackCode, textMessage)).");
    }

    public static String generateAckResponse(String message, String acknowledgementCode, String textMessage) throws Exception {
        return ACKGenerator.generateAckResponse(message, false, acknowledgementCode, textMessage, DEFAULTDATEFORMAT, "");
    }

    @Deprecated
    public static String generateAckResponse(String message, String dataType, String acknowledgementCode, String textMessage, String dateFormat, String errorMessage) throws Exception {
        logger.error("This generateAckResponse(message, dataType, acknowledgementCode, textMessage, dateFormat, errorMessage) method is deprecated and will soon be removed. Please use generateAckResponse(message, isXML, acknowledgementCode, textMessage, dateFormat, errorMessage) instead.");
        return ACKGenerator.generateAckResponse(message, dataType.equals("XML"), acknowledgementCode, textMessage, dateFormat, errorMessage);
    }

    public static String generateAckResponse(String message, boolean isXML, String acknowledgementCode, String textMessage, String dateFormat, String errorMessage) throws Exception {
        DataTypeServerPlugin plugin = ControllerFactory.getFactory().createExtensionController().getDataTypePlugins().get("HL7V2");
        if (plugin != null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("isXML", isXML);
            properties.put("ackCode", acknowledgementCode);
            properties.put("textMessage", textMessage);
            properties.put("dateFormat", dateFormat);
            properties.put("errorMessage", errorMessage);
            properties.put("segmentDelimiter", "\r");
            DataTypeProperties dataTypeProperties = plugin.getDefaultProperties();
            return plugin.getAutoResponder(dataTypeProperties.getSerializationProperties(), dataTypeProperties.getResponseGenerationProperties()).generateResponseMessage(message, properties);
        }
        return null;
    }
}

