/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.userutil;

import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.server.channel.ErrorTaskHandler;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EngineController;
import com.mirth.connect.server.userutil.DeployedState;
import com.mirth.connect.server.userutil.Future;
import com.mirth.connect.userutil.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ChannelUtil {
    private static EngineController engineController = ControllerFactory.getFactory().createEngineController();
    private static ChannelController channelController = ControllerFactory.getFactory().createChannelController();
    private static ExecutorService executor = Executors.newCachedThreadPool();

    private ChannelUtil() {
    }

    public static List<String> getChannelNames() {
        return new ArrayList<String>(channelController.getChannelNames());
    }

    public static List<String> getChannelIds() {
        return new ArrayList<String>(channelController.getChannelIds());
    }

    public static List<String> getDeployedChannelNames() {
        ArrayList<String> channelNames = new ArrayList<String>();
        for (Channel channel : channelController.getDeployedChannels(null)) {
            channelNames.add(channel.getName());
        }
        return channelNames;
    }

    public static String getChannelName(String channelId) {
        String channelName = null;
        Channel channel = channelController.getChannelById(channelId);
        if (channel != null) {
            channelName = channel.getName();
        }
        return channelName;
    }

    public static List<String> getDeployedChannelIds() {
        ArrayList<String> channelIds = new ArrayList<String>();
        for (Channel channel : channelController.getDeployedChannels(null)) {
            channelIds.add(channel.getId());
        }
        return channelIds;
    }

    public static String getDeployedChannelName(String channelId) {
        String channelName = null;
        Channel channel = channelController.getDeployedChannelById(channelId);
        if (channel != null) {
            channelName = channel.getName();
        }
        return channelName;
    }

    public static String getDeployedChannelId(String channelName) {
        String channelId = null;
        Channel channel = channelController.getDeployedChannelByName(channelName);
        if (channel != null) {
            channelId = channel.getId();
        }
        return channelId;
    }

    public static Future<Void> startChannel(final String channelIdOrName) throws Exception {
        return new Future<Void>(executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ErrorTaskHandler handler = new ErrorTaskHandler();
                engineController.startChannels(Collections.singleton(ChannelUtil.convertId(channelIdOrName)), handler);
                if (handler.isErrored()) {
                    throw handler.getError();
                }
                return null;
            }
        }));
    }

    public static Future<Void> stopChannel(final String channelIdOrName) throws Exception {
        return new Future<Void>(executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ErrorTaskHandler handler = new ErrorTaskHandler();
                engineController.stopChannels(Collections.singleton(ChannelUtil.convertId(channelIdOrName)), handler);
                if (handler.isErrored()) {
                    throw handler.getError();
                }
                return null;
            }
        }));
    }

    public static Future<Void> pauseChannel(final String channelIdOrName) throws Exception {
        return new Future<Void>(executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ErrorTaskHandler handler = new ErrorTaskHandler();
                engineController.pauseChannels(Collections.singleton(ChannelUtil.convertId(channelIdOrName)), handler);
                if (handler.isErrored()) {
                    throw handler.getError();
                }
                return null;
            }
        }));
    }

    public static Future<Void> resumeChannel(final String channelIdOrName) throws Exception {
        return new Future<Void>(executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ErrorTaskHandler handler = new ErrorTaskHandler();
                engineController.resumeChannels(Collections.singleton(ChannelUtil.convertId(channelIdOrName)), handler);
                if (handler.isErrored()) {
                    throw handler.getError();
                }
                return null;
            }
        }));
    }

    public static Future<Void> haltChannel(final String channelIdOrName) throws Exception {
        return new Future<Void>(executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ErrorTaskHandler handler = new ErrorTaskHandler();
                engineController.haltChannels(Collections.singleton(ChannelUtil.convertId(channelIdOrName)), handler);
                if (handler.isErrored()) {
                    throw handler.getError();
                }
                return null;
            }
        }));
    }

    public static DeployedState getChannelState(String channelIdOrName) {
        DashboardStatus dashboardStatus = ChannelUtil.getDashboardStatus(channelIdOrName, null);
        return dashboardStatus != null ? DeployedState.fromDonkeyDeployedState(dashboardStatus.getState()) : null;
    }

    public static Future<Void> deployChannel(final String channelIdOrName) {
        return new Future<Void>(executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ErrorTaskHandler handler = new ErrorTaskHandler();
                engineController.deployChannels(Collections.singleton(ChannelUtil.convertId(channelIdOrName)), null, handler, new DebugOptions());
                if (handler.isErrored()) {
                    throw handler.getError();
                }
                return null;
            }
        }));
    }

    public static Future<Void> undeployChannel(final String channelIdOrName) {
        return new Future<Void>(executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ErrorTaskHandler handler = new ErrorTaskHandler();
                engineController.undeployChannels(Collections.singleton(ChannelUtil.convertId(channelIdOrName)), null, handler);
                if (handler.isErrored()) {
                    throw handler.getError();
                }
                return null;
            }
        }));
    }

    public static boolean isChannelDeployed(String channelIdOrName) {
        return engineController.getDeployedIds().contains(ChannelUtil.convertId(channelIdOrName));
    }

    public static Future<Void> startConnector(final String channelIdOrName, final Integer metaDataId) throws Exception {
        return new Future<Void>(executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ErrorTaskHandler handler = new ErrorTaskHandler();
                engineController.startConnector(Collections.singletonMap(ChannelUtil.convertId(channelIdOrName), Collections.singletonList(metaDataId)), handler);
                if (handler.isErrored()) {
                    throw handler.getError();
                }
                return null;
            }
        }));
    }

    public static Future<Void> stopConnector(final String channelIdOrName, final Integer metaDataId) throws Exception {
        return new Future<Void>(executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ErrorTaskHandler handler = new ErrorTaskHandler();
                engineController.stopConnector(Collections.singletonMap(ChannelUtil.convertId(channelIdOrName), Collections.singletonList(metaDataId)), handler);
                if (handler.isErrored()) {
                    throw handler.getError();
                }
                return null;
            }
        }));
    }

    public static DeployedState getConnectorState(String channelIdOrName, Number metaDataId) {
        DashboardStatus dashboardStatus = ChannelUtil.getDashboardStatus(channelIdOrName, metaDataId);
        return dashboardStatus != null ? DeployedState.fromDonkeyDeployedState(dashboardStatus.getState()) : null;
    }

    public static Long getReceivedCount(String channelIdOrName) {
        return ChannelUtil.getReceivedCount(channelIdOrName, null);
    }

    public static Long getReceivedCount(String channelIdOrName, Number metaDataId) {
        return ChannelUtil.getStatisticByStatus(channelIdOrName, metaDataId, Status.RECEIVED);
    }

    public static Long getFilteredCount(String channelIdOrName) {
        return ChannelUtil.getFilteredCount(channelIdOrName, null);
    }

    public static Long getFilteredCount(String channelIdOrName, Number metaDataId) {
        return ChannelUtil.getStatisticByStatus(channelIdOrName, metaDataId, Status.FILTERED);
    }

    public static Long getQueuedCount(String channelIdOrName) {
        return ChannelUtil.getQueuedCount(channelIdOrName, null);
    }

    public static Long getQueuedCount(String channelIdOrName, Number metaDataId) {
        return ChannelUtil.getStatisticByStatus(channelIdOrName, metaDataId, Status.QUEUED);
    }

    public static Long getSentCount(String channelIdOrName) {
        return ChannelUtil.getSentCount(channelIdOrName, null);
    }

    public static Long getSentCount(String channelIdOrName, Number metaDataId) {
        return ChannelUtil.getStatisticByStatus(channelIdOrName, metaDataId, Status.SENT);
    }

    public static Long getErrorCount(String channelIdOrName) {
        return ChannelUtil.getErrorCount(channelIdOrName, null);
    }

    public static Long getErrorCount(String channelIdOrName, Number metaDataId) {
        return ChannelUtil.getStatisticByStatus(channelIdOrName, metaDataId, Status.ERROR);
    }

    private static String convertId(String channelIdOrName) {
        if (!channelController.getChannelIds().contains(channelIdOrName)) {
            Channel channel = channelController.getDeployedChannelByName(channelIdOrName);
            if (channel != null) {
                return channel.getId();
            }
            channel = channelController.getChannelByName(channelIdOrName);
            if (channel != null) {
                return channel.getId();
            }
        }
        return channelIdOrName;
    }

    private static DashboardStatus getDashboardStatus(String channelIdOrName, Number metaDataId) {
        DashboardStatus dashboardStatus = engineController.getChannelStatus(ChannelUtil.convertId(channelIdOrName));
        if (dashboardStatus != null) {
            if (metaDataId == null) {
                return dashboardStatus;
            }
            metaDataId = metaDataId.intValue();
            for (DashboardStatus childStatus : dashboardStatus.getChildStatuses()) {
                if (!childStatus.getMetaDataId().equals(metaDataId)) continue;
                return childStatus;
            }
        }
        return null;
    }

    private static Long getStatisticByStatus(String channelIdOrName, Number metaDataId, Status status) {
        DashboardStatus dashboardStatus = ChannelUtil.getDashboardStatus(channelIdOrName, metaDataId);
        if (dashboardStatus != null) {
            if (status == Status.QUEUED) {
                return dashboardStatus.getQueued();
            }
            return dashboardStatus.getStatistics().get(ChannelUtil.convertStatus(status));
        }
        return null;
    }

    private static com.mirth.connect.donkey.model.message.Status convertStatus(Status status) {
        switch (status) {
            case RECEIVED: {
                return com.mirth.connect.donkey.model.message.Status.RECEIVED;
            }
            case FILTERED: {
                return com.mirth.connect.donkey.model.message.Status.FILTERED;
            }
            case TRANSFORMED: {
                return com.mirth.connect.donkey.model.message.Status.TRANSFORMED;
            }
            case SENT: {
                return com.mirth.connect.donkey.model.message.Status.SENT;
            }
            case QUEUED: {
                return com.mirth.connect.donkey.model.message.Status.QUEUED;
            }
            case ERROR: {
                return com.mirth.connect.donkey.model.message.Status.ERROR;
            }
            case PENDING: {
                return com.mirth.connect.donkey.model.message.Status.PENDING;
            }
        }
        return null;
    }

    public static Future<Void> resetStatistics(final String channelIdOrName) throws Exception {
        return new Future<Void>(executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ChannelUtil.clearStatistics(channelIdOrName, null, null);
                return null;
            }
        }));
    }

    public static Future<Void> resetStatistics(final String channelIdOrName, final Integer metaDataId) throws Exception {
        return new Future<Void>(executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ChannelUtil.clearStatistics(channelIdOrName, metaDataId, null);
                return null;
            }
        }));
    }

    public static Future<Void> resetStatistics(final String channelIdOrName, final Integer metaDataId, final Collection<Status> statuses) throws Exception {
        return new Future<Void>(executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ChannelUtil.clearStatistics(channelIdOrName, metaDataId, statuses);
                return null;
            }
        }));
    }

    private static void clearStatistics(String channelIdOrName, Integer metaDataId, Collection<Status> statuses) {
        HashMap<String, List<Integer>> channelMap = new HashMap<String, List<Integer>>();
        HashSet<com.mirth.connect.donkey.model.message.Status> statusesToReset = new HashSet<com.mirth.connect.donkey.model.message.Status>();
        HashSet<com.mirth.connect.donkey.model.message.Status> resetableStatuses = new HashSet<com.mirth.connect.donkey.model.message.Status>();
        resetableStatuses.add(com.mirth.connect.donkey.model.message.Status.RECEIVED);
        resetableStatuses.add(com.mirth.connect.donkey.model.message.Status.FILTERED);
        resetableStatuses.add(com.mirth.connect.donkey.model.message.Status.ERROR);
        resetableStatuses.add(com.mirth.connect.donkey.model.message.Status.SENT);
        com.mirth.connect.donkey.server.channel.Channel deployedChannel = engineController.getDeployedChannel(ChannelUtil.convertId(channelIdOrName));
        if (deployedChannel != null) {
            List connectorList = deployedChannel.getMetaDataIds();
            if (metaDataId == null) {
                connectorList.add(null);
            } else {
                HashSet metaDataIds = new HashSet(connectorList);
                connectorList.clear();
                if (metaDataIds.contains(metaDataId)) {
                    connectorList.add(metaDataId);
                }
            }
            if (!connectorList.isEmpty()) {
                channelMap.put(ChannelUtil.convertId(channelIdOrName), connectorList);
                if (statuses == null) {
                    statusesToReset.addAll(resetableStatuses);
                } else {
                    for (Status status : statuses) {
                        com.mirth.connect.donkey.model.message.Status convertedStatus = ChannelUtil.convertStatus(status);
                        if (!resetableStatuses.contains(convertedStatus)) continue;
                        statusesToReset.add(convertedStatus);
                    }
                }
                channelController.resetStatistics(channelMap, statusesToReset);
            }
        }
    }
}

