/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.userutil;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    private FileUtil() {
    }

    public static void write(String fileName, boolean append, String data) throws IOException {
        FileUtils.writeStringToFile((File)new File(fileName), (String)data, (boolean)append);
    }

    public static byte[] decode(String data) {
        return Base64.decodeBase64((byte[])data.getBytes());
    }

    public static String encode(byte[] data) {
        return new String(Base64.encodeBase64Chunked((byte[])data));
    }

    public static void write(String fileName, boolean append, byte[] bytes) throws IOException {
        FileUtils.writeByteArrayToFile((File)new File(fileName), (byte[])bytes, (boolean)append);
    }

    public static byte[] readBytes(String fileName) throws IOException {
        return FileUtils.readFileToByteArray((File)new File(fileName));
    }

    public static String read(String fileName) throws IOException {
        return FileUtils.readFileToString((File)new File(fileName));
    }

    public static boolean deleteFile(File file) throws SecurityException {
        return file.delete();
    }

    public static String rtfToPlainText(String message, String replaceLinebreaksWith) throws IOException, BadLocationException {
        StringReader in = new StringReader(message);
        DefaultStyledDocument styledDoc = new DefaultStyledDocument();
        RTFEditorKit rtfKit = new RTFEditorKit();
        rtfKit.read(in, (Document)styledDoc, 0);
        Document doc = styledDoc.getDefaultRootElement().getDocument();
        String convertedPlainText = doc.getText(0, doc.getLength());
        if (replaceLinebreaksWith != null) {
            convertedPlainText = convertedPlainText.replaceAll("\\n", replaceLinebreaksWith);
        }
        return convertedPlainText;
    }
}

