/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.userutil;

import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.model.Channel;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EngineController;
import com.mirth.connect.server.userutil.RawMessage;
import com.mirth.connect.userutil.Response;
import com.mirth.connect.userutil.Status;
import com.mirth.connect.util.ErrorMessageBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMRouter {
    private Logger logger = LogManager.getLogger(this.getClass());
    private ChannelController channelController = ControllerFactory.getFactory().createChannelController();
    private EngineController engineController = ControllerFactory.getFactory().createEngineController();

    public Response routeMessage(String channelName, String message) {
        return this.routeMessage(channelName, new RawMessage(message));
    }

    public Response routeMessage(String channelName, RawMessage rawMessage) {
        Channel channel = this.channelController.getDeployedChannelByName(channelName);
        if (channel == null) {
            this.logger.error("Could not find channel to route to for channel name: " + channelName);
            return new Response(Status.ERROR, "Could not find channel to route to for channel name: " + channelName);
        }
        return this.routeMessageByChannelId(channel.getId(), rawMessage);
    }

    public Response routeMessageByChannelId(String channelId, String message) {
        return this.routeMessageByChannelId(channelId, new RawMessage(message));
    }

    public Response routeMessageByChannelId(String channelId, RawMessage rawMessage) {
        try {
            DispatchResult dispatchResult = this.engineController.dispatchRawMessage(channelId, this.convertRawMessage(rawMessage), false, true);
            Response response = null;
            if (dispatchResult != null && dispatchResult.getSelectedResponse() != null) {
                response = new Response(dispatchResult.getSelectedResponse());
            }
            return response;
        }
        catch (Throwable e) {
            String message = "Error routing message to channel id: " + channelId;
            this.logger.error(message, e);
            String responseStatusMessage = ErrorMessageBuilder.buildErrorResponse(message, e);
            String responseError = ErrorMessageBuilder.buildErrorMessage(this.getClass().getSimpleName(), message, e);
            return new Response(Status.ERROR, null, responseStatusMessage, responseError);
        }
    }

    private com.mirth.connect.donkey.model.message.RawMessage convertRawMessage(RawMessage message) {
        if (message.isBinary().booleanValue()) {
            return new com.mirth.connect.donkey.model.message.RawMessage(message.getRawBytes(), message.getDestinationMetaDataIds(), message.getSourceMap());
        }
        return new com.mirth.connect.donkey.model.message.RawMessage(message.getRawData(), message.getDestinationMetaDataIds(), message.getSourceMap());
    }
}

