/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;

public class ChildFirstURLClassLoader
extends URLClassLoader {
    public ChildFirstURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass == null) {
            try {
                if (loadedClass == null) {
                    loadedClass = this.findClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                loadedClass = super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> parentRes;
        final LinkedList<URL> allRes = new LinkedList<URL>();
        Enumeration<URL> thisRes = this.findResources(name);
        if (thisRes != null) {
            while (thisRes.hasMoreElements()) {
                allRes.add(thisRes.nextElement());
            }
        }
        if ((parentRes = super.findResources(name)) != null) {
            while (parentRes.hasMoreElements()) {
                allRes.add(parentRes.nextElement());
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> it;
            {
                this.it = allRes.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.it.next();
            }
        };
    }

    @Override
    public URL getResource(String name) {
        URL res = null;
        if (res == null) {
            res = this.findResource(name);
        }
        if (res == null) {
            res = super.getResource(name);
        }
        return res;
    }
}

