/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.MessageSerializerException;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.util.Base64Util;
import com.mirth.connect.model.converters.DICOMConverter;
import com.mirth.connect.server.controllers.MessageController;
import com.mirth.connect.userutil.ImmutableConnectorMessage;
import com.mirth.connect.userutil.ImmutableMessageContent;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.DICOM;
import ij.process.ImageProcessor;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DICOMMessageUtil {
    private static Logger logger = LogManager.getLogger(DICOMMessageUtil.class);

    public static String getDICOMRawData(ImmutableConnectorMessage message) {
        String mergedMessage;
        block5: {
            mergedMessage = null;
            List<Attachment> attachments = MessageController.getInstance().getMessageAttachment(message.getChannelId(), message.getMessageId(), false);
            if (attachments != null && attachments.size() > 0) {
                try {
                    if (attachments.get(0).getType().equals("DICOM")) {
                        byte[] mergedMessageBytes = DICOMMessageUtil.mergeHeaderAttachments(message, attachments);
                        mergedMessageBytes = Base64Util.encodeBase64((byte[])mergedMessageBytes);
                        mergedMessage = StringUtils.newStringUsAscii((byte[])mergedMessageBytes);
                        break block5;
                    }
                    mergedMessage = message.getRaw().getContent();
                }
                catch (Exception e) {
                    logger.error("Error merging DICOM data", (Throwable)e);
                    mergedMessage = message.getRaw().getContent();
                }
            } else {
                mergedMessage = message.getRaw().getContent();
            }
        }
        return mergedMessage;
    }

    public static String getDICOMRawData(ConnectorMessage message) {
        return DICOMMessageUtil.getDICOMRawData(new ImmutableConnectorMessage(message));
    }

    public static byte[] getDICOMRawBytes(ImmutableConnectorMessage message) {
        byte[] mergedMessage;
        block5: {
            mergedMessage = null;
            List<Attachment> attachments = MessageController.getInstance().getMessageAttachment(message.getChannelId(), message.getMessageId(), false);
            if (attachments != null && attachments.size() > 0) {
                try {
                    if (attachments.get(0).getType().equals("DICOM")) {
                        mergedMessage = DICOMMessageUtil.mergeHeaderAttachments(message, attachments);
                        break block5;
                    }
                    mergedMessage = Base64.decodeBase64((byte[])StringUtils.getBytesUsAscii((String)message.getRaw().getContent()));
                }
                catch (Exception e) {
                    logger.error("Error merging DICOM data", (Throwable)e);
                    mergedMessage = Base64.decodeBase64((byte[])StringUtils.getBytesUsAscii((String)message.getRaw().getContent()));
                }
            } else {
                mergedMessage = Base64.decodeBase64((byte[])StringUtils.getBytesUsAscii((String)message.getRaw().getContent()));
            }
        }
        return mergedMessage;
    }

    public static byte[] getDICOMRawBytes(ConnectorMessage message) {
        return DICOMMessageUtil.getDICOMRawBytes(new ImmutableConnectorMessage(message));
    }

    public static byte[] getDICOMMessage(ImmutableConnectorMessage message) {
        return DICOMMessageUtil.getDICOMRawBytes(message);
    }

    public static byte[] mergeHeaderAttachments(ImmutableConnectorMessage message, List<Attachment> attachments) throws MessageSerializerException {
        try {
            byte[] headerBytes;
            ImmutableMessageContent encoded = message.getEncoded();
            ImmutableMessageContent raw = message.getRaw();
            if (encoded != null && encoded.getContent() != null && encoded.getDataType().equals("DICOM")) {
                headerBytes = Base64.decodeBase64((byte[])StringUtils.getBytesUsAscii((String)encoded.getContent()));
            } else if (raw != null && raw.getContent() != null && raw.getDataType().equals("DICOM")) {
                headerBytes = Base64.decodeBase64((byte[])StringUtils.getBytesUsAscii((String)raw.getContent()));
            } else {
                return new byte[0];
            }
            return DICOMMessageUtil.mergeHeaderPixelData(headerBytes, attachments);
        }
        catch (IOException e) {
            throw new MessageSerializerException((Throwable)e);
        }
    }

    public static byte[] mergeHeaderPixelData(byte[] header, List<Attachment> attachments) throws IOException {
        DicomObject dcmObj = DICOMConverter.byteArrayToDicomObject(header, false);
        if (attachments != null && !attachments.isEmpty()) {
            if (attachments.size() > 1) {
                DicomElement dicomElement = dcmObj.putFragments(2145386512, VR.OB, dcmObj.bigEndian(), attachments.size());
                for (Attachment attachment : attachments) {
                    dicomElement.addFragment(attachment.getContent());
                }
                dcmObj.add(dicomElement);
            } else {
                dcmObj.putBytes(2145386512, VR.OB, attachments.get(0).getContent());
            }
        }
        attachments.clear();
        return DICOMConverter.dicomObjectToByteArray(dcmObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSliceCount(ImmutableConnectorMessage message) {
        ByteArrayInputStream bais = new ByteArrayInputStream(DICOMMessageUtil.getDICOMRawBytes(message));
        try {
            DICOM dicom = new DICOM((InputStream)bais);
            dicom.run("DICOM");
            int n = dicom.getImageStack().getSize();
            return n;
        }
        finally {
            IOUtils.closeQuietly((InputStream)bais);
        }
    }

    public static String convertDICOM(String imageType, ImmutableConnectorMessage message, int sliceIndex, boolean autoThreshold) {
        byte[] bytes = DICOMMessageUtil.convertDICOMToByteArray(imageType, message, sliceIndex, autoThreshold);
        if (bytes != null) {
            return new String(Base64.encodeBase64Chunked((byte[])bytes));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertDICOMToByteArray(String imageType, ImmutableConnectorMessage message, int sliceIndex, boolean autoThreshold) {
        if (imageType.equalsIgnoreCase("jpg") || imageType.equalsIgnoreCase("jpeg")) {
            return DICOMMessageUtil.dicomToJpg(sliceIndex, message, autoThreshold);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(DICOMMessageUtil.getDICOMRawBytes(message));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DICOM dicom = new DICOM((InputStream)bais);
            dicom.run("DICOM");
            ImageStack imageStack = dicom.getImageStack();
            if (sliceIndex >= 1 && sliceIndex <= imageStack.getSize()) {
                ImageIO.write((RenderedImage)imageStack.getProcessor(sliceIndex).getBufferedImage(), imageType, baos);
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
            logger.error("Image slice " + sliceIndex + " not found for message " + message.getMessageId() + ".");
        }
        catch (IOException e) {
            logger.error("Error Converting DICOM image", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bais);
            IOUtils.closeQuietly((OutputStream)baos);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] dicomToJpg(int sliceIndex, ImmutableConnectorMessage message, boolean autoThreshold) {
        ByteArrayInputStream bais = new ByteArrayInputStream(DICOMMessageUtil.getDICOMRawBytes(message));
        try {
            ImageStack imageStack;
            DICOM dicom = new DICOM((InputStream)bais);
            dicom.run("DICOM");
            if (autoThreshold) {
                ImageProcessor im = dicom.getProcessor();
                im.setAutoThreshold(0, 2);
            }
            if ((imageStack = dicom.getImageStack()).getSize() < sliceIndex || sliceIndex < 1) {
                logger.error("Image slice " + sliceIndex + " not found for message " + message.getMessageId() + ".");
                byte[] byArray = null;
                return byArray;
            }
            ImagePlus image = new ImagePlus("ImageName", imageStack.getProcessor(sliceIndex));
            byte[] byArray = DICOMMessageUtil.saveAsJpeg(image, 100);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)bais);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] saveAsJpeg(ImagePlus imagePlug, int quality) {
        int imageType = 1;
        if (imagePlug.getProcessor().isDefaultLut()) {
            imageType = 10;
        }
        BufferedImage bufferedImage = new BufferedImage(imagePlug.getWidth(), imagePlug.getHeight(), imageType);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Graphics2D graphics = bufferedImage.createGraphics();
            graphics.drawImage(imagePlug.getImage(), 0, 0, null);
            graphics.dispose();
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
            writer.setOutput(ImageIO.createImageOutputStream(baos));
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality((float)quality / 100.0f);
            if (quality == 100) {
                param.setSourceSubsampling(1, 1, 0, 0);
            }
            IIOImage iioImage = new IIOImage(bufferedImage, null, null);
            writer.write(null, iioImage, param);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error("Error Converting DICOM image", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
        return null;
    }
}

