/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import com.mirth.connect.donkey.server.data.DonkeyDaoException;
import com.mirth.connect.server.util.SqlConfig;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseUtil {
    private static Logger logger = LogManager.getLogger(DatabaseUtil.class);

    public static void executeScript(String script, boolean ignoreErrors) throws Exception {
        SqlSessionManager sqlSessionManger = SqlConfig.getInstance().getSqlSessionManager();
        Connection conn = null;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            sqlSessionManger.startManagedSession();
            conn = sqlSessionManger.getConnection();
            conn.setAutoCommit(false);
            statement = conn.createStatement();
            Scanner s = new Scanner(script);
            while (s.hasNextLine()) {
                StringBuilder sb = new StringBuilder();
                boolean blankLine = false;
                while (s.hasNextLine() && !blankLine) {
                    String temp = s.nextLine();
                    if (temp.trim().length() > 0) {
                        sb.append(temp + " ");
                        continue;
                    }
                    blankLine = true;
                }
                String statementString = StringUtils.removeEnd((String)sb.toString().trim(), (String)";");
                if (statementString.length() <= 0) continue;
                try {
                    statement.execute(statementString);
                    conn.commit();
                }
                catch (SQLException se) {
                    if (!ignoreErrors) {
                        throw se;
                    }
                    logger.error("Error was encountered and ignored while executing statement.", (Throwable)se);
                    conn.rollback();
                }
            }
        }
        catch (Exception e) {
            try {
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(statement);
                DbUtils.closeQuietly(resultSet);
                DbUtils.closeQuietly((Connection)conn);
                sqlSessionManger.close();
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)statement);
        DbUtils.closeQuietly(resultSet);
        DbUtils.closeQuietly((Connection)conn);
        sqlSessionManger.close();
    }

    public static void executeScript(List<String> script, boolean ignoreErrors) throws Exception {
        SqlSessionManager sqlSessionManger = SqlConfig.getInstance().getSqlSessionManager();
        Connection conn = null;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            sqlSessionManger.startManagedSession();
            conn = sqlSessionManger.getConnection();
            conn.setAutoCommit(false);
            statement = conn.createStatement();
            for (String statementString : script) {
                if ((statementString = statementString.trim()).length() <= 0) continue;
                try {
                    statement.execute(statementString);
                    conn.commit();
                }
                catch (SQLException se) {
                    if (!ignoreErrors) {
                        throw se;
                    }
                    logger.error("Error was encountered and ignored while executing statement.", (Throwable)se);
                    conn.rollback();
                }
            }
        }
        catch (Exception e) {
            try {
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(statement);
                DbUtils.closeQuietly(resultSet);
                DbUtils.closeQuietly((Connection)conn);
                sqlSessionManger.close();
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)statement);
        DbUtils.closeQuietly(resultSet);
        DbUtils.closeQuietly((Connection)conn);
        sqlSessionManger.close();
    }

    public static boolean statementExists(String statement) {
        try {
            SqlConfig.getInstance().getSqlSessionManager().getConfiguration().getMappedStatement(statement);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static boolean statementExists(String statement, SqlSession session) {
        try {
            session.getConfiguration().getMappedStatement(statement);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static List<String> joinSqlStatements(Collection<String> scripts) {
        ArrayList<String> scriptList = new ArrayList<String>();
        for (String script : scripts) {
            script = script.trim();
            StringBuilder sb = new StringBuilder();
            boolean blankLine = false;
            Scanner scanner = new Scanner(script);
            while (scanner.hasNextLine()) {
                String temp = scanner.nextLine();
                if (temp.trim().length() > 0) {
                    sb.append(temp + " ");
                } else {
                    blankLine = true;
                }
                if (!blankLine && scanner.hasNextLine()) continue;
                scriptList.add(sb.toString().trim());
                blankLine = false;
                sb.delete(0, sb.length());
            }
        }
        return scriptList;
    }

    public static boolean tableExists(Connection connection, String tableName) {
        boolean bl;
        DatabaseMetaData metaData;
        ResultSet resultSet;
        block5: {
            resultSet = null;
            metaData = connection.getMetaData();
            resultSet = metaData.getTables(null, null, tableName.toUpperCase(), new String[]{"TABLE"});
            if (!resultSet.next()) break block5;
            boolean bl2 = true;
            DbUtils.closeQuietly((ResultSet)resultSet);
            return bl2;
        }
        try {
            resultSet = metaData.getTables(null, null, tableName.toLowerCase(), new String[]{"TABLE"});
            bl = resultSet.next();
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException((Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)resultSet);
        return bl;
    }

    /*
     * Exception decompiling
     */
    public static boolean indexExists(Connection connection, String tableName, String indexName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

