/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListRangeIterator {
    public static final int DEFAULT_LIST_LIMIT = 1000;
    private Iterator<Long> iterator;
    private int listSize;
    private boolean ascending;
    private Integer blockSize;
    private long lastId;
    private long startRange;
    private long endRange;
    private List<Long> list;
    private boolean listReady;
    private boolean rangeReady;
    private boolean finished;
    private int count;

    public ListRangeIterator(Iterator<Long> iterator, int listSize, boolean ascending, Integer blockSize) {
        this.iterator = iterator;
        this.listSize = listSize;
        this.ascending = ascending;
        this.blockSize = blockSize;
        this.list = new ArrayList<Long>(listSize);
        if (iterator.hasNext()) {
            this.startRange = this.lastId = iterator.next().longValue();
            this.endRange = this.lastId;
            ++this.count;
        } else {
            this.finished = true;
        }
    }

    public boolean hasNext() {
        return !this.finished || this.listReady || this.rangeReady;
    }

    public ListRangeItem next() {
        ListRangeItem item = new ListRangeItem();
        ArrayList<Long> buffer = new ArrayList<Long>(this.listSize);
        while (!(this.finished || this.listReady || this.rangeReady)) {
            if (this.iterator.hasNext() && (this.blockSize == null || this.count++ < this.blockSize)) {
                boolean contiguous;
                long currentId = this.iterator.next();
                boolean bl = this.ascending ? currentId == this.lastId + 1L : (contiguous = currentId == this.lastId - 1L);
                if (contiguous) {
                    this.endRange = currentId;
                } else if (Math.abs(this.endRange - this.startRange) + 1L >= (long)this.listSize) {
                    this.listReady = true;
                    this.rangeReady = true;
                } else {
                    long id = this.startRange;
                    while (this.ascending ? id <= this.endRange : id >= this.endRange) {
                        if (this.list.size() < this.listSize) {
                            this.list.add(id);
                        } else {
                            buffer.add(id);
                        }
                        id += this.ascending ? 1L : -1L;
                    }
                    if (this.list.size() == this.listSize) {
                        this.listReady = true;
                    }
                    this.startRange = currentId;
                    this.endRange = currentId;
                }
                this.lastId = currentId;
                continue;
            }
            this.listReady = true;
            if (this.startRange == this.lastId && this.endRange == this.lastId && this.list.size() < this.listSize) {
                this.list.add(this.lastId);
            } else {
                this.rangeReady = true;
            }
            this.finished = true;
        }
        if (this.listReady && !this.list.isEmpty()) {
            item.setList(new ArrayList<Long>(this.list));
            this.list.clear();
            if (!buffer.isEmpty()) {
                this.list.addAll(buffer);
                buffer.clear();
            }
            this.listReady = false;
        } else if (this.rangeReady) {
            item.setStartRange(this.startRange);
            item.setEndRange(this.endRange);
            this.startRange = this.lastId;
            this.endRange = this.lastId;
            this.listReady = false;
            this.rangeReady = false;
        }
        return item;
    }

    public class ListRangeItem {
        private List<Long> list;
        private Long startRange;
        private Long endRange;

        public List<Long> getList() {
            return this.list;
        }

        public void setList(List<Long> list) {
            this.list = list;
        }

        public Long getStartRange() {
            return this.startRange;
        }

        public void setStartRange(Long startRange) {
            this.startRange = startRange;
        }

        public Long getEndRange() {
            return this.endRange;
        }

        public void setEndRange(Long endRange) {
            this.endRange = endRange;
        }
    }
}

