/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class NetworkUtil {
    public static String getIpv4HostAddress() throws Exception {
        return NetworkUtil.getHostAddress(true);
    }

    public static String getHostAddress() throws Exception {
        return NetworkUtil.getHostAddress(false);
    }

    private static String getHostAddress(boolean onlyIpv4) throws Exception {
        String ipv4 = "";
        String ipv6 = "";
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            if (ni.isLoopback()) continue;
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address instanceof Inet6Address) {
                    ipv6 = ipv6.length() == 0 ? address.getHostAddress() : ipv6;
                    continue;
                }
                if (NetworkUtil.isLinkLocal(address.getHostAddress())) {
                    ipv4 = ipv4.length() == 0 ? address.getHostAddress() : ipv4;
                    continue;
                }
                return address.getHostAddress();
            }
        }
        if (onlyIpv4) {
            return ipv4;
        }
        return ipv4.length() > 0 ? ipv4 : ipv6;
    }

    private static boolean isLinkLocal(String hostAddress) {
        return hostAddress.startsWith("169.254");
    }
}

