/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mirth.connect.util.HttpUtil;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OAuthCredentials {
    private static final int TIMEOUT = 10000;
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static Logger logger = LogManager.getLogger(OAuthCredentials.class);
    private String url;
    private String clientId;
    private String clientSecret;
    private OAuthToken oAuthToken;
    private AtomicBoolean tokenExpired;

    public OAuthCredentials(String url, String clientId, String clientSecret) {
        this.url = url;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenExpired = new AtomicBoolean(false);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuthToken getOAuthToken() {
        if (this.oAuthToken == null || this.tokenExpired.get()) {
            OAuthCredentials oAuthCredentials = this;
            synchronized (oAuthCredentials) {
                if (this.oAuthToken == null || this.tokenExpired.get()) {
                    this.oAuthToken = this.fetchBearerToken();
                }
            }
        }
        return this.oAuthToken;
    }

    public boolean isTokenExpired() {
        return this.tokenExpired.get();
    }

    public void setTokenExpired(boolean tokenExpired) {
        this.tokenExpired.set(tokenExpired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OAuthToken fetchBearerToken() {
        OAuthToken newOAuthToken;
        block6: {
            newOAuthToken = null;
            try {
                URL urlObj = new URL(this.url);
                HttpHost target = new HttpHost(urlObj.getHost(), 443, "https");
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.clientId, this.clientSecret);
                credsProvider.setCredentials(authScope, (Credentials)credentials);
                BasicAuthCache authCache = new BasicAuthCache();
                RegistryBuilder registryBuilder = RegistryBuilder.create();
                registryBuilder.register("Basic", (Object)new BasicSchemeFactory(CHARSET));
                authCache.put(target, (AuthScheme)new BasicScheme());
                HttpClientContext context = HttpClientContext.create();
                context.setCredentialsProvider((CredentialsProvider)credsProvider);
                context.setAuthSchemeRegistry((Lookup)registryBuilder.build());
                context.setAuthCache((AuthCache)authCache);
                context.setRequestConfig(RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).build());
                HttpClientBuilder clientBuilder = HttpClients.custom();
                HttpUtil.configureClientBuilder(clientBuilder);
                CloseableHttpClient client = clientBuilder.build();
                HttpPost request = new HttpPost(urlObj.getPath());
                ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
                parameters.add(new BasicNameValuePair("grant_type", "client_credentials"));
                ((HttpEntityEnclosingRequestBase)request).setEntity(EntityBuilder.create().setContentType(ContentType.APPLICATION_FORM_URLENCODED).setParameters(parameters).build());
                CloseableHttpResponse httpResponse = null;
                try {
                    httpResponse = client.execute(target, (HttpRequest)request, (HttpContext)context);
                    String responseContent = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)CHARSET);
                    newOAuthToken = new OAuthToken(responseContent);
                    this.tokenExpired.set(false);
                }
                catch (Exception e) {
                    try {
                        logger.error("Error attempting to retrieve OAuth bearer token.", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        HttpUtil.closeVeryQuietly(httpResponse);
                        throw throwable;
                    }
                    HttpUtil.closeVeryQuietly(httpResponse);
                    break block6;
                }
                HttpUtil.closeVeryQuietly(httpResponse);
            }
            catch (Exception e) {
                logger.error("Error attempting to retrieve OAuth bearer token.", (Throwable)e);
            }
        }
        return newOAuthToken;
    }

    public static class OAuthToken {
        private String accessToken;
        private String tokenType;
        private long expiresIn;

        public OAuthToken(String accessToken, String tokenType, long expiresIn) {
            this.accessToken = accessToken;
            this.tokenType = tokenType;
            this.expiresIn = expiresIn;
        }

        public OAuthToken(String jsonResponse) {
            ObjectMapper mapper = new ObjectMapper(new JsonFactory());
            try {
                JsonNode json = mapper.readTree(jsonResponse);
                this.accessToken = json.get("access_token").textValue();
                this.tokenType = json.get("token_type").textValue();
                this.expiresIn = json.get("expires_in").longValue();
            }
            catch (Exception e) {
                logger.error("Error constructing OAuthToken from JSON response.", (Throwable)e);
            }
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public long getExpiresIn() {
            return this.expiresIn;
        }
    }

    public static class ExpiredBearerTokenException
    extends Exception {
        public ExpiredBearerTokenException(String message) {
            super(message);
        }
    }
}

