/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import com.google.common.base.Predicate;
import java.util.regex.Pattern;

public class PackagePredicate
implements Predicate<String> {
    private Pattern pattern;

    public PackagePredicate(String ... packageNames) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < packageNames.length; ++i) {
            builder.append(packageNames[i].replaceAll("\\.", "[\\\\./]")).append("(?![\\./]v\\d+).*");
            if (i >= packageNames.length - 1) continue;
            builder.append('|');
        }
        this.pattern = Pattern.compile(builder.toString());
    }

    public boolean apply(String input) {
        return this.pattern.matcher(input).find();
    }
}

