/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Pre22PasswordChecker {
    private static final int SALT_LENGTH = 12;
    private static final String SALT_PREFIX = "SALT_";

    public static boolean checkPassword(String plainPassword, String encodedPassword) throws Exception {
        String saltHash = StringUtils.substringAfter((String)encodedPassword, (String)SALT_PREFIX);
        String encodedSalt = StringUtils.substring((String)saltHash, (int)0, (int)12);
        byte[] decodedSalt = Base64.decodeBase64((String)encodedSalt);
        byte[] decodedHash = Base64.decodeBase64((String)StringUtils.substring((String)saltHash, (int)encodedSalt.length()));
        return Arrays.equals(decodedHash, DigestUtils.sha((byte[])ArrayUtils.addAll((byte[])decodedSalt, (byte[])plainPassword.getBytes())));
    }

    public static boolean isPre22Hash(String hash) {
        return StringUtils.startsWith((CharSequence)hash, (CharSequence)SALT_PREFIX);
    }
}

