/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.util.MirthSSLUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;

public class ServerSMTPConnection {
    private String host;
    private String port;
    private boolean useAuthentication;
    private String secure;
    private String username;
    private String password;
    private String from;
    private int socketTimeout = 5000;

    public ServerSMTPConnection(String host, String port, int socketTimeout, boolean useAuthentication, String secure, String username, String password, String from) {
        this.host = host;
        this.port = port;
        this.socketTimeout = socketTimeout;
        this.useAuthentication = useAuthentication;
        this.secure = secure;
        this.username = username;
        this.password = password;
        this.from = from;
    }

    public ServerSMTPConnection(String host, String port, boolean useAuthentication, String secure, String username, String password, String from) {
        this(host, port, 5000, useAuthentication, secure, username, password, from);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public boolean isUseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean useAuthentication) {
        this.useAuthentication = useAuthentication;
    }

    public String getSecure() {
        return this.secure;
    }

    public void setSecure(String secure) {
        this.secure = secure;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void send(String toList, String ccList, String from, String subject, String body, String charset) throws EmailException {
        SimpleEmail email = new SimpleEmail();
        if (StringUtils.isNotBlank((CharSequence)charset)) {
            email.setCharset(charset);
        }
        email.setHostName(this.host);
        email.setSmtpPort(Integer.parseInt(this.port));
        email.setSocketConnectionTimeout(this.socketTimeout);
        if (this.useAuthentication) {
            email.setAuthentication(this.username, this.password);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.secure, (CharSequence)"TLS")) {
            email.setStartTLSEnabled(true);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.secure, (CharSequence)"SSL")) {
            email.setSSLOnConnect(true);
            email.setSslSmtpPort(this.port);
        }
        ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
        email.getMailSession().getProperties().setProperty("mail.smtp.ssl.protocols", StringUtils.join((Object[])MirthSSLUtil.getEnabledHttpsProtocols(configurationController.getHttpsClientProtocols()), (char)' '));
        email.getMailSession().getProperties().setProperty("mail.smtp.ssl.ciphersuites", StringUtils.join((Object[])MirthSSLUtil.getEnabledHttpsCipherSuites(configurationController.getHttpsCipherSuites()), (char)' '));
        for (String to : StringUtils.split((String)toList, (String)",")) {
            email.addTo(to);
        }
        if (StringUtils.isNotEmpty((CharSequence)ccList)) {
            for (String cc : StringUtils.split((String)ccList, (String)",")) {
                email.addCc(cc);
            }
        }
        email.setFrom(from);
        email.setSubject(subject);
        email.setMsg(body);
        email.send();
    }

    public void send(String toList, String ccList, String from, String subject, String body) throws EmailException {
        this.send(toList, ccList, from, subject, body, null);
    }

    public void send(String toList, String ccList, String subject, String body) throws EmailException {
        this.send(toList, ccList, this.from, subject, body);
    }
}

