/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import com.mirth.connect.server.util.DatabaseUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class StatementLock {
    private boolean vacuumLockRequired;
    private ReadWriteLock vacuumLock;
    private static Map<String, StatementLock> instances = new ConcurrentHashMap<String, StatementLock>();

    private StatementLock(boolean lockRequired) {
        this.vacuumLockRequired = lockRequired;
        this.vacuumLock = lockRequired ? new ReentrantReadWriteLock(true) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatementLock getInstance(String statementId) {
        StatementLock statementLock = instances.get(statementId);
        if (statementLock != null) {
            return statementLock;
        }
        Class<StatementLock> clazz = StatementLock.class;
        synchronized (StatementLock.class) {
            statementLock = instances.get(statementId);
            if (statementLock != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return statementLock;
            }
            statementLock = new StatementLock(DatabaseUtil.statementExists(statementId));
            instances.put(statementId, statementLock);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return statementLock;
        }
    }

    public void readLock() {
        if (this.vacuumLockRequired) {
            this.vacuumLock.readLock().lock();
        }
    }

    public void readUnlock() {
        if (this.vacuumLockRequired) {
            this.vacuumLock.readLock().unlock();
        }
    }

    public void writeLock() {
        if (this.vacuumLockRequired) {
            this.vacuumLock.writeLock().lock();
        }
    }

    public void writeUnlock() {
        if (this.vacuumLockRequired) {
            this.vacuumLock.writeLock().unlock();
        }
    }
}

