/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.util.GlobalChannelVariableStoreFactory;
import com.mirth.connect.server.util.GlobalVariableStore;
import com.mirth.connect.util.ValueReplacer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;

public class TemplateValueReplacer
extends ValueReplacer {
    public String replaceValues(String template, String channelId, String channelName) {
        if (TemplateValueReplacer.hasReplaceableValues(template)) {
            VelocityContext context = this.getDefaultContext();
            context.put("channelId", (Object)channelId);
            context.put("channelName", (Object)channelName);
            this.loadContextFromMap(context, GlobalChannelVariableStoreFactory.getInstance().get(channelId).getVariables());
            return this.evaluate(context, template);
        }
        return template;
    }

    public Map<String, String> replaceValues(Map<String, String> template, String channelId, String channelName) {
        HashMap<String, String> replacedTemplate = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : template.entrySet()) {
            replacedTemplate.put(entry.getKey(), this.replaceValues(entry.getValue(), channelId, channelName));
        }
        return replacedTemplate;
    }

    public String replaceValues(String template, String channelId, Map<String, Object> map) {
        if (TemplateValueReplacer.hasReplaceableValues(template)) {
            VelocityContext context = this.getDefaultContext();
            context.put("channelId", (Object)channelId);
            this.loadContextFromMap(context, GlobalChannelVariableStoreFactory.getInstance().get(channelId).getVariables());
            this.loadContextFromMap(context, map);
            return this.evaluate(context, template);
        }
        return template;
    }

    public String replaceValues(String template, String channelId, String channelName, Map<String, Object> map) {
        if (TemplateValueReplacer.hasReplaceableValues(template)) {
            VelocityContext context = this.getDefaultContext();
            context.put("channelId", (Object)channelId);
            context.put("channelName", (Object)channelName);
            this.loadContextFromMap(context, GlobalChannelVariableStoreFactory.getInstance().get(channelId).getVariables());
            this.loadContextFromMap(context, map);
            return this.evaluate(context, template);
        }
        return template;
    }

    public void replaceValuesInList(List<String> list, String channelId, String channelName) {
        for (int i = 0; i <= list.size() - 1; ++i) {
            list.set(i, this.replaceValues(list.get(i), channelId, channelName));
        }
    }

    public Map<String, List<String>> replaceKeysAndValuesInMap(Map<String, List<String>> map, String channelId, String channelName) {
        HashMap<String, List<String>> localMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String key = this.replaceValues(entry.getKey(), channelId, channelName);
            ArrayList<String> list = new ArrayList<String>((Collection)entry.getValue());
            this.replaceValuesInList(list, channelId, channelName);
            localMap.put(key, list);
        }
        return localMap;
    }

    @Override
    protected VelocityContext getDefaultContext() {
        VelocityContext context = super.getDefaultContext();
        this.loadContextFromMap(context, ConfigurationController.getInstance().getConfigurationMap());
        this.loadContextFromMap(context, GlobalVariableStore.getInstance().getVariables());
        return context;
    }

    @Override
    protected void loadContextFromConnectorMessage(VelocityContext context, ConnectorMessage connectorMessage) {
        this.loadContextFromMap(context, GlobalChannelVariableStoreFactory.getInstance().get(connectorMessage.getChannelId()).getVariables());
        super.loadContextFromConnectorMessage(context, connectorMessage);
    }

    @Override
    protected void loadContextFromMessage(VelocityContext context, Message message) {
        this.loadContextFromMap(context, GlobalChannelVariableStoreFactory.getInstance().get(message.getChannelId()).getVariables());
        super.loadContextFromMessage(context, message);
    }
}

