/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util.javascript;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.attachment.AttachmentException;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.util.Base64Util;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.server.MirthJavascriptTransformerException;
import com.mirth.connect.server.MirthScopeProvider;
import com.mirth.connect.server.builders.JavaScriptBuilder;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.ScriptCompileException;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.userutil.Attachment;
import com.mirth.connect.server.util.CompiledScriptCache;
import com.mirth.connect.server.util.ServerUUIDGenerator;
import com.mirth.connect.server.util.javascript.JavaScriptExecutorException;
import com.mirth.connect.server.util.javascript.JavaScriptScopeUtil;
import com.mirth.connect.server.util.javascript.JavaScriptTask;
import com.mirth.connect.server.util.javascript.MirthContext;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import com.mirth.connect.server.util.javascript.MirthJavaScriptThreadFactory;
import com.mirth.connect.userutil.ImmutableConnectorMessage;
import com.mirth.connect.userutil.Response;
import com.mirth.connect.userutil.Status;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.tools.debugger.MirthMain;

public class JavaScriptUtil {
    private static Logger logger = LogManager.getLogger(JavaScriptUtil.class);
    private static CompiledScriptCache compiledScriptCache = CompiledScriptCache.getInstance();
    private static final int SOURCE_CODE_LINE_WRAPPER = 5;
    private static final RejectedExecutionHandler defaultHandler = new ThreadPoolExecutor.AbortPolicy();
    private static ExecutorService executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new MirthJavaScriptThreadFactory(), defaultHandler);
    private static ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private static volatile String globalScriptContextFactoryId = null;
    private static String serverId = ControllerFactory.getFactory().createConfigurationController().getServerId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(JavaScriptTask<T> task) throws JavaScriptExecutorException, InterruptedException {
        Future<T> future = executor.submit(task);
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            throw new JavaScriptExecutorException(e.getCause());
        }
        catch (InterruptedException e) {
            JavaScriptTask<T> javaScriptTask = task;
            synchronized (javaScriptTask) {
                future.cancel(true);
                Context context = task.getContext();
                if (context != null && context instanceof MirthContext) {
                    ((MirthContext)context).setRunning(false);
                }
            }
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    public static String executeAttachmentScript(MirthContextFactory contextFactory, RawMessage message, final String channelId, final String channelName, final List<Attachment> attachments) throws InterruptedException, AttachmentException, JavaScriptExecutorException {
        String resultString;
        final boolean isBinary = message.isBinary();
        if (isBinary) {
            try {
                String messageData = StringUtils.newStringUsAscii((byte[])Base64Util.encodeBase64((byte[])message.getRawBytes()));
                message.clearMessage();
                message = new RawMessage(messageData, message.getDestinationMetaDataIds(), message.getSourceMap());
            }
            catch (Throwable t) {
                throw new AttachmentException(t);
            }
        }
        final RawMessage finalMessage = message;
        String processedMessage = message.getRawData();
        Object result = null;
        try {
            result = JavaScriptUtil.execute(new JavaScriptTask<Object>(contextFactory, "Attachment", channelId, channelName){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object doCall() throws Exception {
                    Logger scriptLogger = LogManager.getLogger((String)"Attachment".toLowerCase());
                    try {
                        Scriptable scope = JavaScriptScopeUtil.getAttachmentScope(this.getContextFactory(), scriptLogger, channelId, channelName, finalMessage, attachments, isBinary);
                        Object object = JavaScriptUtil.executeScript(this, ScriptController.getScriptId("Attachment", channelId), scope, null, null);
                        return object;
                    }
                    finally {
                        Context.exit();
                    }
                }
            });
        }
        catch (JavaScriptExecutorException e) {
            JavaScriptUtil.logScriptError("Attachment", channelId, e.getCause());
            throw e;
        }
        if (result != null && (resultString = (String)Context.jsToJava((Object)result, String.class)) != null) {
            processedMessage = resultString;
        }
        return processedMessage;
    }

    public static String executeJavaScriptPreProcessorTask(JavaScriptTask<Object> task, String channelId) throws InterruptedException, JavaScriptExecutorException {
        String channelScriptId = ScriptController.getScriptId("Preprocessor", channelId);
        if (compiledScriptCache.getCompiledScript(channelScriptId) != null || compiledScriptCache.getCompiledScript("Preprocessor") != null) {
            return (String)JavaScriptUtil.execute(task);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executePreprocessorScripts(JavaScriptTask<Object> task, ConnectorMessage message, Map<String, Integer> destinationIdMap, MirthScopeProvider scopeProvider) throws Exception {
        Object result;
        String processedMessage = null;
        String globalResult = message.getRaw().getContent();
        Logger scriptLogger = LogManager.getLogger((String)"Preprocessor".toLowerCase());
        try {
            String resultString;
            result = null;
            if (compiledScriptCache.getCompiledScript("Preprocessor") != null) {
                MirthContextFactory contextFactory = task.getContextFactory();
                MirthContextFactory globalScriptContextFactory = JavaScriptUtil.getGlobalScriptContextFactory();
                try {
                    Scriptable scope = JavaScriptScopeUtil.getPreprocessorScope(globalScriptContextFactory, scriptLogger, message.getChannelId(), message.getRaw().getContent(), new ImmutableConnectorMessage(message, true, destinationIdMap));
                    if (scopeProvider != null) {
                        scopeProvider.setScope(scope);
                    }
                    task.setContextFactory(globalScriptContextFactory);
                    result = JavaScriptUtil.executeScript(task, "Preprocessor", scope, null, null);
                }
                finally {
                    Context.exit();
                    task.setContextFactory(contextFactory);
                }
            }
            if (result != null && (resultString = (String)Context.jsToJava(result, String.class)) != null) {
                globalResult = processedMessage = resultString;
            }
        }
        catch (Exception e) {
            JavaScriptUtil.logScriptError("Preprocessor", message.getChannelId(), e);
            throw e;
        }
        try {
            String resultString;
            result = null;
            String scriptId = ScriptController.getScriptId("Preprocessor", message.getChannelId());
            if (compiledScriptCache.getCompiledScript(scriptId) != null) {
                try {
                    Scriptable scope = JavaScriptScopeUtil.getPreprocessorScope(task.getContextFactory(), scriptLogger, message.getChannelId(), globalResult, new ImmutableConnectorMessage(message, true, destinationIdMap));
                    result = JavaScriptUtil.executeScript(task, scriptId, scope, null, null);
                }
                finally {
                    Context.exit();
                }
            }
            if (result != null && (resultString = (String)Context.jsToJava(result, String.class)) != null) {
                processedMessage = resultString;
            }
        }
        catch (Exception e) {
            JavaScriptUtil.logScriptError("Preprocessor", message.getChannelId(), e);
            throw e;
        }
        return processedMessage;
    }

    public static com.mirth.connect.donkey.model.message.Response executeJavaScriptPostProcessorTask(JavaScriptTask<Object> task, String channelId) throws InterruptedException, JavaScriptExecutorException {
        String channelScriptId = ScriptController.getScriptId("Postprocessor", channelId);
        if (compiledScriptCache.getCompiledScript(channelScriptId) != null || compiledScriptCache.getCompiledScript("Postprocessor") != null) {
            return (com.mirth.connect.donkey.model.message.Response)JavaScriptUtil.execute(task);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static com.mirth.connect.donkey.model.message.Response executePostprocessorScripts(JavaScriptTask<Object> task, Message message) throws Exception {
        com.mirth.connect.donkey.model.message.Response response;
        block12: {
            com.mirth.connect.donkey.model.message.Response channelResponse;
            Logger scriptLogger;
            block11: {
                scriptLogger = LogManager.getLogger((String)"Postprocessor".toLowerCase());
                channelResponse = null;
                try {
                    String scriptId = ScriptController.getScriptId("Postprocessor", message.getChannelId());
                    if (compiledScriptCache.getCompiledScript(scriptId) == null) break block11;
                    try {
                        Scriptable scope = JavaScriptScopeUtil.getPostprocessorScope(task.getContextFactory(), scriptLogger, message.getChannelId(), message);
                        channelResponse = JavaScriptUtil.getPostprocessorResponse(JavaScriptUtil.executeScript(task, scriptId, scope, null, null));
                    }
                    finally {
                        Context.exit();
                    }
                }
                catch (Exception e) {
                    JavaScriptUtil.logScriptError("Postprocessor", message.getChannelId(), e);
                    throw e;
                }
            }
            response = channelResponse;
            try {
                if (compiledScriptCache.getCompiledScript("Postprocessor") == null) break block12;
                MirthContextFactory globalScriptContextFactory = JavaScriptUtil.getGlobalScriptContextFactory();
                try {
                    Scriptable scope = JavaScriptScopeUtil.getPostprocessorScope(globalScriptContextFactory, scriptLogger, message.getChannelId(), message, channelResponse == null ? null : new Response(channelResponse));
                    task.setContextFactory(globalScriptContextFactory);
                    com.mirth.connect.donkey.model.message.Response globalResponse = JavaScriptUtil.getPostprocessorResponse(JavaScriptUtil.executeScript(task, "Postprocessor", scope, null, null));
                    if (globalResponse != null) {
                        response = globalResponse;
                    }
                }
                finally {
                    Context.exit();
                }
            }
            catch (Exception e) {
                JavaScriptUtil.logScriptError("Postprocessor", message.getChannelId(), e);
                throw e;
            }
        }
        return response;
    }

    private static com.mirth.connect.donkey.model.message.Response getPostprocessorResponse(Object result) {
        com.mirth.connect.donkey.model.message.Response response = null;
        if (result instanceof Response) {
            response = JavaScriptUtil.convertToDonkeyResponse(result);
        } else if (result instanceof NativeJavaObject) {
            Object object = ((NativeJavaObject)result).unwrap();
            response = object instanceof Response ? JavaScriptUtil.convertToDonkeyResponse(object) : new com.mirth.connect.donkey.model.message.Response(com.mirth.connect.donkey.model.message.Status.SENT, object.toString());
        } else if (result != null && !(result instanceof Undefined)) {
            response = new com.mirth.connect.donkey.model.message.Response(com.mirth.connect.donkey.model.message.Status.SENT, result.toString());
        }
        return response;
    }

    public static com.mirth.connect.donkey.model.message.Response convertToDonkeyResponse(Object response) {
        Response userResponse = (Response)response;
        return new com.mirth.connect.donkey.model.message.Response(JavaScriptUtil.convertToDonkeyStatus(userResponse.getStatus()), userResponse.getMessage(), userResponse.getStatusMessage(), userResponse.getError());
    }

    public static com.mirth.connect.donkey.model.message.Status convertToDonkeyStatus(Status status) {
        switch (status) {
            case RECEIVED: {
                return com.mirth.connect.donkey.model.message.Status.RECEIVED;
            }
            case FILTERED: {
                return com.mirth.connect.donkey.model.message.Status.FILTERED;
            }
            case TRANSFORMED: {
                return com.mirth.connect.donkey.model.message.Status.TRANSFORMED;
            }
            case SENT: {
                return com.mirth.connect.donkey.model.message.Status.SENT;
            }
            case QUEUED: {
                return com.mirth.connect.donkey.model.message.Status.QUEUED;
            }
            case ERROR: {
                return com.mirth.connect.donkey.model.message.Status.ERROR;
            }
            case PENDING: {
                return com.mirth.connect.donkey.model.message.Status.PENDING;
            }
        }
        return null;
    }

    public static void executeChannelDebugDeployScript(MirthContextFactory contextFactory, final String scriptId, final String scriptType, final String channelId, final String channelName, final MirthScopeProvider scopeProvider) throws InterruptedException, JavaScriptExecutorException {
        try {
            JavaScriptUtil.execute(new JavaScriptTask<Object>(contextFactory, scriptType, channelId, channelName){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object doCall() throws Exception {
                    Logger scriptLogger = LogManager.getLogger((String)scriptType.toLowerCase());
                    try {
                        Scriptable scope = JavaScriptScopeUtil.getDeployScope(this.getContextFactory(), scriptLogger, channelId, channelName);
                        scopeProvider.setScope(scope);
                        JavaScriptUtil.executeScript(this, scriptId, scope, channelId, null);
                        Object var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        Context.exit();
                    }
                }
            });
        }
        catch (JavaScriptExecutorException e) {
            JavaScriptUtil.logScriptError(scriptId, channelId, e.getCause());
            throw e;
        }
    }

    public static void executeChannelDeployScript(MirthContextFactory contextFactory, final String scriptId, final String scriptType, final String channelId, final String channelName) throws InterruptedException, JavaScriptExecutorException {
        try {
            JavaScriptUtil.execute(new JavaScriptTask<Object>(contextFactory, scriptType, channelId, channelName){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object doCall() throws Exception {
                    Logger scriptLogger = LogManager.getLogger((String)scriptType.toLowerCase());
                    try {
                        Scriptable scope = JavaScriptScopeUtil.getDeployScope(this.getContextFactory(), scriptLogger, channelId, channelName);
                        JavaScriptUtil.executeScript(this, scriptId, scope, channelId, null);
                        Object var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        Context.exit();
                    }
                }
            });
        }
        catch (JavaScriptExecutorException e) {
            JavaScriptUtil.logScriptError(scriptId, channelId, e.getCause());
            throw e;
        }
    }

    public static void executeChannelUndeployScript(MirthContextFactory contextFactory, final String scriptId, final String scriptType, final String channelId, final String channelName) throws InterruptedException, JavaScriptExecutorException {
        try {
            JavaScriptUtil.execute(new JavaScriptTask<Object>(contextFactory, scriptType, channelId, channelName){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object doCall() throws Exception {
                    Logger scriptLogger = LogManager.getLogger((String)scriptType.toLowerCase());
                    try {
                        Scriptable scope = JavaScriptScopeUtil.getUndeployScope(this.getContextFactory(), scriptLogger, channelId, channelName);
                        JavaScriptUtil.executeScript(this, scriptId, scope, channelId, null);
                        Object var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        Context.exit();
                    }
                }
            });
        }
        catch (JavaScriptExecutorException e) {
            JavaScriptUtil.logScriptError(scriptId, channelId, e.getCause());
            throw e;
        }
    }

    public static void executeChannelDebugUndeployScript(MirthContextFactory contextFactory, final String scriptId, final String scriptType, final String channelId, final String channelName, final MirthScopeProvider scopeProvider) throws InterruptedException, JavaScriptExecutorException {
        try {
            JavaScriptUtil.execute(new JavaScriptTask<Object>(contextFactory, scriptType, channelId, channelName){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object doCall() throws Exception {
                    Logger scriptLogger = LogManager.getLogger((String)scriptType.toLowerCase());
                    try {
                        Scriptable scope = JavaScriptScopeUtil.getUndeployScope(this.getContextFactory(), scriptLogger, channelId, channelName);
                        scopeProvider.setScope(scope);
                        JavaScriptUtil.executeScript(this, scriptId, scope, channelId, null);
                        Object var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        Context.exit();
                    }
                }
            });
        }
        catch (JavaScriptExecutorException e) {
            JavaScriptUtil.logScriptError(scriptId, channelId, e.getCause());
            throw e;
        }
    }

    public static void executeGlobalDeployScript(final String scriptId) throws InterruptedException, JavaScriptExecutorException {
        try {
            JavaScriptUtil.execute(new JavaScriptTask<Object>(JavaScriptUtil.getGlobalScriptContextFactory(), "Global Deploy"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object doCall() throws Exception {
                    Logger scriptLogger = LogManager.getLogger((String)scriptId.toLowerCase());
                    try {
                        Scriptable scope = JavaScriptScopeUtil.getDeployScope(this.getContextFactory(), scriptLogger);
                        JavaScriptUtil.executeScript(this, scriptId, scope, null, null);
                        Object var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        Context.exit();
                    }
                }
            });
        }
        catch (Exception e2) {
            JavaScriptExecutorException e2;
            if (!(e2 instanceof JavaScriptExecutorException)) {
                e2 = new JavaScriptExecutorException(e2);
            }
            JavaScriptUtil.logScriptError(scriptId, null, e2.getCause());
            throw e2;
        }
    }

    public static void executeGlobalUndeployScript(final String scriptId) throws InterruptedException, JavaScriptExecutorException {
        try {
            JavaScriptUtil.execute(new JavaScriptTask<Object>(JavaScriptUtil.getGlobalScriptContextFactory(), "Global Undeploy"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object doCall() throws Exception {
                    Logger scriptLogger = LogManager.getLogger((String)scriptId.toLowerCase());
                    try {
                        Scriptable scope = JavaScriptScopeUtil.getUndeployScope(this.getContextFactory(), scriptLogger);
                        JavaScriptUtil.executeScript(this, scriptId, scope, null, null);
                        Object var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        Context.exit();
                    }
                }
            });
        }
        catch (Exception e2) {
            JavaScriptExecutorException e2;
            if (!(e2 instanceof JavaScriptExecutorException)) {
                e2 = new JavaScriptExecutorException(e2);
            }
            JavaScriptUtil.logScriptError(scriptId, null, e2.getCause());
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MirthContextFactory getGlobalScriptContextFactory() throws Exception {
        MirthContextFactory contextFactory = contextFactoryController.getGlobalScriptContextFactory();
        if (contextFactory.getId().equals(globalScriptContextFactoryId)) return contextFactory;
        Class<JavaScriptUtil> clazz = JavaScriptUtil.class;
        synchronized (JavaScriptUtil.class) {
            contextFactory = contextFactoryController.getGlobalScriptContextFactory();
            if (contextFactory.getId().equals(globalScriptContextFactoryId)) return contextFactory;
            ControllerFactory.getFactory().createScriptController().compileGlobalScripts(contextFactory, false);
            globalScriptContextFactoryId = contextFactory.getId();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return contextFactory;
        }
    }

    private static void logScriptError(String scriptType, String channelId, Throwable t) {
        EventController eventController = ControllerFactory.getFactory().createEventController();
        String error = "Error executing " + scriptType + " script from channel: ";
        error = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)channelId) ? error + channelId : error + "Global";
        ServerEvent event = new ServerEvent(serverId, error);
        event.setLevel(ServerEvent.Level.ERROR);
        event.getAttributes().put("Exception", ExceptionUtils.getStackTrace((Throwable)t));
        eventController.dispatchEvent(event);
        logger.error(error, t);
    }

    public static Object executeScript(JavaScriptTask<Object> task, String scriptId, Scriptable scope, String channelId, String connectorName) throws Exception {
        Script compiledScript = compiledScriptCache.getCompiledScript(scriptId);
        if (compiledScript == null) {
            return null;
        }
        try {
            logger.debug("executing script: id=" + scriptId);
            return task.executeScript(compiledScript, scope);
        }
        catch (Exception e2) {
            MirthJavascriptTransformerException e2;
            if (e2 instanceof RhinoException) {
                String script = compiledScriptCache.getSourceScript(scriptId);
                String sourceCode = JavaScriptUtil.getSourceCode(script, ((RhinoException)e2).lineNumber(), 0);
                e2 = new MirthJavascriptTransformerException((RhinoException)e2, channelId, connectorName, 0, null, sourceCode);
            }
            throw e2;
        }
    }

    public static Script getCompiledGlobalSealedScript(Context context) {
        return JavaScriptUtil.compileScript(context, JavaScriptBuilder.generateGlobalSealedScript());
    }

    private static Script compileScript(Context context, String script) {
        return JavaScriptUtil.compileScript(context, script, ServerUUIDGenerator.getUUID());
    }

    private static Script compileScript(Context context, String script, String scriptId) {
        return context.compileString(script, scriptId, 1, null);
    }

    public static void compileChannelScripts(MirthContextFactory contextFactory, Channel channel) throws ScriptCompileException {
        try {
            String deployScriptId = ScriptController.getScriptId("Deploy", channel.getId());
            String undeployScriptId = ScriptController.getScriptId("Undeploy", channel.getId());
            String preprocessorScriptId = ScriptController.getScriptId("Preprocessor", channel.getId());
            String postprocessorScriptId = ScriptController.getScriptId("Postprocessor", channel.getId());
            JavaScriptUtil.compileAndAddScript(channel.getId(), contextFactory, deployScriptId, channel.getDeployScript(), ContextType.CHANNEL_DEPLOY);
            JavaScriptUtil.compileAndAddScript(channel.getId(), contextFactory, undeployScriptId, channel.getUndeployScript(), ContextType.CHANNEL_UNDEPLOY);
            if (!JavaScriptUtil.compileAndAddScript(channel.getId(), contextFactory, preprocessorScriptId, channel.getPreprocessingScript(), ContextType.CHANNEL_PREPROCESSOR)) {
                logger.debug("removing " + preprocessorScriptId);
                JavaScriptUtil.removeScriptFromCache(preprocessorScriptId);
            }
            if (!JavaScriptUtil.compileAndAddScript(channel.getId(), contextFactory, postprocessorScriptId, channel.getPostprocessingScript(), ContextType.CHANNEL_POSTPROCESSOR)) {
                logger.debug("removing " + postprocessorScriptId);
                JavaScriptUtil.removeScriptFromCache(postprocessorScriptId);
            }
        }
        catch (Exception e) {
            throw new ScriptCompileException("Failed to compile scripts for channel " + channel.getId() + ".", e);
        }
    }

    public static void recompileChannelScript(MirthContextFactory contextFactory, String channelId, String scriptKey) throws ScriptCompileException {
        try {
            JavaScriptUtil.recompileGeneratedScript(contextFactory, ScriptController.getScriptId(scriptKey, channelId));
        }
        catch (Exception e) {
            throw new ScriptCompileException("Failed to compile scripts for channel " + channelId + ".", e);
        }
    }

    public static void compileGlobalScripts(MirthContextFactory contextFactory, Map<String, String> globalScripts) throws Exception {
        for (Map.Entry<String, String> entry : globalScripts.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            try {
                if (JavaScriptUtil.compileAndAddScript(null, contextFactory, key, value, ScriptController.getContextType(key))) continue;
                logger.debug("removing global " + key.toLowerCase());
                JavaScriptUtil.removeScriptFromCache(key);
            }
            catch (Exception e) {
                logger.error("Error compiling global script: " + key, (Throwable)e);
                throw e;
            }
        }
    }

    public static boolean compileAndAddScript(String channelId, MirthContextFactory contextFactory, String scriptId, String script, ContextType contextType) throws Exception {
        return JavaScriptUtil.compileAndAddScript(channelId, contextFactory, scriptId, script, contextType, null);
    }

    public static boolean compileAndAddScript(String channelId, MirthContextFactory contextFactory, String scriptId, String script, ContextType contextType, Set<String> scriptOptions) throws Exception {
        return JavaScriptUtil.compileAndAddScript(channelId, contextFactory, scriptId, script, contextType, scriptOptions, JavaScriptBuilder.generateDefaultKeyScript(ScriptController.getScriptKey(scriptId), ScriptController.isScriptGlobal(scriptId)));
    }

    public static boolean compileAndAddScript(String channelId, MirthContextFactory contextFactory, String scriptId, String script, ContextType contextType, Set<String> scriptOptions, String defaultScript) throws Exception {
        boolean scriptInserted = false;
        String generatedScript = null;
        Context context = JavaScriptScopeUtil.getContext(contextFactory);
        try {
            logger.debug("compiling script " + scriptId);
            String decompiledDefaultScript = null;
            if (defaultScript != null) {
                String generatedDefaultScript = JavaScriptBuilder.generateScript(channelId, defaultScript, scriptOptions, contextType);
                Script compiledDefaultScript = JavaScriptUtil.compileScript(context, generatedDefaultScript, scriptId);
                decompiledDefaultScript = context.decompileScript(compiledDefaultScript, 0);
            }
            generatedScript = JavaScriptBuilder.generateScript(channelId, script, scriptOptions, contextType);
            Script compiledScript = JavaScriptUtil.compileScript(context, generatedScript, scriptId);
            String decompiledScript = context.decompileScript(compiledScript, 0);
            if (defaultScript == null || !decompiledScript.equals(decompiledDefaultScript)) {
                logger.debug("adding script " + scriptId);
                compiledScriptCache.putCompiledScript(scriptId, compiledScript, generatedScript);
                scriptInserted = true;
            } else {
                logger.debug("removing script " + scriptId);
                compiledScriptCache.removeCompiledScript(scriptId);
            }
        }
        catch (EvaluatorException e) {
            if (e instanceof RhinoException) {
                String sourceCode = JavaScriptUtil.getSourceCode(generatedScript, e.lineNumber(), 0);
                MirthJavascriptTransformerException mjte = new MirthJavascriptTransformerException((RhinoException)e, null, null, 0, scriptId, sourceCode);
                throw new Exception(mjte);
            }
            throw new Exception(e);
        }
        finally {
            Context.exit();
        }
        return scriptInserted;
    }

    public static boolean recompileGeneratedScript(MirthContextFactory contextFactory, String scriptId) throws Exception {
        String generatedScript;
        boolean scriptInserted = false;
        if (scriptId != null && (generatedScript = compiledScriptCache.getSourceScript(scriptId)) != null) {
            Context context = JavaScriptScopeUtil.getContext(contextFactory);
            try {
                logger.debug("compiling script " + scriptId);
                Script compiledScript = JavaScriptUtil.compileScript(context, generatedScript, scriptId);
                logger.debug("adding script " + scriptId);
                compiledScriptCache.putCompiledScript(scriptId, compiledScript, generatedScript);
                scriptInserted = true;
            }
            catch (EvaluatorException e) {
                if (e instanceof RhinoException) {
                    String sourceCode = JavaScriptUtil.getSourceCode(generatedScript, e.lineNumber(), 0);
                    MirthJavascriptTransformerException mjte = new MirthJavascriptTransformerException((RhinoException)e, null, null, 0, scriptId, sourceCode);
                    throw new Exception(mjte);
                }
                throw new Exception(e);
            }
            finally {
                Context.exit();
            }
        }
        return scriptInserted;
    }

    public static void removeScriptFromCache(String scriptId) {
        if (compiledScriptCache.getCompiledScript(scriptId) != null) {
            compiledScriptCache.removeCompiledScript(scriptId);
        }
    }

    public static void removeChannelScriptsFromCache(String channelId) {
        JavaScriptUtil.removeScriptFromCache(ScriptController.getScriptId("Deploy", channelId));
        JavaScriptUtil.removeScriptFromCache(ScriptController.getScriptId("Undeploy", channelId));
        JavaScriptUtil.removeScriptFromCache(ScriptController.getScriptId("Preprocessor", channelId));
        JavaScriptUtil.removeScriptFromCache(ScriptController.getScriptId("Postprocessor", channelId));
        JavaScriptUtil.removeScriptFromCache(ScriptController.getScriptId("Attachment", channelId));
        JavaScriptUtil.removeScriptFromCache(ScriptController.getScriptId("Batch", channelId));
    }

    public static String getSourceCode(String script, int errorLineNumber, int offset) {
        String[] lines = script.split("\n");
        int startingLineNumber = errorLineNumber - offset;
        if (startingLineNumber <= 5) {
            startingLineNumber = 6;
        }
        StringBuilder source = new StringBuilder();
        for (int currentLineNumber = startingLineNumber - 5; currentLineNumber < startingLineNumber + 5 && currentLineNumber < lines.length; ++currentLineNumber) {
            source.append(System.getProperty("line.separator") + currentLineNumber + ": " + lines[currentLineNumber - 1]);
        }
        return source.toString();
    }

    public static void compileChannelScripts(Map<String, MirthContextFactory> contextFactories, Channel channel) {
        for (Map.Entry<String, MirthContextFactory> item : contextFactories.entrySet()) {
            String scriptIdString = item.getKey();
            MirthContextFactory factory = item.getValue();
            try {
                JavaScriptUtil.compileAndAddScript(channel.getId(), factory, scriptIdString, factory.getScriptText(), factory.getContextType(), null, null);
            }
            catch (Exception e) {
                logger.error("Error compiling channel scripts.", (Throwable)e);
            }
        }
    }

    public static MirthMain getDebugger(MirthContextFactory contextFactory, MirthScopeProvider scopeProvider, Channel channel, String scriptId) {
        return MirthMain.mirthMainEmbedded(contextFactory, scopeProvider, channel.getName() + "-" + channel.getId(), scriptId);
    }

    public static MirthMain getDebugger(MirthContextFactory contextFactory, MirthScopeProvider scopeProvider, Channel channel, String scriptId, boolean showDebugger) {
        return MirthMain.mirthMainEmbedded(contextFactory, scopeProvider, channel.getName() + "-" + channel.getId(), scriptId, showDebugger);
    }

    public static MirthMain getDebugger(MirthContextFactory contextFactory, MirthScopeProvider scopeProvider, com.mirth.connect.donkey.server.channel.Channel donkeychannel, String scriptId) {
        return MirthMain.mirthMainEmbedded(contextFactory, scopeProvider, donkeychannel.getName() + "-" + donkeychannel.getChannelId(), scriptId);
    }

    public static MirthMain getDebugger(MirthContextFactory contextFactory, MirthScopeProvider scopeProvider, com.mirth.connect.donkey.server.channel.Channel donkeychannel, String scriptId, boolean showDebugger) {
        return MirthMain.mirthMainEmbedded(contextFactory, scopeProvider, donkeychannel.getName() + "-" + donkeychannel.getChannelId(), scriptId, showDebugger);
    }

    public static void removeDebuggerFromMap(String channelId) {
        MirthMain.closeDebugger(channelId);
    }

    public static MirthContextFactory generateContextFactory(boolean debug, Set<String> libraryResourceIds, String channelId, String scriptId, String script, ContextType contextType) throws ConnectorTaskException {
        try {
            MirthContextFactory contextFactory;
            if (debug) {
                contextFactory = contextFactoryController.getDebugContextFactory(libraryResourceIds, channelId, scriptId);
                contextFactory.setContextType(contextType);
                contextFactory.setScriptText(script);
                contextFactory.setDebugType(debug);
            } else {
                contextFactory = contextFactoryController.getContextFactory(libraryResourceIds);
            }
            JavaScriptUtil.compileAndAddScript(channelId, contextFactory, scriptId, script, contextType);
            return contextFactory;
        }
        catch (Exception e) {
            throw new ConnectorTaskException("Error compiling generating context factory.", (Throwable)e);
        }
    }

    public static Object getCompiledScript(String scriptId) {
        return compiledScriptCache.getCompiledScript(scriptId);
    }
}

