/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util.javascript;

import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ScriptableObject;

public class MirthContext
extends Context {
    private static final int INSTRUCTION_THRESHOLD = 1;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private ScriptableObject sealedSharedScope;

    public MirthContext(MirthContextFactory contextFactory) {
        this(contextFactory, 0);
    }

    public MirthContext(MirthContextFactory contextFactory, int languageVersion) {
        super((ContextFactory)contextFactory);
        this.setInstructionObserverThreshold(1);
        this.sealedSharedScope = contextFactory.getSealedSharedScope();
        this.setLanguageVersion(languageVersion);
    }

    public void setRunning(boolean running) {
        this.running.set(running);
    }

    protected ScriptableObject getSealedSharedScope() {
        return this.sealedSharedScope;
    }

    protected void observeInstructionCount(int count) {
        if (!this.running.get()) {
            this.logger.debug("Halting JavaScript execution");
            throw new Error();
        }
    }
}

