/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util.javascript;

import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.util.ChildFirstURLClassLoader;
import com.mirth.connect.server.util.javascript.JavaScriptScopeUtil;
import com.mirth.connect.server.util.javascript.MirthContext;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ScriptableObject;

public class MirthContextFactory
extends ContextFactory {
    private String id = UUID.randomUUID().toString();
    private URL[] urls;
    private Set<String> resourceIds;
    private ScriptableObject sealedSharedScope;
    private ObjectXMLSerializer serializer;
    private ClassLoader isolatedClassLoader;
    private int languageVersion = 0;
    private String scriptText;
    private ContextType contextType;
    private Boolean debugType = false;

    public Boolean isDebug() {
        return this.debugType;
    }

    public void setDebugType(Boolean debug) {
        this.debugType = debug;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
    }

    public ContextType getContextType() {
        return this.contextType;
    }

    public void setContextType(ContextType contextType) {
        this.contextType = contextType;
    }

    public MirthContextFactory(URL[] urls, Set<String> resourceIds, boolean loadParentFirst) {
        this.urls = urls;
        this.resourceIds = resourceIds;
        ClassLoader classLoader = null;
        classLoader = ArrayUtils.isNotEmpty((Object[])urls) ? (loadParentFirst ? new URLClassLoader(urls, Thread.currentThread().getContextClassLoader()) : new ChildFirstURLClassLoader(urls, Thread.currentThread().getContextClassLoader())) : Thread.currentThread().getContextClassLoader();
        this.initApplicationClassLoader(classLoader);
        ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
        Integer rhinoLanguageVersion = configurationController.getRhinoLanguageVersion();
        if (rhinoLanguageVersion != null) {
            try {
                Context.checkLanguageVersion((int)rhinoLanguageVersion);
                this.languageVersion = rhinoLanguageVersion;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sealedSharedScope = JavaScriptScopeUtil.createSealedSharedScope(this);
        this.serializer = new ObjectXMLSerializer(classLoader);
        try {
            this.serializer.init(configurationController.getServerVersion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serializer.processAnnotations(ObjectXMLSerializer.getExtraAnnotatedClasses());
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getIsolatedClassLoader() {
        if (this.isolatedClassLoader == null && ArrayUtils.isNotEmpty((Object[])this.urls)) {
            MirthContextFactory mirthContextFactory = this;
            synchronized (mirthContextFactory) {
                if (this.isolatedClassLoader == null) {
                    this.isolatedClassLoader = new URLClassLoader(this.urls, null);
                }
            }
        }
        return this.isolatedClassLoader;
    }

    public ScriptableObject getSealedSharedScope() {
        return this.sealedSharedScope;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    protected Context makeContext() {
        return new MirthContext(this, this.languageVersion);
    }
}

