/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MirthJsonUtil {
    private static Logger logger = LogManager.getLogger(MirthJsonUtil.class);

    public static String prettyPrint(String input) {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
            prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
            JsonNode json = mapper.readTree(input);
            return mapper.writer((PrettyPrinter)prettyPrinter).writeValueAsString((Object)json);
        }
        catch (Exception e) {
            logger.warn("Error pretty printing json.", (Throwable)e);
            return input;
        }
    }

    public static String escape(String input) {
        return StringEscapeUtils.escapeJson((String)input);
    }
}

