/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.stream.impl;

import de.odysseus.staxon.json.stream.JsonStreamSource;
import de.odysseus.staxon.json.stream.JsonStreamToken;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

class JsonStreamSourceImpl
implements JsonStreamSource {
    private final Scanner scanner;
    private final boolean[] arrays = new boolean[64];
    private final boolean closeScanner;
    private JsonStreamToken token = null;
    private Scanner.Symbol symbol = null;
    private int depth = 0;
    private boolean peeked = false;
    private int lineNumber;
    private int columnNumber;
    private int charOffset;

    JsonStreamSourceImpl(Scanner scanner, boolean closeScanner) {
        this.scanner = scanner;
        this.closeScanner = closeScanner;
        this.lineNumber = scanner.getLineNumber();
        this.columnNumber = scanner.getColumnNumber();
        this.charOffset = scanner.getCharOffset();
    }

    private JsonStreamToken startJsonValue() throws IOException {
        switch (this.symbol) {
            case FALSE: 
            case NULL: 
            case NUMBER: 
            case TRUE: 
            case STRING: {
                return JsonStreamToken.VALUE;
            }
            case START_ARRAY: {
                if (this.arrays[this.depth]) {
                    throw new IOException("Already in an array");
                }
                this.arrays[this.depth] = true;
                return JsonStreamToken.START_ARRAY;
            }
            case START_OBJECT: {
                ++this.depth;
                return JsonStreamToken.START_OBJECT;
            }
        }
        throw new IOException("Unexpected symbol: " + (Object)((Object)this.symbol));
    }

    private void require(Scanner.Symbol expected) throws IOException {
        if (this.symbol != expected) {
            throw new IOException("Unexpected symbol:" + (Object)((Object)this.symbol));
        }
    }

    private JsonStreamToken next() throws IOException {
        this.symbol = this.scanner.nextSymbol();
        if (this.symbol == Scanner.Symbol.EOF) {
            if (this.depth != 0 || this.arrays[this.depth]) {
                throw new IOException("Premature EOF");
            }
            return JsonStreamToken.NONE;
        }
        if (this.token == null) {
            return this.startJsonValue();
        }
        switch (this.token) {
            case NAME: {
                this.require(Scanner.Symbol.COLON);
                this.symbol = this.scanner.nextSymbol();
                return this.startJsonValue();
            }
            case END_OBJECT: 
            case END_ARRAY: 
            case VALUE: {
                switch (this.symbol) {
                    case COMMA: {
                        this.symbol = this.scanner.nextSymbol();
                        if (this.arrays[this.depth]) {
                            return this.startJsonValue();
                        }
                        this.require(Scanner.Symbol.STRING);
                        return JsonStreamToken.NAME;
                    }
                    case END_ARRAY: {
                        if (!this.arrays[this.depth]) {
                            throw new IOException("Not in an array");
                        }
                        this.arrays[this.depth] = false;
                        return JsonStreamToken.END_ARRAY;
                    }
                    case END_OBJECT: {
                        if (this.arrays[this.depth]) {
                            throw new IOException("Unclosed array");
                        }
                        if (this.depth == 0) {
                            throw new IOException("Not in an object");
                        }
                        --this.depth;
                        return JsonStreamToken.END_OBJECT;
                    }
                }
                throw new IOException("Unexpected symbol: " + (Object)((Object)this.symbol));
            }
            case START_OBJECT: {
                switch (this.symbol) {
                    case END_OBJECT: {
                        --this.depth;
                        return JsonStreamToken.END_OBJECT;
                    }
                    case STRING: {
                        return JsonStreamToken.NAME;
                    }
                }
                throw new IOException("Unexpected symbol: " + (Object)((Object)this.symbol));
            }
            case START_ARRAY: {
                switch (this.symbol) {
                    case END_ARRAY: {
                        this.arrays[this.depth] = false;
                        return JsonStreamToken.END_ARRAY;
                    }
                }
                return this.startJsonValue();
            }
        }
        throw new IOException("Unexpected token: " + (Object)((Object)this.token));
    }

    @Override
    public void close() throws IOException {
        if (this.closeScanner) {
            this.scanner.close();
        }
    }

    private void poll(JsonStreamToken token) throws IOException {
        if (token != this.peek()) {
            throw new IOException("Unexpected token: " + (Object)((Object)this.peek()));
        }
        this.lineNumber = this.scanner.getLineNumber();
        this.columnNumber = this.scanner.getColumnNumber();
        this.charOffset = this.scanner.getCharOffset();
        this.peeked = false;
    }

    @Override
    public String name() throws IOException {
        this.poll(JsonStreamToken.NAME);
        return this.scanner.getText();
    }

    @Override
    public JsonStreamSource.Value value() throws IOException {
        this.poll(JsonStreamToken.VALUE);
        switch (this.symbol) {
            case NULL: {
                return NULL;
            }
            case STRING: {
                return new JsonStreamSource.Value(this.scanner.getText());
            }
            case TRUE: {
                return TRUE;
            }
            case FALSE: {
                return FALSE;
            }
            case NUMBER: {
                if (this.scanner.getText().indexOf(46) < 0 && this.scanner.getText().toLowerCase().indexOf(101) < 0) {
                    return new JsonStreamSource.Value(this.scanner.getText(), new BigInteger(this.scanner.getText()));
                }
                return new JsonStreamSource.Value(this.scanner.getText(), new BigDecimal(this.scanner.getText()));
            }
        }
        throw new IOException("Not a value token: " + (Object)((Object)this.symbol));
    }

    @Override
    public void startObject() throws IOException {
        this.poll(JsonStreamToken.START_OBJECT);
    }

    @Override
    public void endObject() throws IOException {
        this.poll(JsonStreamToken.END_OBJECT);
    }

    @Override
    public void startArray() throws IOException {
        this.poll(JsonStreamToken.START_ARRAY);
    }

    @Override
    public void endArray() throws IOException {
        this.poll(JsonStreamToken.END_ARRAY);
    }

    @Override
    public JsonStreamToken peek() throws IOException {
        if (!this.peeked) {
            this.token = this.next();
            this.peeked = true;
        }
        return this.token;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber + 1;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber + 1;
    }

    @Override
    public int getCharacterOffset() {
        return this.charOffset;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    static interface Scanner
    extends Closeable {
        public Symbol nextSymbol() throws IOException;

        public String getText();

        public int getCharOffset();

        public int getLineNumber();

        public int getColumnNumber();

        public static enum Symbol {
            START_OBJECT,
            END_OBJECT,
            START_ARRAY,
            END_ARRAY,
            COLON,
            COMMA,
            STRING,
            NUMBER,
            TRUE,
            FALSE,
            NULL,
            EOF;

        }
    }
}

