/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jms;

import com.mirth.connect.connectors.jms.JmsConnectorProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;

public class JmsTemplateListModel
extends AbstractListModel {
    private static JmsTemplateListModel instance;
    private List<String> templateNames = new ArrayList<String>();
    private Map<String, JmsConnectorProperties> templates;
    private Set<String> readOnlyTemplateNames = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JmsTemplateListModel getInstance() {
        Class<JmsTemplateListModel> clazz = JmsTemplateListModel.class;
        synchronized (JmsTemplateListModel.class) {
            if (instance == null) {
                instance = new JmsTemplateListModel();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private JmsTemplateListModel() {
        this.templates = new LinkedHashMap<String, JmsConnectorProperties>();
        JmsConnectorProperties properties = new JmsConnectorProperties();
        properties.setUseJndi(false);
        properties.setConnectionFactoryClass("org.apache.activemq.ActiveMQConnectionFactory");
        properties.getConnectionProperties().put("brokerURL", "failover:(tcp://localhost:61616)?maxReconnectAttempts=0");
        properties.getConnectionProperties().put("closeTimeout", "15000");
        properties.getConnectionProperties().put("useCompression", "no");
        this.templates.put("ActiveMQ", properties);
        properties = new JmsConnectorProperties();
        properties.setUseJndi(true);
        properties.setJndiProviderUrl("jnp://localhost:1099");
        properties.setJndiInitialContextFactory("org.jnp.interfaces.NamingContextFactory");
        properties.setJndiConnectionFactoryName("java:/ConnectionFactory");
        this.templates.put("JBoss Messaging / MQ", properties);
        this.templateNames.addAll(this.templates.keySet());
        this.readOnlyTemplateNames.addAll(this.templates.keySet());
    }

    public synchronized JmsConnectorProperties getTemplate(String templateName) {
        return this.templates.get(templateName);
    }

    public synchronized void putTemplate(String templateName, JmsConnectorProperties template) {
        if (this.isPredefinedTemplate(templateName)) {
            return;
        }
        int index = this.templateNames.size();
        if (!this.templateNames.contains(templateName)) {
            this.templateNames.add(templateName);
        }
        this.templates.put(templateName, template);
        this.fireIntervalAdded(this, index, index);
    }

    public synchronized void deleteTemplate(String templateName) {
        if (this.isPredefinedTemplate(templateName)) {
            return;
        }
        int index = this.templateNames.lastIndexOf(templateName);
        this.templateNames.remove(templateName);
        this.templates.remove(templateName);
        this.fireIntervalRemoved(this, index, index);
    }

    public synchronized boolean containsTemplate(String templateName) {
        return this.templateNames.contains(templateName);
    }

    public synchronized boolean isPredefinedTemplate(String templateName) {
        return this.readOnlyTemplateNames.contains(templateName);
    }

    @Override
    public synchronized int getSize() {
        return this.templateNames.size();
    }

    @Override
    public synchronized Object getElementAt(int index) {
        return this.templateNames.get(index);
    }
}

