/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.com;

import jcifs.Configuration;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;

public class SmbComRename
extends ServerMessageBlock {
    private int searchAttributes;
    private String oldFileName;
    private String newFileName;

    public SmbComRename(Configuration config, String oldFileName, String newFileName) {
        super(config, (byte)7);
        this.oldFileName = oldFileName;
        this.newFileName = newFileName;
        this.searchAttributes = 22;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        SMBUtil.writeInt2(this.searchAttributes, dst, dstIndex);
        return 2;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dst[dstIndex++] = 4;
        dstIndex += this.writeString(this.oldFileName, dst, dstIndex);
        dst[dstIndex++] = 4;
        if (this.isUseUnicode()) {
            dst[dstIndex++] = 0;
        }
        dstIndex += this.writeString(this.newFileName, dst, dstIndex);
        return dstIndex - start;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("SmbComRename[" + super.toString() + ",searchAttributes=0x" + Hexdump.toHexString(this.searchAttributes, 4) + ",oldFileName=" + this.oldFileName + ",newFileName=" + this.newFileName + "]");
    }
}

