/*
 * Decompiled with CFR 0.152.
 */
package jcifs.pac.kerberos;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import javax.security.auth.kerberos.KerberosKey;
import jcifs.pac.ASN1Util;
import jcifs.pac.PACDecodingException;
import jcifs.pac.kerberos.KerberosTicket;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;

public class KerberosApRequest {
    private byte apOptions;
    private KerberosTicket ticket;

    public KerberosApRequest(byte[] token, KerberosKey[] keys) throws PACDecodingException {
        this(KerberosApRequest.parseSequence(token), keys);
    }

    private static ASN1Sequence parseSequence(byte[] token) throws PACDecodingException {
        ASN1Sequence sequence;
        if (token.length <= 0) {
            throw new PACDecodingException("Empty kerberos ApReq");
        }
        try (ASN1InputStream stream = new ASN1InputStream((InputStream)new ByteArrayInputStream(token));){
            sequence = ASN1Util.as(ASN1Sequence.class, stream);
        }
        catch (IOException e) {
            throw new PACDecodingException("Malformed Kerberos Ticket", e);
        }
        return sequence;
    }

    public KerberosApRequest(ASN1Sequence seq, KerberosKey[] keys) throws PACDecodingException {
        Enumeration fields = seq.getObjects();
        block9: while (fields.hasMoreElements()) {
            ASN1TaggedObject tagged = ASN1Util.as(ASN1TaggedObject.class, fields.nextElement());
            switch (tagged.getTagNo()) {
                case 0: {
                    ASN1Integer pvno = ASN1Util.as(ASN1Integer.class, tagged);
                    if (pvno.getValue().equals(new BigInteger("5"))) continue block9;
                    throw new PACDecodingException("Invalid kerberos version");
                }
                case 1: {
                    ASN1Integer msgType = ASN1Util.as(ASN1Integer.class, tagged);
                    if (msgType.getValue().equals(new BigInteger("14"))) continue block9;
                    throw new PACDecodingException("Invalid kerberos request");
                }
                case 2: {
                    DERBitString bitString = ASN1Util.as(DERBitString.class, tagged);
                    this.apOptions = bitString.getBytes()[0];
                    continue block9;
                }
                case 3: {
                    ASN1TaggedObject derTicket = ASN1Util.as(ASN1TaggedObject.class, tagged);
                    if (derTicket.getTagClass() != 64) {
                        throw new PACDecodingException("Malformed Kerberos Ticket");
                    }
                    try {
                        this.ticket = new KerberosTicket(derTicket.getBaseObject().getEncoded(), this.apOptions, keys);
                        continue block9;
                    }
                    catch (IOException e) {
                        throw new PACDecodingException("Malformed Kerberos Ticket", e);
                    }
                }
                case 4: {
                    continue block9;
                }
            }
            throw new PACDecodingException("Invalid field in kerberos ticket");
        }
    }

    public byte getApOptions() {
        return this.apOptions;
    }

    public KerberosTicket getTicket() {
        return this.ticket;
    }
}

