/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.base;

import de.odysseus.staxon.base.Pair;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractXMLStreamScope
implements NamespaceContext {
    private final NamespaceContext parent;
    private final String prefix;
    private final String localName;
    private final String namespaceURI;
    private String defaultNamespace;
    private List<Attr> attributes;
    private List<Pair<String, String>> prefixes;
    private AbstractXMLStreamScope lastChild;
    private boolean startTagClosed;

    public AbstractXMLStreamScope(String defaultNamespace) {
        this.parent = null;
        this.prefix = null;
        this.localName = null;
        this.namespaceURI = "";
        this.defaultNamespace = defaultNamespace;
        this.startTagClosed = true;
    }

    public AbstractXMLStreamScope(NamespaceContext parent) {
        this.parent = parent;
        this.prefix = null;
        this.localName = null;
        this.namespaceURI = "";
        this.defaultNamespace = parent.getNamespaceURI("");
        this.startTagClosed = true;
    }

    public AbstractXMLStreamScope(AbstractXMLStreamScope parent, String prefix, String localName, String namespaceURI) {
        this.parent = parent;
        this.prefix = prefix;
        this.localName = localName;
        this.namespaceURI = namespaceURI;
        this.startTagClosed = false;
        this.defaultNamespace = parent.getNamespaceURI("");
        parent.lastChild = this;
        parent.startTagClosed = true;
    }

    void addAttribute(String prefix, String localName, String namespaceURI, String value) {
        if (this.attributes == null) {
            this.attributes = new LinkedList<Attr>();
        }
        this.attributes.add(new Attr(prefix, localName, namespaceURI, value));
    }

    List<Attr> getAttributes() {
        return this.attributes;
    }

    public String getPrefix() {
        return this.prefix == null ? this.getPrefix(this.namespaceURI) : this.prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI == null ? this.getNamespaceURI(this.prefix) : this.namespaceURI;
    }

    public boolean isRoot() {
        return this.localName == null;
    }

    public AbstractXMLStreamScope getParent() {
        return this.isRoot() ? null : (AbstractXMLStreamScope)this.parent;
    }

    public AbstractXMLStreamScope getLastChild() {
        return this.lastChild;
    }

    public boolean isStartTagClosed() {
        return this.startTagClosed;
    }

    private void verify() throws XMLStreamException {
        if (this.prefix == null) {
            if (!"".equals(this.namespaceURI) && this.getPrefix(this.namespaceURI) == null) {
                throw new XMLStreamException("No prefix for namespace URI: " + this.namespaceURI);
            }
        } else if (this.namespaceURI == null) {
            if (!"".equals(this.prefix) && "".equals(this.getNamespaceURI(this.prefix))) {
                throw new XMLStreamException("Unbound prefix: " + this.prefix);
            }
        } else if (!this.namespaceURI.equals(this.getNamespaceURI(this.prefix))) {
            if ("".equals(this.prefix)) {
                throw new XMLStreamException("Prefix required for namespace URI: '" + this.namespaceURI);
            }
            if ("".equals(this.namespaceURI)) {
                throw new XMLStreamException("Prefix '" + this.prefix + "' is bound to: " + this.getNamespaceURI(this.prefix));
            }
            throw new XMLStreamException("Prefix '" + this.prefix + "' is not bound to: " + this.namespaceURI);
        }
        if (this.attributes != null) {
            for (Attr attribute : this.attributes) {
                attribute.verify();
            }
        }
    }

    void setStartTagClosed(boolean startTagClosed) throws XMLStreamException {
        if (startTagClosed) {
            this.verify();
        }
        this.startTagClosed = startTagClosed;
    }

    private String findNonEmptyPrefix(String namespaceURI, AbstractXMLStreamScope descendent) {
        if (this.prefixes != null) {
            for (Pair<String, String> pair : this.prefixes) {
                if (!pair.getSecond().equals(namespaceURI) || descendent != this && !descendent.getNamespaceURI(pair.getFirst()).equals(namespaceURI)) continue;
                return pair.getFirst();
            }
        }
        if (this.isRoot()) {
            if (this.parent == null) {
                return null;
            }
            Iterator<String> prefixes = this.parent.getPrefixes(namespaceURI);
            while (prefixes.hasNext()) {
                String prefix = prefixes.next().toString();
                if ("".equals(prefix) || descendent != this && !descendent.getNamespaceURI(prefix).equals(namespaceURI)) continue;
                return prefix;
            }
            return null;
        }
        return this.getParent().findNonEmptyPrefix(namespaceURI, descendent);
    }

    String getNonEmptyPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Namespace URI must not be null");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return "xmlns";
        }
        return this.findNonEmptyPrefix(namespaceURI, this);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if ("".equals(namespaceURI)) {
            return null;
        }
        if (this.defaultNamespace.equals(namespaceURI)) {
            return "";
        }
        return this.getNonEmptyPrefix(namespaceURI);
    }

    public void setPrefix(String prefix, String namespaceURI) {
        if (prefix == null || namespaceURI == null) {
            throw new IllegalArgumentException("Prefix and namespace URI must not be null");
        }
        if ("".equals(prefix)) {
            this.defaultNamespace = namespaceURI;
        } else {
            if ("xml".equals(namespaceURI)) {
                throw new IllegalArgumentException("Cannot bind to prefix: " + prefix);
            }
            if ("xmlns".equals(namespaceURI)) {
                throw new IllegalArgumentException("Cannot bind to prefix: " + prefix);
            }
            if (this.prefixes == null) {
                this.prefixes = new LinkedList<Pair<String, String>>();
            } else {
                Iterator<Pair<String, String>> iterator = this.prefixes.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().getFirst().equals(prefix)) continue;
                    iterator.remove();
                }
            }
            this.prefixes.add(new Pair<String, String>(prefix, namespaceURI));
        }
    }

    @Override
    public Iterator<String> getPrefixes(final String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Namespace URI must not be null");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return Arrays.asList("xml").iterator();
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return Arrays.asList("xmlns").iterator();
        }
        return new Iterator<String>(){
            int state = 0;
            String next = null;
            Iterator<Pair<String, String>> pairs;
            Iterator<?> above;

            private String next0() {
                if (this.state == 0) {
                    this.state = 1;
                    if (namespaceURI.equals(AbstractXMLStreamScope.this.defaultNamespace)) {
                        return "";
                    }
                }
                if (this.state == 1) {
                    if (AbstractXMLStreamScope.this.prefixes != null) {
                        if (this.pairs == null) {
                            this.pairs = AbstractXMLStreamScope.this.prefixes.iterator();
                        }
                        while (this.pairs.hasNext()) {
                            Pair<String, String> pair = this.pairs.next();
                            if (!namespaceURI.equals(pair.getSecond())) continue;
                            return pair.getFirst();
                        }
                    }
                    this.state = 2;
                }
                if (this.state == 2) {
                    if (AbstractXMLStreamScope.this.parent != null) {
                        if (this.above == null) {
                            this.above = AbstractXMLStreamScope.this.parent.getPrefixes(namespaceURI);
                        }
                        while (this.above.hasNext()) {
                            String prefix = this.above.next().toString();
                            if (!AbstractXMLStreamScope.this.getNamespaceURI(prefix).equals(namespaceURI)) continue;
                            return prefix;
                        }
                    }
                    this.state = 3;
                }
                if (this.state == 3) {
                    return null;
                }
                throw new IllegalStateException();
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.next = this.next0();
                }
                return this.next != null;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove prefix");
            }
        };
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix must not be null");
        }
        if ("".equals(prefix)) {
            return this.defaultNamespace;
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.prefixes != null) {
            for (Pair<String, String> pair : this.prefixes) {
                if (!pair.getFirst().equals(prefix)) continue;
                return pair.getSecond();
            }
        }
        return this.parent == null ? "" : this.parent.getNamespaceURI(prefix);
    }

    class Attr {
        private final String prefix;
        private final String localName;
        private final String namespaceURI;
        private final String value;

        Attr(String prefix, String localName, String namespaceURI, String value) {
            this.prefix = prefix;
            this.localName = localName;
            this.namespaceURI = namespaceURI;
            this.value = value;
        }

        String getPrefix() {
            if (this.prefix != null) {
                return this.prefix;
            }
            if ("".equals(this.namespaceURI)) {
                return "";
            }
            return AbstractXMLStreamScope.this.getNonEmptyPrefix(this.namespaceURI);
        }

        String getLocalName() {
            return this.localName;
        }

        String getNamespaceURI() {
            if (this.namespaceURI != null) {
                return this.namespaceURI;
            }
            if ("".equals(this.prefix)) {
                return "";
            }
            return AbstractXMLStreamScope.this.getNamespaceURI(this.prefix);
        }

        String getValue() {
            return this.value;
        }

        void verify() throws XMLStreamException {
            if (this.prefix == null) {
                String prefix;
                if (!"".equals(this.namespaceURI) && (prefix = AbstractXMLStreamScope.this.getNonEmptyPrefix(this.namespaceURI)) == null) {
                    throw new XMLStreamException("No prefix found for attribute namespace: " + this.namespaceURI);
                }
            } else if (this.namespaceURI == null) {
                String namespaceURI;
                if (!"".equals(this.prefix) && ((namespaceURI = AbstractXMLStreamScope.this.getNamespaceURI(this.prefix)) == null || "".equals(namespaceURI))) {
                    throw new XMLStreamException("Unbound attribute prefix: " + this.prefix);
                }
            } else if ("".equals(this.prefix)) {
                if (!"".equals(this.namespaceURI)) {
                    throw new XMLStreamException("Illegal namespace for unprefixed attribute: " + this.namespaceURI);
                }
            } else if ("".equals(this.namespaceURI)) {
                if (!"".equals(this.prefix)) {
                    throw new XMLStreamException("Illegal prefix for null namespace: " + this.prefix);
                }
            } else if (!AbstractXMLStreamScope.this.getNamespaceURI(this.prefix).equals(this.namespaceURI)) {
                throw new XMLStreamException("Prefix '" + this.prefix + "' is not bound to: " + this.namespaceURI);
            }
        }
    }
}

