/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.hl7v2;

import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.message.batch.BatchAdaptorFactory;
import com.mirth.connect.donkey.server.message.batch.BatchMessageException;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReader;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReceiver;
import com.mirth.connect.plugins.datatypes.hl7v2.HL7v2BatchProperties;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.message.DebuggableBatchAdaptor;
import com.mirth.connect.server.message.DebuggableBatchAdaptorFactory;
import com.mirth.connect.server.userutil.SourceMap;
import com.mirth.connect.server.util.CompiledScriptCache;
import com.mirth.connect.server.util.javascript.JavaScriptExecutorException;
import com.mirth.connect.server.util.javascript.JavaScriptScopeUtil;
import com.mirth.connect.server.util.javascript.JavaScriptTask;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class ER7BatchAdaptor
extends DebuggableBatchAdaptor {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private Pattern lineBreakPattern;
    private String segmentDelimiter;
    private BufferedReader bufferedReader;
    private Scanner scanner;
    private String previousLine;

    public ER7BatchAdaptor(DebuggableBatchAdaptorFactory factory, SourceConnector sourceConnector, BatchRawMessage batchRawMessage) {
        super((BatchAdaptorFactory)factory, sourceConnector, batchRawMessage);
    }

    public Pattern getLineBreakPattern() {
        return this.lineBreakPattern;
    }

    public void setLineBreakPattern(Pattern lineBreakPattern) {
        this.lineBreakPattern = lineBreakPattern;
    }

    public String getSegmentDelimiter() {
        return this.segmentDelimiter;
    }

    public void setSegmentDelimiter(String segmentDelimiter) {
        this.segmentDelimiter = segmentDelimiter;
    }

    public void cleanup() throws BatchMessageException {
        if (this.scanner != null) {
            this.scanner.close();
        }
        this.previousLine = null;
    }

    protected String getNextMessage(int batchSequenceId) throws Exception {
        if (this.batchRawMessage.getBatchMessageSource() instanceof BatchMessageReader) {
            if (batchSequenceId == 1) {
                BatchMessageReader batchMessageReader = (BatchMessageReader)this.batchRawMessage.getBatchMessageSource();
                this.bufferedReader = new BufferedReader(batchMessageReader.getReader());
                this.scanner = new Scanner(batchMessageReader.getReader());
                this.scanner.useDelimiter(this.lineBreakPattern);
                this.previousLine = null;
            }
            return this.getMessageFromReader();
        }
        if (this.batchRawMessage.getBatchMessageSource() instanceof BatchMessageReceiver) {
            return this.getMessageFromReceiver((BatchMessageReceiver)this.batchRawMessage.getBatchMessageSource());
        }
        return null;
    }

    private String getMessageFromReceiver(BatchMessageReceiver batchMessageReceiver) throws Exception {
        byte[] bytes = null;
        if (batchMessageReceiver.canRead()) {
            try {
                bytes = batchMessageReceiver.readBytes();
            }
            finally {
                batchMessageReceiver.readCompleted();
            }
            if (bytes != null) {
                return batchMessageReceiver.getStringFromBytes(bytes);
            }
        }
        return null;
    }

    private String getMessageFromReader() throws Exception {
        HL7v2BatchProperties batchProperties = (HL7v2BatchProperties)this.getBatchProperties();
        HL7v2BatchProperties.SplitType splitType = batchProperties.getSplitType();
        if (splitType == HL7v2BatchProperties.SplitType.MSH_Segment) {
            int startOfMessage = 11;
            int endOfMessage = 28;
            StringBuilder message = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)this.previousLine)) {
                message.append(this.previousLine);
                message.append(this.segmentDelimiter);
            }
            while (this.scanner.hasNext()) {
                String line = StringUtils.remove((String)StringUtils.remove((String)this.scanner.next(), (char)((char)startOfMessage)), (char)((char)endOfMessage)).trim();
                if (line.length() == 0 || line.equals(Character.valueOf((char)endOfMessage)) || line.startsWith("MSH")) {
                    if (message.length() > 0) {
                        this.previousLine = line;
                        return message.toString();
                    }
                    while (line.length() == 0 && this.scanner.hasNext()) {
                        line = this.scanner.next();
                    }
                    if (line.length() <= 0) continue;
                    message.append(line);
                    message.append(this.segmentDelimiter);
                    continue;
                }
                if (line.startsWith("FHS") || line.startsWith("BHS") || line.startsWith("BTS") || line.startsWith("FTS")) continue;
                message.append(line);
                message.append(this.segmentDelimiter);
            }
            if (message.length() > 0) {
                this.previousLine = null;
                return message.toString();
            }
        } else if (splitType == HL7v2BatchProperties.SplitType.JavaScript) {
            if (StringUtils.isEmpty((CharSequence)batchProperties.getBatchScript())) {
                throw new BatchMessageException("No batch script was set.");
            }
            try {
                final String batchScriptId = ScriptController.getScriptId((String)"Batch", (String)this.sourceConnector.getChannelId());
                Boolean debug = ((DebuggableBatchAdaptorFactory)this.getFactory()).isDebug();
                MirthContextFactory contextFactory = this.getContextFactoryAndRecompile(this.contextFactoryController, debug, batchScriptId, batchProperties.getBatchScript());
                this.triggerDebug(debug);
                String result = (String)JavaScriptUtil.execute((JavaScriptTask)new JavaScriptTask<String>(contextFactory, "HL7 v2.x Batch Adaptor", this.sourceConnector){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public String doCall() throws Exception {
                        Script compiledScript = CompiledScriptCache.getInstance().getCompiledScript(batchScriptId);
                        if (compiledScript == null) {
                            ER7BatchAdaptor.this.logger.error("Batch script could not be found in cache");
                            return null;
                        }
                        Logger scriptLogger = LogManager.getLogger((String)"Batch".toLowerCase());
                        try {
                            Scriptable scope = JavaScriptScopeUtil.getBatchProcessorScope((ContextFactory)this.getContextFactory(), (Object)scriptLogger, (String)ER7BatchAdaptor.this.sourceConnector.getChannelId(), (String)ER7BatchAdaptor.this.sourceConnector.getChannel().getName(), ER7BatchAdaptor.this.getScopeObjects(ER7BatchAdaptor.this.bufferedReader));
                            String string = (String)Context.jsToJava((Object)this.executeScript(compiledScript, scope), String.class);
                            return string;
                        }
                        finally {
                            Context.exit();
                        }
                    }
                });
                if (StringUtils.isEmpty((CharSequence)result)) {
                    return null;
                }
                return result;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (JavaScriptExecutorException e) {
                this.logger.error((Object)e.getCause());
            }
            catch (Throwable e) {
                this.logger.error((Object)e);
            }
        } else {
            throw new BatchMessageException("No valid batch splitting method detected");
        }
        return null;
    }

    private Map<String, Object> getScopeObjects(Reader in) {
        HashMap<String, Object> scopeObjects = new HashMap<String, Object>();
        scopeObjects.put("reader", in);
        scopeObjects.put("sourceMap", new SourceMap(Collections.unmodifiableMap(this.batchRawMessage.getSourceMap())));
        return scopeObjects;
    }
}

