/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.hl7v2;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.message.AutoResponder;
import com.mirth.connect.model.datatype.ResponseGenerationProperties;
import com.mirth.connect.model.datatype.SerializationProperties;
import com.mirth.connect.plugins.datatypes.hl7v2.HL7v2ACKGenerator;
import com.mirth.connect.plugins.datatypes.hl7v2.HL7v2ResponseGenerationProperties;
import com.mirth.connect.plugins.datatypes.hl7v2.HL7v2SerializationProperties;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.util.StringUtil;
import java.io.CharArrayReader;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class HL7v2AutoResponder
implements AutoResponder {
    private static final String IS_XML = "isXML";
    private static final String ACK_CODE = "ackCode";
    private static final String TEXT_MESSAGE = "textMessage";
    private static final String DATE_FORMAT = "dateFormat";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final String SEGMENT_DELIMITER = "segmentDelimiter";
    private Logger logger = LogManager.getLogger(this.getClass());
    private HL7v2SerializationProperties serializationProperties;
    private HL7v2ResponseGenerationProperties generationProperties;
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private String serializationSegmentDelimiter = null;
    private String deserializationSegmentDelimiter = null;

    public HL7v2AutoResponder() {
        this(null, null);
    }

    public HL7v2AutoResponder(SerializationProperties serializationProperties, ResponseGenerationProperties generationProperties) {
        this.serializationProperties = (HL7v2SerializationProperties)serializationProperties;
        this.generationProperties = (HL7v2ResponseGenerationProperties)generationProperties;
        if (this.serializationProperties != null) {
            this.serializationSegmentDelimiter = StringUtil.unescape((String)this.serializationProperties.getSegmentDelimiter());
        }
        if (this.generationProperties != null) {
            this.deserializationSegmentDelimiter = StringUtil.unescape((String)this.generationProperties.getSegmentDelimiter());
        }
    }

    public Response getResponse(Status status, String message, ConnectorMessage connectorMessage) throws Exception {
        HL7v2ResponseGenerationProperties hl7Properties = this.getReplacedHL7Properties(connectorMessage);
        return this.generateACK(status, message, hl7Properties);
    }

    private HL7v2ResponseGenerationProperties getReplacedHL7Properties(ConnectorMessage connectorMessage) {
        HL7v2ResponseGenerationProperties hl7v2Properties = new HL7v2ResponseGenerationProperties(this.generationProperties);
        hl7v2Properties.setSuccessfulACKCode(this.replacer.replaceValues(hl7v2Properties.getSuccessfulACKCode(), connectorMessage));
        hl7v2Properties.setSuccessfulACKMessage(this.replacer.replaceValues(hl7v2Properties.getSuccessfulACKMessage(), connectorMessage));
        hl7v2Properties.setErrorACKCode(this.replacer.replaceValues(hl7v2Properties.getErrorACKCode(), connectorMessage));
        hl7v2Properties.setErrorACKMessage(this.replacer.replaceValues(hl7v2Properties.getErrorACKMessage(), connectorMessage));
        hl7v2Properties.setRejectedACKCode(this.replacer.replaceValues(hl7v2Properties.getRejectedACKCode(), connectorMessage));
        hl7v2Properties.setRejectedACKMessage(this.replacer.replaceValues(hl7v2Properties.getRejectedACKMessage(), connectorMessage));
        return hl7v2Properties;
    }

    private Response generateACK(Status status, String hl7Message, HL7v2ResponseGenerationProperties hl7v2Properties) throws Exception {
        boolean errorOnly = false;
        boolean always = false;
        boolean successOnly = false;
        boolean isXML = StringUtils.isNotBlank((CharSequence)(hl7Message = hl7Message.trim())) && hl7Message.charAt(0) == '<';
        String ACK = null;
        String statusMessage = null;
        String error = null;
        try {
            if (this.serializationProperties.isConvertLineBreaks() && !isXML) {
                hl7Message = StringUtil.convertLineBreaks((String)hl7Message, (String)this.serializationSegmentDelimiter);
            }
            if (hl7v2Properties.isMsh15ACKAccept()) {
                String msh15 = "";
                if (isXML) {
                    XPath xpath = XPathFactory.newInstance().newXPath();
                    XPathExpression msh15Query = xpath.compile("//MSH.15/text()");
                    DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                    domFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    DocumentBuilder builder = domFactory.newDocumentBuilder();
                    CharArrayReader reader = new CharArrayReader(hl7Message.toCharArray());
                    Document doc = builder.parse(new InputSource(reader));
                    msh15 = msh15Query.evaluate(doc);
                } else {
                    char fieldDelim = hl7Message.charAt(3);
                    char componentDelim = hl7Message.charAt(4);
                    Pattern fieldPattern = Pattern.compile(Pattern.quote(String.valueOf(fieldDelim)));
                    Pattern componentPattern = Pattern.compile(Pattern.quote(String.valueOf(componentDelim)));
                    String mshString = StringUtils.split((String)hl7Message, (String)this.serializationSegmentDelimiter)[0];
                    String[] mshFields = fieldPattern.split(mshString);
                    if (mshFields.length > 14) {
                        msh15 = componentPattern.split(mshFields[14])[0];
                    }
                }
                if (msh15 != null && !msh15.equals("")) {
                    if (msh15.equalsIgnoreCase("AL")) {
                        always = true;
                    } else {
                        if (msh15.equalsIgnoreCase("NE")) {
                            this.logger.debug("MSH15 is NE, Skipping ACK");
                            return null;
                        }
                        if (msh15.equalsIgnoreCase("ER")) {
                            errorOnly = true;
                        } else if (msh15.equalsIgnoreCase("SU")) {
                            successOnly = true;
                        }
                    }
                }
            }
            String ackCode = "AA";
            String ackMessage = "";
            boolean nack = false;
            if (status == Status.ERROR) {
                if (successOnly) {
                    return null;
                }
                ackCode = hl7v2Properties.getErrorACKCode();
                ackMessage = hl7v2Properties.getErrorACKMessage();
                nack = true;
            } else if (status == Status.FILTERED) {
                if (successOnly) {
                    return null;
                }
                ackCode = hl7v2Properties.getRejectedACKCode();
                ackMessage = hl7v2Properties.getRejectedACKMessage();
                nack = true;
            } else {
                if (errorOnly) {
                    return null;
                }
                ackCode = hl7v2Properties.getSuccessfulACKCode();
                ackMessage = hl7v2Properties.getSuccessfulACKMessage();
            }
            ACK = HL7v2ACKGenerator.generateAckResponse(hl7Message, isXML, ackCode, ackMessage, this.generationProperties.getDateFormat(), new String(), this.deserializationSegmentDelimiter);
            statusMessage = "HL7v2 " + (nack ? "N" : "") + "ACK successfully generated.";
            this.logger.debug("HL7v2 " + (nack ? "N" : "") + "ACK successfully generated: " + ACK);
        }
        catch (Exception e) {
            this.logger.warn("Error generating HL7v2 ACK.", (Throwable)e);
            throw new Exception("Error generating HL7v2 ACK.", e);
        }
        return new Response(status, ACK, statusMessage, error);
    }

    public String generateResponseMessage(String message, Map<String, Object> properties) throws Exception {
        boolean isXML = (Boolean)properties.get(IS_XML);
        String acknowledgementCode = (String)properties.get(ACK_CODE);
        String textMessage = (String)properties.get(TEXT_MESSAGE);
        String dateFormat = (String)properties.get(DATE_FORMAT);
        String errorMessage = (String)properties.get(ERROR_MESSAGE);
        String segmentDelim = (String)properties.get(SEGMENT_DELIMITER);
        return HL7v2ACKGenerator.generateAckResponse(message, isXML, acknowledgementCode, textMessage, dateFormat, errorMessage, segmentDelim);
    }
}

