/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.hl7v2;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.datatype.DataTypePropertyDescriptor;
import com.mirth.connect.model.datatype.PropertyEditorType;
import com.mirth.connect.model.datatype.ResponseGenerationProperties;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HL7v2ResponseGenerationProperties
extends ResponseGenerationProperties {
    private String segmentDelimiter = "\\r";
    private String successfulACKCode = "AA";
    private String successfulACKMessage = "";
    private String errorACKCode = "AE";
    private String errorACKMessage = "An Error Occurred Processing Message.";
    private String rejectedACKCode = "AR";
    private String rejectedACKMessage = "Message Rejected.";
    private boolean msh15ACKAccept = false;
    private String dateFormat = "yyyyMMddHHmmss.SSS";

    public HL7v2ResponseGenerationProperties() {
    }

    public HL7v2ResponseGenerationProperties(HL7v2ResponseGenerationProperties properties) {
        this.segmentDelimiter = properties.getSegmentDelimiter();
        this.successfulACKCode = properties.getSuccessfulACKCode();
        this.successfulACKMessage = properties.getSuccessfulACKMessage();
        this.errorACKCode = properties.getErrorACKCode();
        this.errorACKMessage = properties.getErrorACKMessage();
        this.rejectedACKCode = properties.getRejectedACKCode();
        this.rejectedACKMessage = properties.getRejectedACKMessage();
        this.msh15ACKAccept = properties.isMsh15ACKAccept();
    }

    public Map<String, DataTypePropertyDescriptor> getPropertyDescriptors() {
        LinkedHashMap<String, DataTypePropertyDescriptor> properties = new LinkedHashMap<String, DataTypePropertyDescriptor>();
        properties.put("segmentDelimiter", new DataTypePropertyDescriptor((Object)this.segmentDelimiter, "Segment Delimiter", "This is the delimiter character(s) that will be used after each segment. This option has no effect unless an \"Auto-generate\" item has been selected in the response settings.", PropertyEditorType.STRING));
        properties.put("successfulACKCode", new DataTypePropertyDescriptor((Object)this.successfulACKCode, "Successful ACK Code", "The ACK code to respond with when the message processes successfully. This option has no effect unless an \"Auto-generate\" item has been selected in the response settings.", PropertyEditorType.STRING));
        properties.put("successfulACKMessage", new DataTypePropertyDescriptor((Object)this.successfulACKMessage, "Successful ACK Message", "The ACK message to respond with when the message processes successfully. This option has no effect unless an \"Auto-generate\" item has been selected in the response settings.", PropertyEditorType.STRING));
        properties.put("errorACKCode", new DataTypePropertyDescriptor((Object)this.errorACKCode, "Error ACK Code", "The ACK code to respond with when an error occurs during message processing. This option has no effect unless an \"Auto-generate\" item has been selected in the response settings.", PropertyEditorType.STRING));
        properties.put("errorACKMessage", new DataTypePropertyDescriptor((Object)this.errorACKMessage, "Error ACK Message", "The ACK message to respond with when an error occurs during message processing. This option has no effect unless an \"Auto-generate\" item has been selected in the response settings.", PropertyEditorType.STRING));
        properties.put("rejectedACKCode", new DataTypePropertyDescriptor((Object)this.rejectedACKCode, "Rejected ACK Code", "The ACK code to respond with when the message is filtered. This option has no effect unless an \"Auto-generate\" item has been selected in the response settings.", PropertyEditorType.STRING));
        properties.put("rejectedACKMessage", new DataTypePropertyDescriptor((Object)this.rejectedACKMessage, "Rejected ACK Message", "The ACK message to respond with when the message is filtered. This option has no effect unless an \"Auto-generate\" item has been selected in the response settings.", PropertyEditorType.STRING));
        properties.put("msh15ACKAccept", new DataTypePropertyDescriptor((Object)this.msh15ACKAccept, "MSH-15 ACK Accept", "This setting determines if BridgeLink should check the MSH-15 field of an incoming message to control the acknowledgment conditions. The MSH-15 field specifies if a message should be always acknowledged, never acknowledged, or only acknowledged on error. This option has no effect unless an \"Auto-generate\" item has been selected in the response settings.", PropertyEditorType.BOOLEAN));
        properties.put("dateFormat", new DataTypePropertyDescriptor((Object)this.dateFormat, "Date Format", "This setting determines the date format used for the timestamp in the generated ACK. The default value is \"yyyyMMddHHmmss.SSS\".", PropertyEditorType.STRING));
        return properties;
    }

    public void setProperties(Map<String, Object> properties) {
        if (properties != null) {
            if (properties.get("segmentDelimiter") != null) {
                this.segmentDelimiter = (String)properties.get("segmentDelimiter");
            }
            if (properties.get("successfulACKCode") != null) {
                this.successfulACKCode = (String)properties.get("successfulACKCode");
            }
            if (properties.get("successfulACKMessage") != null) {
                this.successfulACKMessage = (String)properties.get("successfulACKMessage");
            }
            if (properties.get("errorACKCode") != null) {
                this.errorACKCode = (String)properties.get("errorACKCode");
            }
            if (properties.get("errorACKMessage") != null) {
                this.errorACKMessage = (String)properties.get("errorACKMessage");
            }
            if (properties.get("rejectedACKCode") != null) {
                this.rejectedACKCode = (String)properties.get("rejectedACKCode");
            }
            if (properties.get("rejectedACKMessage") != null) {
                this.rejectedACKMessage = (String)properties.get("rejectedACKMessage");
            }
            if (properties.get("msh15ACKAccept") != null) {
                this.msh15ACKAccept = (Boolean)properties.get("msh15ACKAccept");
            }
            if (StringUtils.isNotEmpty((CharSequence)((String)properties.get("dateFormat")))) {
                try {
                    String format = (String)properties.get("dateFormat");
                    new SimpleDateFormat(format).format(new Date());
                    this.dateFormat = format;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String getSegmentDelimiter() {
        return this.segmentDelimiter;
    }

    public void setOutputSegmentDelimiter(String segmentDelimiter) {
        this.segmentDelimiter = segmentDelimiter;
    }

    public String getSuccessfulACKCode() {
        return this.successfulACKCode;
    }

    public void setSuccessfulACKCode(String successfulACKCode) {
        this.successfulACKCode = successfulACKCode;
    }

    public String getSuccessfulACKMessage() {
        return this.successfulACKMessage;
    }

    public void setSuccessfulACKMessage(String successfulACKMessage) {
        this.successfulACKMessage = successfulACKMessage;
    }

    public String getErrorACKCode() {
        return this.errorACKCode;
    }

    public void setErrorACKCode(String errorACKCode) {
        this.errorACKCode = errorACKCode;
    }

    public String getErrorACKMessage() {
        return this.errorACKMessage;
    }

    public void setErrorACKMessage(String errorACKMessage) {
        this.errorACKMessage = errorACKMessage;
    }

    public String getRejectedACKCode() {
        return this.rejectedACKCode;
    }

    public void setRejectedACKCode(String rejectedACKCode) {
        this.rejectedACKCode = rejectedACKCode;
    }

    public String getRejectedACKMessage() {
        return this.rejectedACKMessage;
    }

    public void setRejectedACKMessage(String rejectedACKMessage) {
        this.rejectedACKMessage = rejectedACKMessage;
    }

    public boolean isMsh15ACKAccept() {
        return this.msh15ACKAccept;
    }

    public void setMsh15ACKAccept(boolean msh15ackAccept) {
        this.msh15ACKAccept = msh15ackAccept;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
    }

    public void migrate3_2_0(DonkeyElement element) {
        element.addChildElementIfNotExists("dateFormat", "yyyyMMddHHmmss");
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("successfulACKMessageChars", PurgeUtil.countChars((String)this.successfulACKMessage));
        purgedProperties.put("errorACKMessageChars", PurgeUtil.countChars((String)this.errorACKMessage));
        purgedProperties.put("rejectedACKMessageChars", PurgeUtil.countChars((String)this.rejectedACKMessage));
        purgedProperties.put("msh15ACKAccept", this.msh15ACKAccept);
        return purgedProperties;
    }
}

