/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.server.core;

import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageStatisticsTimeseries;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class MessageTrendsBuffer {
    private volatile boolean enabled = false;
    private final ConcurrentMap<String, ConcurrentMap<Status, AtomicInteger>> channelStats = new ConcurrentHashMap<String, ConcurrentMap<Status, AtomicInteger>>();
    private final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<Status, AtomicInteger>>> connectorStats = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<Status, AtomicInteger>>>();

    private MessageTrendsBuffer() {
    }

    public static MessageTrendsBuffer getInstance() {
        return Holder.I;
    }

    public synchronized void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.resetAll();
            this.enabled = bl;
        }
    }

    public void addFromDonkeyMap(Map<String, Map<Integer, Map<Status, Long>>> map) {
        if (!this.enabled || map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<Integer, Map<Status, Long>>> entry : map.entrySet()) {
            Map<Integer, Map<Status, Long>> map2;
            String string = entry.getKey();
            if (string == null || string.isEmpty() || (map2 = entry.getValue()) == null || map2.isEmpty()) continue;
            for (Map.Entry<Integer, Map<Status, Long>> entry2 : map2.entrySet()) {
                String string2;
                Integer n = entry2.getKey();
                String string3 = string2 = n == null ? null : Integer.toString(n);
                Map<Status, Long> map3 = entry2.getValue();
                if (map3 == null || map3.isEmpty()) continue;
                EnumMap<Status, Long> enumMap = new EnumMap<Status, Long>(Status.class);
                for (Map.Entry<Status, Long> entry3 : map3.entrySet()) {
                    Status status = entry3.getKey();
                    Long l = entry3.getValue();
                    if (status == null || l == null || l == 0L) continue;
                    enumMap.put(status, l);
                }
                if (enumMap.isEmpty()) continue;
                this.addDeltas(string, string2, enumMap);
            }
        }
    }

    public void addDeltas(String string2, String string3, Map<Status, Long> map) {
        if (string2 == null || map == null || map.isEmpty()) {
            return;
        }
        if (string3 == null) {
            ConcurrentMap concurrentMap = this.channelStats.computeIfAbsent(string2, string -> new ConcurrentHashMap());
            concurrentMap.computeIfAbsent(Status.RECEIVED, status -> new AtomicInteger()).addAndGet(MessageTrendsBuffer.safeToInt(map.getOrDefault(Status.RECEIVED, 0L)));
            concurrentMap.computeIfAbsent(Status.FILTERED, status -> new AtomicInteger()).addAndGet(MessageTrendsBuffer.safeToInt(map.getOrDefault(Status.FILTERED, 0L)));
            concurrentMap.computeIfAbsent(Status.QUEUED, status -> new AtomicInteger()).addAndGet(MessageTrendsBuffer.safeToInt(map.getOrDefault(Status.QUEUED, 0L)));
            concurrentMap.computeIfAbsent(Status.SENT, status -> new AtomicInteger()).addAndGet(MessageTrendsBuffer.safeToInt(map.getOrDefault(Status.SENT, 0L)));
            concurrentMap.computeIfAbsent(Status.ERROR, status -> new AtomicInteger()).addAndGet(MessageTrendsBuffer.safeToInt(map.getOrDefault(Status.ERROR, 0L)));
        } else {
            ConcurrentMap concurrentMap = this.connectorStats.computeIfAbsent(string2, string -> new ConcurrentHashMap());
            ConcurrentMap concurrentMap2 = concurrentMap.computeIfAbsent(string3, string -> new ConcurrentHashMap());
            concurrentMap2.computeIfAbsent(Status.RECEIVED, status -> new AtomicInteger()).addAndGet(MessageTrendsBuffer.safeToInt(map.getOrDefault(Status.RECEIVED, 0L)));
            concurrentMap2.computeIfAbsent(Status.FILTERED, status -> new AtomicInteger()).addAndGet(MessageTrendsBuffer.safeToInt(map.getOrDefault(Status.FILTERED, 0L)));
            concurrentMap2.computeIfAbsent(Status.QUEUED, status -> new AtomicInteger()).addAndGet(MessageTrendsBuffer.safeToInt(map.getOrDefault(Status.QUEUED, 0L)));
            concurrentMap2.computeIfAbsent(Status.SENT, status -> new AtomicInteger()).addAndGet(MessageTrendsBuffer.safeToInt(map.getOrDefault(Status.SENT, 0L)));
            concurrentMap2.computeIfAbsent(Status.ERROR, status -> new AtomicInteger()).addAndGet(MessageTrendsBuffer.safeToInt(map.getOrDefault(Status.ERROR, 0L)));
        }
    }

    public List<MessageStatisticsTimeseries> snapshotAndReset(Date date, int n, String string) {
        Object object;
        Map map;
        String string2;
        ArrayList<MessageStatisticsTimeseries> arrayList = new ArrayList<MessageStatisticsTimeseries>(256);
        for (Map.Entry entry2 : this.channelStats.entrySet()) {
            string2 = (String)entry2.getKey();
            map = (Map)entry2.getValue();
            if (map == null || map.isEmpty()) continue;
            object = new MessageStatisticsTimeseries(string2, null, date, n, string);
            object.setReceived(Integer.valueOf(MessageTrendsBuffer.getAndZero(map, Status.RECEIVED)));
            object.setFiltered(Integer.valueOf(MessageTrendsBuffer.getAndZero(map, Status.FILTERED)));
            object.setQueued(Integer.valueOf(MessageTrendsBuffer.getAndZero(map, Status.QUEUED)));
            object.setSent(Integer.valueOf(MessageTrendsBuffer.getAndZero(map, Status.SENT)));
            object.setError(Integer.valueOf(MessageTrendsBuffer.getAndZero(map, Status.ERROR)));
            map.entrySet().removeIf(entry -> ((AtomicInteger)entry.getValue()).get() == 0);
            arrayList.add((MessageStatisticsTimeseries)object);
        }
        for (Map.Entry entry2 : this.connectorStats.entrySet()) {
            string2 = (String)entry2.getKey();
            map = (Map)entry2.getValue();
            if (map == null || map.isEmpty()) continue;
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry3 = (Map.Entry)object.next();
                String string3 = (String)entry3.getKey();
                Map map2 = (Map)entry3.getValue();
                if (map2 == null || map2.isEmpty()) {
                    object.remove();
                    continue;
                }
                MessageStatisticsTimeseries messageStatisticsTimeseries = new MessageStatisticsTimeseries(string2, string3, date, n, string);
                messageStatisticsTimeseries.setReceived(Integer.valueOf(MessageTrendsBuffer.getAndZero(map2, Status.RECEIVED)));
                messageStatisticsTimeseries.setFiltered(Integer.valueOf(MessageTrendsBuffer.getAndZero(map2, Status.FILTERED)));
                messageStatisticsTimeseries.setQueued(Integer.valueOf(MessageTrendsBuffer.getAndZero(map2, Status.QUEUED)));
                messageStatisticsTimeseries.setSent(Integer.valueOf(MessageTrendsBuffer.getAndZero(map2, Status.SENT)));
                messageStatisticsTimeseries.setError(Integer.valueOf(MessageTrendsBuffer.getAndZero(map2, Status.ERROR)));
                map2.entrySet().removeIf(entry -> ((AtomicInteger)entry.getValue()).get() == 0);
                if (map2.isEmpty()) {
                    object.remove();
                }
                arrayList.add(messageStatisticsTimeseries);
            }
            if (!map.isEmpty()) continue;
            this.connectorStats.remove(string2, map);
        }
        return arrayList;
    }

    private void resetAll() {
        this.channelStats.clear();
        this.connectorStats.clear();
    }

    private static int getAndZero(Map<Status, AtomicInteger> map, Status status) {
        AtomicInteger atomicInteger = map.get(status);
        return atomicInteger == null ? 0 : atomicInteger.getAndSet(0);
    }

    private static int safeToInt(long l) {
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (l < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)l);
    }

    private static final class Holder {
        static final MessageTrendsBuffer I = new MessageTrendsBuffer();

        private Holder() {
        }
    }
}

