/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.server.dao.impl;

import com.mirth.connect.plugins.messagetrends.server.dao.MessageStatisticsTimeseriesDao;
import com.mirth.connect.plugins.messagetrends.server.util.ConnectorIdNormalizer;
import com.mirth.connect.plugins.messagetrends.server.util.DatabaseDialect;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageStatisticsTimeseries;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MyBatisMessageStatisticsTimeseriesDao
implements MessageStatisticsTimeseriesDao {
    private static final Logger logger = LogManager.getLogger(MyBatisMessageStatisticsTimeseriesDao.class);
    private static final String NS = "MessageTrends";
    private final SqlSessionManager sqlSessionManager;
    private final DatabaseDialect.DatabaseType dbType;

    public MyBatisMessageStatisticsTimeseriesDao(SqlSessionManager sqlSessionManager, DatabaseDialect.DatabaseType databaseType) {
        this.sqlSessionManager = sqlSessionManager;
        this.dbType = databaseType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int replaceRollupWindow(String string, Date date, int n, List<MessageStatisticsTimeseries> list) {
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            if (string == null) {
                throw new IllegalArgumentException("serverId cannot be null");
            }
            if (date == null) {
                throw new IllegalArgumentException("startTs cannot be null");
            }
            if (list == null) {
                throw new IllegalArgumentException("List of rollup rows cannot be null");
            }
            ArrayList<MessageStatisticsTimeseries> arrayList = new ArrayList<MessageStatisticsTimeseries>(list.size());
            for (MessageStatisticsTimeseries messageStatisticsTimeseries : list) {
                if (messageStatisticsTimeseries.getChannelId() == null) {
                    throw new IllegalArgumentException("channelId cannot be null for rollup rows");
                }
                if (messageStatisticsTimeseries.getTs() == null || !messageStatisticsTimeseries.getTs().equals(date)) {
                    throw new IllegalArgumentException("Row ts mismatch: expected " + String.valueOf(date) + ", got " + String.valueOf(messageStatisticsTimeseries.getTs()));
                }
                if (messageStatisticsTimeseries.getBucketSizeMinutes() == null || messageStatisticsTimeseries.getBucketSizeMinutes() != n) {
                    throw new IllegalArgumentException("Row bucket mismatch: expected " + n + ", got " + messageStatisticsTimeseries.getBucketSizeMinutes());
                }
                MessageStatisticsTimeseries messageStatisticsTimeseries2 = new MessageStatisticsTimeseries(messageStatisticsTimeseries);
                messageStatisticsTimeseries2.setConnectorId(ConnectorIdNormalizer.toDb(messageStatisticsTimeseries2.getConnectorId()));
                arrayList.add(messageStatisticsTimeseries2);
            }
            HashMap hashMap = new HashMap();
            hashMap.put("serverId", string);
            hashMap.put("ts", date);
            hashMap.put("bucketSizeMinutes", n);
            int n2 = sqlSession.delete("MessageTrends.deleteRollupWindow", (Object)hashMap);
            int n3 = 0;
            if (!arrayList.isEmpty()) {
                n3 = sqlSession.insert("MessageTrends.insertRollupRows", arrayList);
            }
            sqlSession.commit();
            bl = true;
            int n4 = n3;
            return n4;
        }
        catch (Exception exception) {
            logger.error("Failed to replace rollup window", (Throwable)exception);
            this.debugPrintRows(list);
            int n5 = 0;
            return n5;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int purgeBefore(String string, int n, Date date) {
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("serverId", string);
            hashMap.put("bucketSizeMinutes", n);
            hashMap.put("cutoffTs", date);
            int n2 = sqlSession.delete("MessageTrends.purgeBefore", hashMap);
            sqlSession.commit();
            bl = true;
            int n3 = n2;
            return n3;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }

    @Override
    public List<MessageStatisticsTimeseries> selectSeriesServerChannel(String string, String string2, Date date, Date date2, int n) {
        return this.selectSeriesServerConnector(string, string2, null, date, date2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageStatisticsTimeseries> selectSeriesServerConnector(String string, String string2, String string3, Date date, Date date2, int n) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("serverId", string);
            hashMap.put("channelId", string2);
            hashMap.put("connectorId", ConnectorIdNormalizer.toDb(string3));
            hashMap.put("startTs", date);
            hashMap.put("endTs", date2);
            hashMap.put("bucketSizeMinutes", n);
            List list = sqlSession.selectList("MessageTrends.selectSeriesServerChannelConnector", hashMap);
            for (MessageStatisticsTimeseries messageStatisticsTimeseries : list) {
                messageStatisticsTimeseries.setConnectorId(ConnectorIdNormalizer.toApi(messageStatisticsTimeseries.getConnectorId()));
            }
            List list2 = list;
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageStatisticsTimeseries> selectSeriesServerAll(String string, Date date, Date date2, int n) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("serverId", string);
            hashMap.put("startTs", date);
            hashMap.put("endTs", date2);
            hashMap.put("bucketSizeMinutes", n);
            List list = sqlSession.selectList("MessageTrends.selectSeriesServerAll", hashMap);
            for (MessageStatisticsTimeseries messageStatisticsTimeseries : list) {
                messageStatisticsTimeseries.setConnectorId(ConnectorIdNormalizer.toApi(messageStatisticsTimeseries.getConnectorId()));
            }
            List list2 = list;
            return list2;
        }
    }

    private void debugPrintRows(List<MessageStatisticsTimeseries> list) {
        if (list == null || list.isEmpty()) {
            logger.debug("insertRollupRows: list is empty");
            return;
        }
        logger.debug("insertRollupRows: dumping {} rows", (Object)list.size());
        for (int i = 0; i < list.size(); ++i) {
            MessageStatisticsTimeseries messageStatisticsTimeseries = list.get(i);
            logger.debug("[{}] serverId={} channelId={} connectorId={} ts={} bucket={} recv={} filt={} queue={} sent={} err={}", new Object[]{i, messageStatisticsTimeseries.getServerId(), messageStatisticsTimeseries.getChannelId(), messageStatisticsTimeseries.getConnectorId(), messageStatisticsTimeseries.getTs(), messageStatisticsTimeseries.getBucketSizeMinutes(), messageStatisticsTimeseries.getReceived(), messageStatisticsTimeseries.getFiltered(), messageStatisticsTimeseries.getQueued(), messageStatisticsTimeseries.getSent(), messageStatisticsTimeseries.getError()});
        }
    }
}

