/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.server.maintenance;

import com.mirth.connect.plugins.messagetrends.server.service.MessageTrendsService;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class PurgeRunner {
    private static final Logger logger = LogManager.getLogger(PurgeRunner.class);
    private final MessageTrendsService service;
    private final Clock clock;
    private final Map<Integer, Duration> retentionByBucket;
    private final int fixedRateSeconds;
    private final long throttleMs;

    PurgeRunner(MessageTrendsService messageTrendsService, Clock clock, Map<Integer, Duration> map, int n, long l) {
        this.service = messageTrendsService;
        this.clock = clock == null ? Clock.systemUTC() : clock;
        this.retentionByBucket = PurgeRunner.sortBucketsDesc(map);
        this.fixedRateSeconds = Math.max(3600, n);
        this.throttleMs = Math.max(1000L, l);
    }

    long initialDelaySeconds() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now(this.clock);
        ZonedDateTime zonedDateTime2 = zonedDateTime.plusHours(1L).withMinute(0).withSecond(0).withNano(0);
        return Duration.between(zonedDateTime, zonedDateTime2).getSeconds();
    }

    int fixedRateSeconds() {
        return this.fixedRateSeconds;
    }

    void runOnce() {
        Instant instant = this.clock.instant();
        long l = 0L;
        for (Map.Entry<Integer, Duration> entry : this.retentionByBucket.entrySet()) {
            Integer n = entry.getKey();
            Duration duration = entry.getValue();
            try {
                Date date = Date.from(instant.minus(duration));
                int n2 = this.service.purgeBeforeByBucket(n, date);
                l += (long)n2;
                logger.info("Purge bucket={}m cutoff={} purgedRows={}", (Object)n, (Object)date, (Object)n2);
                if (this.throttleMs <= 0L) continue;
                try {
                    Thread.sleep(this.throttleMs);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    logger.warn("Purge interrupted during throttle at bucket={}m", (Object)n);
                    break;
                }
            }
            catch (Exception exception) {
                logger.warn("Purge failed for bucket={}m", (Object)n, (Object)exception);
            }
        }
        logger.info("Purge run finished: totalPurgedRows={}", (Object)l);
    }

    private static Map<Integer, Duration> sortBucketsDesc(Map<Integer, Duration> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        return map.entrySet().stream().sorted((entry, entry2) -> Integer.compare((Integer)entry2.getKey(), (Integer)entry.getKey())).collect(LinkedHashMap::new, (linkedHashMap, entry) -> linkedHashMap.put((Integer)entry.getKey(), (Duration)entry.getValue()), HashMap::putAll);
    }
}

