/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.server.maintenance;

import com.mirth.connect.plugins.messagetrends.server.maintenance.RollKey;
import com.mirth.connect.plugins.messagetrends.server.service.MessageTrendsService;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageStatisticsTimeseries;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class RollupRunner {
    private static final Logger logger = LogManager.getLogger(RollupRunner.class);
    private final MessageTrendsService service;
    private final Clock clock;
    private final Map<Integer, Instant> lastCapProcessedByBucket = new ConcurrentHashMap<Integer, Instant>();
    private final int fixedRateSeconds;

    RollupRunner(MessageTrendsService messageTrendsService, Clock clock, int n, String string) {
        this.service = messageTrendsService;
        this.clock = clock == null ? Clock.systemUTC() : clock;
        this.fixedRateSeconds = Math.max(30, n);
    }

    long initialDelaySeconds() {
        return 30L;
    }

    int fixedRateSeconds() {
        return this.fixedRateSeconds;
    }

    void runOnce() {
        try {
            Instant instant = this.clock.instant();
            logger.debug("runOnce tick at {}", (Object)instant);
            long l = System.currentTimeMillis();
            Instant instant2 = this.roll5Min(instant);
            long l2 = System.currentTimeMillis() - l;
            if (instant2 == null) {
                logger.debug("-> roll5Min: no progress; stop chain ({} ms)", (Object)l2);
                return;
            }
            logger.debug("-> roll5Min done, boundary={}, elapsed={} ms", (Object)instant2, (Object)l2);
            l = System.currentTimeMillis();
            Instant instant3 = this.rollUpGeneric(instant2, 5, 15, "roll15Min");
            long l3 = System.currentTimeMillis() - l;
            if (instant3 == null) {
                logger.debug("-> roll15Min: no progress; stop chain ({} ms)", (Object)l3);
                return;
            }
            logger.debug("-> roll15Min done, boundary={}, elapsed={} ms", (Object)instant3, (Object)l3);
            l = System.currentTimeMillis();
            Instant instant4 = this.rollUpGeneric(instant3, 15, 60, "roll60Min");
            long l4 = System.currentTimeMillis() - l;
            if (instant4 == null) {
                logger.debug("-> roll60Min: no progress; stop chain ({} ms)", (Object)l4);
                return;
            }
            logger.debug("-> roll60Min done, boundary={}, elapsed={} ms", (Object)instant4, (Object)l4);
            l = System.currentTimeMillis();
            Instant instant5 = this.rollUpGeneric(instant4, 60, 1440, "rollOneDay");
            long l5 = System.currentTimeMillis() - l;
            if (instant5 == null) {
                logger.debug("-> rollOneDay: no progress ({} ms)", (Object)l5);
            } else {
                logger.debug("-> rollOneDay done, boundary={}, elapsed={} ms", (Object)instant5, (Object)l5);
            }
        }
        catch (Throwable throwable) {
            logger.warn("RollupRunner runOnce failed", throwable);
        }
    }

    private Instant roll5Min(Instant instant) {
        Date date;
        Duration duration = Duration.ofMinutes(2L);
        Instant instant2 = RollupRunner.clampToBucketBoundary(5, instant.minus(duration));
        Instant instant3 = this.lastCapProcessedByBucket.get(5);
        if (instant3 != null && !instant2.isAfter(instant3)) {
            logger.debug("roll5Min skipped: cap={} not after last={}", (Object)instant2, (Object)instant3);
            return null;
        }
        Instant instant4 = instant2.minus(Duration.ofMinutes(5L));
        Date date2 = Date.from(instant4);
        List<MessageStatisticsTimeseries> list = this.buildRowsForWindow(1, 5, date2, date = Date.from(instant2));
        if (list.isEmpty()) {
            this.lastCapProcessedByBucket.put(5, instant2);
            logger.info("roll5Min {} -> {} [{} , {}): empty", (Object)1, (Object)5, (Object)instant4, (Object)instant2);
            return instant2;
        }
        try {
            int n = this.service.replaceRollupWindow(date2, 5, list);
            logger.info("roll5Min {} -> {} [{} , {}): wrote={}", (Object)1, (Object)5, (Object)instant4, (Object)instant2, (Object)n);
            this.lastCapProcessedByBucket.put(5, instant2);
            return instant2;
        }
        catch (Exception exception) {
            logger.warn("Overwrite window failed for {} -> {} [{} , {}): {}", (Object)1, (Object)5, (Object)instant4, (Object)instant2, (Object)exception.toString());
            return null;
        }
    }

    private Instant rollUpGeneric(Instant instant, int n, int n2, String string) {
        if (instant == null) {
            return null;
        }
        Instant instant2 = RollupRunner.ceilToBucketBoundary(n2, instant);
        Instant instant3 = instant2.minus(Duration.ofMinutes(n2));
        Instant instant4 = instant.isBefore(instant2) ? instant : instant2;
        Date date = Date.from(instant3);
        Date date2 = Date.from(instant4);
        List<MessageStatisticsTimeseries> list = this.buildRowsForWindow(n, n2, date, date2);
        try {
            int n3 = this.service.replaceRollupWindow(date, n2, list);
            logger.info("{} {} -> {} [{} , {}): wrote={}", (Object)string, (Object)n, (Object)n2, (Object)instant3, (Object)instant4, (Object)n3);
            return instant4;
        }
        catch (Exception exception) {
            logger.warn("Overwrite window failed for {} {} -> {} [{} , {}): {}", (Object)string, (Object)n, (Object)n2, (Object)instant3, (Object)instant4, (Object)exception.toString());
            return null;
        }
    }

    private List<MessageStatisticsTimeseries> buildRowsForWindow(int n, int n2, Date date, Date date2) {
        List<MessageStatisticsTimeseries> list = this.service.getServerSeries(date, date2, n);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<RollKey, MessageStatisticsTimeseries> linkedHashMap = new LinkedHashMap<RollKey, MessageStatisticsTimeseries>();
        for (MessageStatisticsTimeseries messageStatisticsTimeseries : list) {
            Instant instant;
            Date date3;
            String string;
            String string2;
            String string3 = messageStatisticsTimeseries.getServerId();
            RollKey rollKey = new RollKey(string3, string2 = messageStatisticsTimeseries.getChannelId(), string = messageStatisticsTimeseries.getConnectorId(), date3 = Date.from(instant = RollupRunner.clampToBucketBoundary(n2, messageStatisticsTimeseries.getTs().toInstant())), n2);
            MessageStatisticsTimeseries messageStatisticsTimeseries2 = (MessageStatisticsTimeseries)linkedHashMap.get(rollKey);
            if (messageStatisticsTimeseries2 == null) {
                messageStatisticsTimeseries2 = new MessageStatisticsTimeseries();
                messageStatisticsTimeseries2.setServerId(string3);
                messageStatisticsTimeseries2.setChannelId(string2);
                messageStatisticsTimeseries2.setConnectorId(string);
                messageStatisticsTimeseries2.setTs(date3);
                messageStatisticsTimeseries2.setBucketSizeMinutes(Integer.valueOf(n2));
                messageStatisticsTimeseries2.setReceived(Integer.valueOf(0));
                messageStatisticsTimeseries2.setFiltered(Integer.valueOf(0));
                messageStatisticsTimeseries2.setQueued(Integer.valueOf(0));
                messageStatisticsTimeseries2.setSent(Integer.valueOf(0));
                messageStatisticsTimeseries2.setError(Integer.valueOf(0));
                linkedHashMap.put(rollKey, messageStatisticsTimeseries2);
            }
            messageStatisticsTimeseries2.setReceived(Integer.valueOf(RollupRunner.nz(messageStatisticsTimeseries2.getReceived()) + RollupRunner.nz(messageStatisticsTimeseries.getReceived())));
            messageStatisticsTimeseries2.setFiltered(Integer.valueOf(RollupRunner.nz(messageStatisticsTimeseries2.getFiltered()) + RollupRunner.nz(messageStatisticsTimeseries.getFiltered())));
            messageStatisticsTimeseries2.setQueued(Integer.valueOf(RollupRunner.nz(messageStatisticsTimeseries.getQueued())));
            messageStatisticsTimeseries2.setSent(Integer.valueOf(RollupRunner.nz(messageStatisticsTimeseries2.getSent()) + RollupRunner.nz(messageStatisticsTimeseries.getSent())));
            messageStatisticsTimeseries2.setError(Integer.valueOf(RollupRunner.nz(messageStatisticsTimeseries2.getError()) + RollupRunner.nz(messageStatisticsTimeseries.getError())));
        }
        return new ArrayList<MessageStatisticsTimeseries>(linkedHashMap.values());
    }

    private static Instant clampToBucketBoundary(int n, Instant instant) {
        long l = instant.getEpochSecond() / 60L;
        long l2 = l / (long)n * (long)n;
        return Instant.ofEpochSecond(l2 * 60L);
    }

    private static Instant ceilToBucketBoundary(int n, Instant instant) {
        if (n <= 0) {
            throw new IllegalArgumentException("bucketMinutes must be > 0");
        }
        Instant instant2 = RollupRunner.clampToBucketBoundary(n, instant);
        return instant2.equals(instant) ? instant : instant2.plus(Duration.ofMinutes(n));
    }

    private static int nz(Integer n) {
        return n == null ? 0 : n;
    }
}

