/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.server.servlet;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.plugins.messagetrends.server.service.MessageTrendsService;
import com.mirth.connect.plugins.messagetrends.server.servlet.support.TimeseriesStatisticsSerializer;
import com.mirth.connect.plugins.messagetrends.shared.interfaces.MessageTrendsServletInterface;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageStatisticsTimeseries;
import com.mirth.connect.plugins.messagetrends.shared.util.Intervals;
import com.mirth.connect.plugins.messagetrends.shared.util.JsonUtils;
import com.mirth.connect.plugins.messagetrends.shared.util.TimeUtil;
import com.mirth.connect.server.api.MirthServlet;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageTrendsServlet
extends MirthServlet
implements MessageTrendsServletInterface {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public MessageTrendsServlet(@Context HttpServletRequest httpServletRequest, @Context SecurityContext securityContext) {
        super(httpServletRequest, securityContext, "Message Trends Management System");
    }

    public String getChannelStatistics(String string, Long l, Long l2, String string2) throws ClientException {
        try {
            Date date;
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("channelId is required");
            }
            if (l == null || l2 == null) {
                throw new IllegalArgumentException("startTime and endTime are required (epoch seconds, UTC)");
            }
            Date date2 = TimeUtil.toDateFromEpochSeconds((Long)l, (String)"startTime");
            if (!date2.before(date = TimeUtil.toDateFromEpochSeconds((Long)l2, (String)"endTime"))) {
                throw new IllegalArgumentException("startTime must be < endTime");
            }
            int n = Intervals.minutesOf((String)string2);
            List<MessageStatisticsTimeseries> list = MessageTrendsService.getInstance().getChannelSeries(string, date2, date, n);
            return TimeseriesStatisticsSerializer.toJsonFromEntities(list);
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process getChannelStatistics request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String getConnectorStatistics(String string, String string2, Long l, Long l2, String string3) throws ClientException {
        try {
            Date date;
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("channelId is required");
            }
            if (l == null || l2 == null) {
                throw new IllegalArgumentException("startTime and endTime are required (epoch seconds, UTC)");
            }
            Date date2 = TimeUtil.toDateFromEpochSeconds((Long)l, (String)"startTime");
            if (!date2.before(date = TimeUtil.toDateFromEpochSeconds((Long)l2, (String)"endTime"))) {
                throw new IllegalArgumentException("startTime must be < endTime");
            }
            int n = Intervals.minutesOf((String)string3);
            List<MessageStatisticsTimeseries> list = MessageTrendsService.getInstance().getConnectorSeries(string, string2, date2, date, n);
            return TimeseriesStatisticsSerializer.toJsonFromEntities(list);
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process getConnectorStatistics request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String getServerStatistics(Long l, Long l2, String string) throws ClientException {
        try {
            Date date;
            if (l == null || l2 == null) {
                throw new IllegalArgumentException("startTime and endTime are required (epoch seconds, UTC)");
            }
            Date date2 = TimeUtil.toDateFromEpochSeconds((Long)l, (String)"startTime");
            if (!date2.before(date = TimeUtil.toDateFromEpochSeconds((Long)l2, (String)"endTime"))) {
                throw new IllegalArgumentException("startTime must be < endTime");
            }
            int n = Intervals.minutesOf((String)string);
            List<MessageStatisticsTimeseries> list = MessageTrendsService.getInstance().getServerSeries(date2, date, n);
            return TimeseriesStatisticsSerializer.toJsonFromEntities(list);
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process getServerStatistics request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String getAvailableIntervals() throws ClientException {
        try {
            List list = Intervals.canonicalCodes();
            return JsonUtils.toJson((Object)list);
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process getAvailableIntervals request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }
}

