/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.connectors.file.AdvancedSettingsDialog;
import com.mirth.connect.connectors.file.SchemeProperties;
import com.mirth.connect.connectors.file.SftpSchemeProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class AdvancedSftpSettingsDialog
extends AdvancedSettingsDialog {
    private final int NAME_COLUMN = 0;
    private final String NAME_COLUMN_NAME = "Name";
    private final String VALUE_COLUMN_NAME = "Value";
    private boolean saved;
    private JLabel authenticationLabel;
    private JRadioButton usePasswordRadio;
    private JRadioButton usePrivateKeyRadio;
    private JRadioButton useBothRadio;
    private ButtonGroup privateKeyButtonGroup;
    private JLabel keyLocationLabel;
    private JTextField keyLocationField;
    private JLabel passphraseLabel;
    private JPasswordField passphraseField;
    private JLabel useKnownHostsLabel;
    private JRadioButton useKnownHostsYesRadio;
    private JRadioButton useKnownHostsAskRadio;
    private JRadioButton useKnownHostsNoRadio;
    private ButtonGroup knownHostsButtonGroup;
    private JLabel knownHostsLocationLabel;
    private JTextField knownHostsField;
    private JLabel configurationsLabel;
    private MirthTable configurationsTable;
    private JScrollPane configurationsScrollPane;
    private JButton newButton;
    private JButton deleteButton;
    private JButton okButton;
    private JButton cancelButton;

    public AdvancedSftpSettingsDialog(SftpSchemeProperties schemeProperties) {
        this.setTitle("Method Settings");
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(600, 400));
        DisplayUtil.setResizable((Dialog)((Object)this), (boolean)false);
        this.setLayout((LayoutManager)new MigLayout("insets 8 8 0 8, novisualpadding, hidemode 3"));
        this.getContentPane().setBackground(UIConstants.BACKGROUND_COLOR);
        this.initComponents();
        this.initLayout();
        this.setFileSchemeProperties(schemeProperties);
        this.keyLocationField.setBackground(null);
        this.knownHostsField.setBackground(null);
        this.setLocationRelativeTo((Component)PlatformUI.MIRTH_FRAME);
        this.setVisible(true);
    }

    @Override
    public boolean wasSaved() {
        return this.saved;
    }

    @Override
    public SchemeProperties getSchemeProperties() {
        SftpSchemeProperties props = new SftpSchemeProperties();
        if (this.usePasswordRadio.isSelected()) {
            props.setPasswordAuth(true);
            props.setKeyAuth(false);
        } else if (this.usePrivateKeyRadio.isSelected()) {
            props.setPasswordAuth(false);
            props.setKeyAuth(true);
        } else {
            props.setPasswordAuth(true);
            props.setKeyAuth(true);
        }
        props.setKeyFile(this.keyLocationField.getText());
        props.setPassPhrase(new String(this.passphraseField.getPassword()));
        if (this.useKnownHostsYesRadio.isSelected()) {
            props.setHostChecking("yes");
        } else if (this.useKnownHostsAskRadio.isSelected()) {
            props.setHostChecking("ask");
        } else {
            props.setHostChecking("no");
        }
        props.setKnownHostsFile(this.knownHostsField.getText());
        LinkedHashMap<String, String> configurationSettings = new LinkedHashMap<String, String>();
        for (int rowCount = 0; rowCount < this.configurationsTable.getRowCount(); ++rowCount) {
            configurationSettings.put((String)this.configurationsTable.getValueAt(rowCount, 0), (String)this.configurationsTable.getValueAt(rowCount, 1));
        }
        props.setConfigurationSettings(configurationSettings);
        return props;
    }

    public void setFileSchemeProperties(SftpSchemeProperties schemeProperties) {
        if (schemeProperties.isPasswordAuth() && schemeProperties.isKeyAuth()) {
            this.useBothRadio.setSelected(true);
        } else if (schemeProperties.isKeyAuth()) {
            this.usePrivateKeyRadio.setSelected(true);
        } else {
            this.usePasswordRadio.setSelected(true);
        }
        this.keyLocationField.setText(schemeProperties.getKeyFile());
        this.passphraseField.setText(schemeProperties.getPassPhrase());
        String hostnameVerification = schemeProperties.getHostChecking();
        if (hostnameVerification.equals("yes")) {
            this.useKnownHostsYesRadio.setSelected(true);
        } else if (hostnameVerification.equals("ask")) {
            this.useKnownHostsAskRadio.setSelected(true);
        } else {
            this.useKnownHostsNoRadio.setSelected(true);
        }
        this.knownHostsField.setText(schemeProperties.getKnownHostsFile());
        Map configurationSettings = schemeProperties.getConfigurationSettings();
        if (configurationSettings != null && configurationSettings.size() > 0) {
            DefaultTableModel model = (DefaultTableModel)this.configurationsTable.getModel();
            model.setNumRows(0);
            for (Map.Entry entry : configurationSettings.entrySet()) {
                model.addRow(new Object[]{entry.getKey(), entry.getValue()});
            }
            this.deleteButton.setEnabled(true);
        } else {
            this.configurationsTable.setModel((TableModel)new RefreshTableModel(new Object[0][1], (Object[])new String[]{"Name", "Value"}));
            this.configurationsTable.getColumnModel().getColumn(this.configurationsTable.getColumnModel().getColumnIndex("Name")).setCellEditor((TableCellEditor)((Object)new ConfigTableCellEditor(true)));
            this.configurationsTable.getColumnModel().getColumn(this.configurationsTable.getColumnModel().getColumnIndex("Value")).setCellEditor((TableCellEditor)((Object)new ConfigTableCellEditor(false)));
        }
        this.authenticationRadioButtonActionPerformed();
    }

    public boolean validateProperties() {
        boolean valid = true;
        Object errors = "";
        if (!this.usePasswordRadio.isSelected() && StringUtils.isEmpty((CharSequence)this.keyLocationField.getText())) {
            valid = false;
            errors = (String)errors + "Key File cannot be blank.\n";
            this.keyLocationField.setBackground(UIConstants.INVALID_COLOR);
        } else {
            this.keyLocationField.setBackground(null);
        }
        if (this.useKnownHostsYesRadio.isSelected() && StringUtils.isEmpty((CharSequence)this.knownHostsField.getText())) {
            valid = false;
            errors = (String)errors + "Known Hosts cannot be blank.";
            this.knownHostsField.setBackground(UIConstants.INVALID_COLOR);
        } else {
            this.knownHostsField.setBackground(null);
        }
        if (StringUtils.isNotBlank((CharSequence)errors)) {
            PlatformUI.MIRTH_FRAME.alertError((Component)((Object)this), (String)errors);
            return valid;
        }
        return valid;
    }

    private void initComponents() {
        this.authenticationLabel = new JLabel("Authentication:");
        this.usePasswordRadio = new JRadioButton("Password");
        this.usePasswordRadio.setFocusable(false);
        this.usePasswordRadio.setBackground(new Color(255, 255, 255));
        this.usePasswordRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.usePasswordRadio.setToolTipText("Select this option to use a password to gain access to the server.");
        this.usePasswordRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedSftpSettingsDialog.this.authenticationRadioButtonActionPerformed();
            }
        });
        this.usePrivateKeyRadio = new JRadioButton("Public Key");
        this.usePrivateKeyRadio.setSelected(true);
        this.usePrivateKeyRadio.setFocusable(false);
        this.usePrivateKeyRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.usePrivateKeyRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.usePrivateKeyRadio.setToolTipText("Select this option to use a public/private keypair to gain access to the server.");
        this.usePrivateKeyRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedSftpSettingsDialog.this.authenticationRadioButtonActionPerformed();
            }
        });
        this.useBothRadio = new JRadioButton("Both");
        this.useBothRadio.setSelected(true);
        this.useBothRadio.setFocusable(false);
        this.useBothRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.useBothRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useBothRadio.setToolTipText("Select this option to use both a password and a public/private keypair to gain access to the server.");
        this.useBothRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedSftpSettingsDialog.this.authenticationRadioButtonActionPerformed();
            }
        });
        this.privateKeyButtonGroup = new ButtonGroup();
        this.privateKeyButtonGroup.add(this.usePasswordRadio);
        this.privateKeyButtonGroup.add(this.usePrivateKeyRadio);
        this.privateKeyButtonGroup.add(this.useBothRadio);
        this.keyLocationLabel = new JLabel("Public/Private Key File:");
        this.keyLocationField = new JTextField();
        this.keyLocationField.setToolTipText("The absolute file path of the public/private keypair used to gain access to the remote server.");
        this.passphraseLabel = new JLabel("Passphrase:");
        this.passphraseField = new JPasswordField();
        this.passphraseField.setToolTipText("The passphrase associated with the public/private keypair.");
        this.useKnownHostsLabel = new JLabel("Host Key Checking:");
        this.useKnownHostsYesRadio = new JRadioButton("Yes");
        this.useKnownHostsYesRadio.setFocusable(false);
        this.useKnownHostsYesRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.useKnownHostsYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useKnownHostsYesRadio.setToolTipText("<html>Select this option to validate the server's host key within the provided<br>Known Hosts file. Known Hosts file is required.</html>");
        this.useKnownHostsAskRadio = new JRadioButton("Ask");
        this.useKnownHostsAskRadio.setFocusable(false);
        this.useKnownHostsAskRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.useKnownHostsAskRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useKnownHostsAskRadio.setToolTipText("<html>Select this option to ask the user to add the server's host key to the provided<br>Known Hosts file. Known Hosts file is optional.</html>");
        this.useKnownHostsNoRadio = new JRadioButton("No");
        this.useKnownHostsNoRadio.setSelected(true);
        this.useKnownHostsNoRadio.setFocusable(false);
        this.useKnownHostsNoRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.useKnownHostsNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useKnownHostsNoRadio.setToolTipText("<html>Select this option to always add the server's host key to the provided<br>Known Hosts file. Known Hosts file is optional.</html>");
        this.knownHostsButtonGroup = new ButtonGroup();
        this.knownHostsButtonGroup.add(this.useKnownHostsYesRadio);
        this.knownHostsButtonGroup.add(this.useKnownHostsAskRadio);
        this.knownHostsButtonGroup.add(this.useKnownHostsNoRadio);
        this.knownHostsLocationLabel = new JLabel("Known Hosts File:");
        this.knownHostsField = new JTextField();
        this.knownHostsField.setToolTipText("The path to the local Known Hosts file used to authenticate the remote server.");
        this.configurationsLabel = new JLabel("Configuration Options:");
        this.configurationsTable = new MirthTable();
        Object[][] tableData = new Object[0][1];
        this.configurationsTable.setModel((TableModel)new RefreshTableModel(tableData, (Object[])new String[]{"Name", "Value"}));
        this.configurationsTable.setOpaque(true);
        this.configurationsTable.getColumnModel().getColumn(this.configurationsTable.getColumnModel().getColumnIndex("Name")).setCellEditor((TableCellEditor)((Object)new ConfigTableCellEditor(true)));
        this.configurationsTable.getColumnModel().getColumn(this.configurationsTable.getColumnModel().getColumnIndex("Value")).setCellEditor((TableCellEditor)((Object)new ConfigTableCellEditor(false)));
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.configurationsTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.configurationsScrollPane = new JScrollPane();
        this.configurationsScrollPane.getViewport().add((Component)this.configurationsTable);
        this.newButton = new JButton("New");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTableModel model = (DefaultTableModel)AdvancedSftpSettingsDialog.this.configurationsTable.getModel();
                Vector<CallSite> row = new Vector<CallSite>();
                String header = "Property";
                for (int i = 1; i <= AdvancedSftpSettingsDialog.this.configurationsTable.getRowCount() + 1; ++i) {
                    boolean exists = false;
                    for (int index = 0; index < AdvancedSftpSettingsDialog.this.configurationsTable.getRowCount(); ++index) {
                        if (!((String)AdvancedSftpSettingsDialog.this.configurationsTable.getValueAt(index, 0)).equalsIgnoreCase(header + i)) continue;
                        exists = true;
                    }
                    if (exists) continue;
                    row.add((CallSite)((Object)(header + i)));
                    break;
                }
                model.addRow(row);
                int rowSelectionNumber = AdvancedSftpSettingsDialog.this.configurationsTable.getRowCount() - 1;
                AdvancedSftpSettingsDialog.this.configurationsTable.setRowSelectionInterval(rowSelectionNumber, rowSelectionNumber);
                Boolean enabled = AdvancedSftpSettingsDialog.this.deleteButton.isEnabled();
                if (!enabled.booleanValue()) {
                    AdvancedSftpSettingsDialog.this.deleteButton.setEnabled(true);
                }
            }
        });
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowSelectionNumber = AdvancedSftpSettingsDialog.this.configurationsTable.getSelectedRow();
                if (rowSelectionNumber > -1) {
                    DefaultTableModel model = (DefaultTableModel)AdvancedSftpSettingsDialog.this.configurationsTable.getModel();
                    model.removeRow(rowSelectionNumber);
                    if (--rowSelectionNumber > -1) {
                        AdvancedSftpSettingsDialog.this.configurationsTable.setRowSelectionInterval(rowSelectionNumber, rowSelectionNumber);
                    }
                    if (AdvancedSftpSettingsDialog.this.configurationsTable.getRowCount() == 0) {
                        AdvancedSftpSettingsDialog.this.deleteButton.setEnabled(false);
                    }
                }
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedSftpSettingsDialog.this.okCancelButtonActionPerformed();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedSftpSettingsDialog.this.dispose();
            }
        });
        this.authenticationRadioButtonActionPerformed();
    }

    private void initLayout() {
        JPanel propertiesPanel = new JPanel((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fillx", "[right][left]"));
        propertiesPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        propertiesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(204, 204, 204)), "SFTP Settings", 0, 0, new Font("Tahoma", 1, 11)));
        propertiesPanel.add(this.authenticationLabel);
        propertiesPanel.add((Component)this.usePasswordRadio, "split 3");
        propertiesPanel.add(this.usePrivateKeyRadio);
        propertiesPanel.add((Component)this.useBothRadio, "push, wrap");
        propertiesPanel.add(this.keyLocationLabel);
        propertiesPanel.add((Component)this.keyLocationField, "w 200!, wrap");
        propertiesPanel.add(this.passphraseLabel);
        propertiesPanel.add((Component)this.passphraseField, "w 125!, wrap");
        propertiesPanel.add(this.useKnownHostsLabel);
        propertiesPanel.add((Component)this.useKnownHostsYesRadio, "split 3");
        propertiesPanel.add(this.useKnownHostsAskRadio);
        propertiesPanel.add((Component)this.useKnownHostsNoRadio, "push, wrap");
        propertiesPanel.add(this.knownHostsLocationLabel);
        propertiesPanel.add((Component)this.knownHostsField, "w 200!, wrap");
        propertiesPanel.add((Component)this.configurationsLabel, "aligny top");
        propertiesPanel.add((Component)this.configurationsScrollPane, "span, grow, split 2");
        JPanel configurationsButtonPanel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        configurationsButtonPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        configurationsButtonPanel.add((Component)this.newButton, "w 50!, wrap");
        configurationsButtonPanel.add((Component)this.deleteButton, "w 50!");
        propertiesPanel.add((Component)configurationsButtonPanel, "top");
        this.add(propertiesPanel, "grow, push, top, wrap");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("insets 0 8 8 8, novisualpadding, hidemode 3, fill"));
        buttonPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        buttonPanel.add((Component)new JSeparator(), "growx, sx, wrap");
        buttonPanel.add((Component)this.okButton, "newline, w 50!, sx, right, split");
        buttonPanel.add((Component)this.cancelButton, "w 50!");
        this.add(buttonPanel, "south, span");
    }

    private void okCancelButtonActionPerformed() {
        if (this.configurationsTable.isEditing()) {
            this.configurationsTable.getCellEditor().stopCellEditing();
        }
        if (!this.validateProperties()) {
            return;
        }
        this.saved = true;
        PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
        this.dispose();
    }

    private void authenticationRadioButtonActionPerformed() {
        boolean enabled = this.usePrivateKeyRadio.isSelected() || this.useBothRadio.isSelected();
        this.passphraseLabel.setEnabled(enabled);
        this.passphraseField.setEnabled(enabled);
        this.keyLocationLabel.setEnabled(enabled);
        this.keyLocationField.setEnabled(enabled);
    }

    class ConfigTableCellEditor
    extends TextFieldCellEditor {
        boolean checkProperties;

        public ConfigTableCellEditor(boolean checkProperties) {
            this.checkProperties = checkProperties;
        }

        public boolean checkUniqueProperty(String property) {
            boolean exists = false;
            for (int i = 0; i < AdvancedSftpSettingsDialog.this.configurationsTable.getRowCount(); ++i) {
                if (AdvancedSftpSettingsDialog.this.configurationsTable.getValueAt(i, 0) == null || !((String)AdvancedSftpSettingsDialog.this.configurationsTable.getValueAt(i, 0)).equalsIgnoreCase(property)) continue;
                exists = true;
            }
            return exists;
        }

        public boolean isCellEditable(EventObject evt) {
            boolean editable = super.isCellEditable(evt);
            if (editable) {
                AdvancedSftpSettingsDialog.this.deleteButton.setEnabled(false);
            }
            return editable;
        }

        protected boolean valueChanged(String value) {
            AdvancedSftpSettingsDialog.this.deleteButton.setEnabled(true);
            return !this.checkProperties || value.length() != 0 && !this.checkUniqueProperty(value);
        }
    }
}

