/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.ConnectorTypeDecoration;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthPasswordField;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.MirthVariableList;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.panels.connectors.ResponseHandler;
import com.mirth.connect.connectors.file.AdvancedFTPSettingsDialog;
import com.mirth.connect.connectors.file.AdvancedS3SettingsDialog;
import com.mirth.connect.connectors.file.AdvancedSettingsDialog;
import com.mirth.connect.connectors.file.AdvancedSftpSettingsDialog;
import com.mirth.connect.connectors.file.AdvancedSmbSettingsDialog;
import com.mirth.connect.connectors.file.FTPSchemeProperties;
import com.mirth.connect.connectors.file.FileAction;
import com.mirth.connect.connectors.file.FileConnectorServletInterface;
import com.mirth.connect.connectors.file.FileReceiverProperties;
import com.mirth.connect.connectors.file.FileScheme;
import com.mirth.connect.connectors.file.S3SchemeProperties;
import com.mirth.connect.connectors.file.SchemeProperties;
import com.mirth.connect.connectors.file.SftpSchemeProperties;
import com.mirth.connect.connectors.file.SmbSchemeProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.util.ConnectionTestResponse;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileReader
extends ConnectorSettingsPanel {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private FileScheme selectedScheme;
    private SchemeProperties advancedProperties;
    private MirthComboBox afterProcessingActionComboBox;
    private JLabel afterProcessingActionLabel;
    private JLabel anonymousLabel;
    private MirthRadioButton anonymousNoRadio;
    private MirthRadioButton anonymousYesRadio;
    private ButtonGroup anonymousButtonGroup;
    private ButtonGroup checkFileAgeButtonGroup;
    private ButtonGroup fileTypeButtonGroup;
    private ButtonGroup secureModeButtonGroup;
    private MirthComboBox charsetEncodingComboBox;
    private JLabel checkFileAgeLabel;
    private MirthRadioButton checkFileAgeNoRadio;
    private MirthRadioButton checkFileAgeYesRadio;
    private MirthTextField directoryField;
    private JLabel directoryLabel;
    private ButtonGroup directoryRecursionButtonGroup;
    private JLabel directoryRecursionLabel;
    private MirthRadioButton directoryRecursionNoRadio;
    private MirthRadioButton directoryRecursionYesRadio;
    private JLabel encodingLabel;
    private MirthTextField errorMoveToDirectoryField;
    private JLabel errorMoveToDirectoryLabel;
    private MirthTextField errorMoveToFileNameField;
    private JLabel errorMoveToFileNameLabel;
    private MirthComboBox errorReadingActionComboBox;
    private MirthComboBox errorResponseActionComboBox;
    private JLabel errorResponseActionLabel;
    private MirthTextField fileAgeField;
    private JLabel fileAgeLabel;
    private MirthTextField fileNameFilterField;
    private JLabel fileSizeDashLabel;
    private JLabel fileSizeLabel;
    private MirthTextField fileSizeMaximumField;
    private MirthTextField fileSizeMinimumField;
    private MirthRadioButton fileTypeText;
    private MirthRadioButton fileTypeBinary;
    private JLabel fileTypeLabel;
    private JLabel filenameFilterLabel;
    private MirthCheckBox filenameFilterRegexCheckBox;
    private MirthTextField hostField;
    private JLabel hostLabel;
    private ButtonGroup ignoreDotFilesButtonGroup;
    private JLabel ignoreDotFilesLabel;
    private MirthRadioButton ignoreDotFilesNoRadio;
    private MirthRadioButton ignoreDotFilesYesRadio;
    private MirthCheckBox ignoreFileSizeMaximumCheckBox;
    private JScrollPane variableListScrollPane;
    private MirthVariableList mirthVariableList;
    private MirthTextField moveToDirectoryField;
    private JLabel moveToDirectoryLabel;
    private JLabel errorReadingActionLabel;
    private MirthTextField moveToFileNameField;
    private JLabel moveToFileNameLabel;
    private MirthPasswordField passwordField;
    private JLabel passwordLabel;
    private MirthTextField pathField;
    private JLabel pathLabel;
    private MirthComboBox<FileScheme> schemeComboBox;
    private JLabel schemeLabel;
    private MirthComboBox sortByComboBox;
    private JLabel sortFilesByLabel;
    private JButton testConnectionButton;
    private MirthTextField timeoutField;
    private JLabel timeoutLabel;
    private MirthTextField usernameField;
    private JLabel usernameLabel;
    private JButton advancedSettingsButton;
    private JLabel summaryLabel;
    private JLabel summaryField;
    private JLabel passiveModeLabel;
    private MirthRadioButton passiveModeNoRadio;
    private MirthRadioButton passiveModeYesRadio;
    private ButtonGroup passiveModeButtonGroup;
    private JLabel validateConnectionLabel;
    private MirthRadioButton validateConnectionNoRadio;
    private MirthRadioButton validateConnectionYesRadio;
    private ButtonGroup validateConnectionButtonGroup;
    private JLabel secureModeLabel;
    private MirthRadioButton secureModeNoRadio;
    private MirthRadioButton secureModeYesRadio;

    public FileReader() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.initComponents();
        this.initLayout();
        this.afterProcessingActionComboBox.setModel(new DefaultComboBoxModel<FileAction>(new FileAction[]{FileAction.NONE, FileAction.MOVE, FileAction.DELETE}));
        this.errorReadingActionComboBox.setModel(new DefaultComboBoxModel<FileAction>(new FileAction[]{FileAction.NONE, FileAction.MOVE, FileAction.DELETE}));
        this.errorResponseActionComboBox.setModel(new DefaultComboBoxModel<FileAction>(new FileAction[]{FileAction.AFTER_PROCESSING, FileAction.MOVE, FileAction.DELETE}));
        this.fileAgeField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        this.fileSizeMinimumField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        this.fileSizeMaximumField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        this.parent.setupCharsetEncodingForConnector((JComboBox)this.charsetEncodingComboBox);
    }

    public String getConnectorName() {
        return new FileReceiverProperties().getName();
    }

    public ConnectorProperties getProperties() {
        FileReceiverProperties properties = new FileReceiverProperties();
        properties.setScheme((FileScheme)this.schemeComboBox.getSelectedItem());
        properties.setSchemeProperties(this.advancedProperties);
        if (this.schemeComboBox.getSelectedItem() == FileScheme.FILE) {
            properties.setHost(this.directoryField.getText().replace('\\', '/'));
        } else {
            properties.setHost(this.hostField.getText() + "/" + this.pathField.getText());
        }
        properties.setDirectoryRecursion(this.directoryRecursionYesRadio.isSelected());
        properties.setIgnoreDot(this.ignoreDotFilesYesRadio.isSelected());
        properties.setAnonymous(this.anonymousYesRadio.isSelected());
        properties.setUsername(this.usernameField.getText());
        properties.setPassword(new String(this.passwordField.getPassword()));
        properties.setTimeout(this.timeoutField.getText());
        properties.setSecure(this.secureModeYesRadio.isSelected());
        properties.setPassive(this.passiveModeYesRadio.isSelected());
        properties.setValidateConnection(this.validateConnectionYesRadio.isSelected());
        properties.setAfterProcessingAction((FileAction)this.afterProcessingActionComboBox.getSelectedItem());
        properties.setMoveToDirectory(this.moveToDirectoryField.getText().replace('\\', '/'));
        properties.setMoveToFileName(this.moveToFileNameField.getText());
        properties.setErrorReadingAction((FileAction)this.errorReadingActionComboBox.getSelectedItem());
        properties.setErrorResponseAction((FileAction)this.errorResponseActionComboBox.getSelectedItem());
        properties.setErrorMoveToDirectory(this.errorMoveToDirectoryField.getText().replace('\\', '/'));
        properties.setErrorMoveToFileName(this.errorMoveToFileNameField.getText());
        properties.setCheckFileAge(this.checkFileAgeYesRadio.isSelected());
        properties.setFileAge(this.fileAgeField.getText());
        properties.setFileSizeMinimum(this.fileSizeMinimumField.getText());
        properties.setFileSizeMaximum(this.fileSizeMaximumField.getText());
        properties.setIgnoreFileSizeMaximum(this.ignoreFileSizeMaximumCheckBox.isSelected());
        if (((String)this.sortByComboBox.getSelectedItem()).equals("Name")) {
            properties.setSortBy("name");
        } else if (((String)this.sortByComboBox.getSelectedItem()).equals("Size")) {
            properties.setSortBy("size");
        } else if (((String)this.sortByComboBox.getSelectedItem()).equals("Date")) {
            properties.setSortBy("date");
        }
        properties.setCharsetEncoding(this.parent.getSelectedEncodingForConnector((JComboBox)this.charsetEncodingComboBox));
        properties.setFileFilter(this.fileNameFilterField.getText());
        properties.setRegex(this.filenameFilterRegexCheckBox.isSelected());
        properties.setBinary(this.fileTypeBinary.isSelected());
        this.logger.debug("getProperties: properties=" + String.valueOf(properties));
        return properties;
    }

    private boolean setDirHostPath(FileReceiverProperties props, boolean store, boolean highlight) {
        boolean valid = true;
        FileScheme scheme = props.getScheme();
        String hostPropValue = props.getHost();
        String directoryValue = "";
        String hostValue = "";
        String pathValue = "";
        if (scheme.equals((Object)FileScheme.FILE)) {
            directoryValue = hostPropValue;
            if (directoryValue.length() <= 0) {
                if (highlight) {
                    this.directoryField.setBackground(UIConstants.INVALID_COLOR);
                }
                valid = false;
            }
        } else {
            int splitIndex = hostPropValue.indexOf(47);
            if (splitIndex != -1) {
                hostValue = hostPropValue.substring(0, splitIndex);
                pathValue = hostPropValue.substring(splitIndex + 1);
            } else {
                hostValue = hostPropValue;
            }
            if (hostValue.length() <= 0) {
                if (highlight) {
                    this.hostField.setBackground(UIConstants.INVALID_COLOR);
                }
                valid = false;
            }
        }
        if (store) {
            this.directoryField.setText(directoryValue);
            this.hostField.setText(hostValue);
            this.pathField.setText(pathValue);
        }
        return valid;
    }

    public void setProperties(ConnectorProperties properties) {
        this.logger.debug("setProperties: props=" + String.valueOf(properties));
        FileReceiverProperties props = (FileReceiverProperties)properties;
        this.selectedScheme = null;
        FileScheme scheme = props.getScheme();
        this.schemeComboBox.setSelectedItem((Object)scheme);
        this.schemeComboBoxActionPerformed(null);
        this.advancedProperties = props.getSchemeProperties();
        this.setSummaryText();
        this.setDirHostPath(props, true, false);
        if (props.isDirectoryRecursion()) {
            this.directoryRecursionYesRadio.setSelected(true);
        } else {
            this.directoryRecursionNoRadio.setSelected(true);
        }
        if (props.isIgnoreDot()) {
            this.ignoreDotFilesYesRadio.setSelected(true);
        } else {
            this.ignoreDotFilesNoRadio.setSelected(true);
        }
        if (props.isAnonymous()) {
            this.anonymousYesRadio.setSelected(true);
            this.anonymousYesActionPerformed(null);
        } else {
            this.anonymousNoRadio.setSelected(true);
            this.anonymousNoActionPerformed(null);
            this.usernameField.setText(props.getUsername());
            this.passwordField.setText(props.getPassword());
        }
        this.timeoutField.setText(props.getTimeout());
        if (props.isSecure()) {
            this.secureModeYesRadio.setSelected(true);
            if (scheme == FileScheme.WEBDAV) {
                this.hostLabel.setText("https://");
            }
        } else {
            this.secureModeNoRadio.setSelected(true);
            if (scheme == FileScheme.WEBDAV) {
                this.hostLabel.setText("http://");
            }
        }
        if (props.isPassive()) {
            this.passiveModeYesRadio.setSelected(true);
        } else {
            this.passiveModeNoRadio.setSelected(true);
        }
        if (props.isValidateConnection()) {
            this.validateConnectionYesRadio.setSelected(true);
        } else {
            this.validateConnectionNoRadio.setSelected(true);
        }
        this.afterProcessingActionComboBox.setSelectedItem((Object)props.getAfterProcessingAction());
        this.afterProcessingActionComboBoxActionPerformed(null);
        this.moveToDirectoryField.setText(props.getMoveToDirectory());
        this.moveToFileNameField.setText(props.getMoveToFileName());
        this.errorReadingActionComboBox.setSelectedItem((Object)props.getErrorReadingAction());
        this.errorResponseActionComboBox.setSelectedItem((Object)props.getErrorResponseAction());
        this.errorMoveToDirectoryField.setText(props.getErrorMoveToDirectory());
        this.errorMoveToFileNameField.setText(props.getErrorMoveToFileName());
        this.updateErrorFields();
        if (props.isCheckFileAge()) {
            this.checkFileAgeYesRadio.setSelected(true);
            this.checkFileAgeYesActionPerformed(null);
        } else {
            this.checkFileAgeNoRadio.setSelected(true);
            this.checkFileAgeNoActionPerformed(null);
        }
        this.fileAgeField.setText(props.getFileAge());
        this.fileSizeMinimumField.setText(props.getFileSizeMinimum());
        this.fileSizeMaximumField.setText(props.getFileSizeMaximum());
        this.ignoreFileSizeMaximumCheckBox.setSelected(props.isIgnoreFileSizeMaximum());
        this.ignoreFileSizeMaximumCheckBoxActionPerformed(null);
        if (props.getSortBy().equals("name")) {
            this.sortByComboBox.setSelectedItem((Object)"Name");
        } else if (props.getSortBy().equals("size")) {
            this.sortByComboBox.setSelectedItem((Object)"Size");
        } else if (props.getSortBy().equals("date")) {
            this.sortByComboBox.setSelectedItem((Object)"Date");
        }
        this.parent.setPreviousSelectedEncodingForConnector((JComboBox)this.charsetEncodingComboBox, props.getCharsetEncoding());
        this.fileNameFilterField.setText(props.getFileFilter());
        if (props.isRegex()) {
            this.filenameFilterRegexCheckBox.setSelected(true);
        } else {
            this.filenameFilterRegexCheckBox.setSelected(false);
        }
        if (props.isBinary()) {
            this.fileTypeBinary.setSelected(true);
            this.fileTypeBinaryActionPerformed(null);
        } else {
            this.fileTypeText.setSelected(true);
            this.fileTypeASCIIActionPerformed(null);
        }
    }

    private void setSummaryText() {
        if (this.advancedProperties != null) {
            this.summaryLabel.setEnabled(true);
            this.summaryField.setEnabled(true);
            this.summaryField.setText(this.advancedProperties.getSummaryText());
        } else {
            this.summaryLabel.setEnabled(false);
            this.summaryField.setEnabled(false);
            this.summaryField.setText("<None>");
        }
    }

    public ConnectorProperties getDefaults() {
        return new FileReceiverProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        FileScheme scheme;
        FileReceiverProperties props = (FileReceiverProperties)properties;
        boolean valid = true;
        valid = this.setDirHostPath(props, false, highlight);
        if (props.getFileFilter().length() == 0) {
            valid = false;
            if (highlight) {
                this.fileNameFilterField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (!(props.isAnonymous() || props.getScheme() == FileScheme.S3 && ((S3SchemeProperties)props.getSchemeProperties()).isUseDefaultCredentialProviderChain())) {
            boolean ignorePassword;
            if (props.getUsername().length() == 0) {
                valid = false;
                if (highlight) {
                    this.usernameField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
            boolean bl = ignorePassword = props.getScheme() == FileScheme.SFTP && !((SftpSchemeProperties)props.getSchemeProperties()).isPasswordAuth();
            if (!ignorePassword && props.getPassword().length() == 0) {
                valid = false;
                if (highlight) {
                    this.passwordField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
        }
        if (((scheme = props.getScheme()).equals((Object)FileScheme.FTP) || scheme.equals((Object)FileScheme.SFTP) || scheme.equals((Object)FileScheme.SMB)) && props.getTimeout().length() == 0) {
            valid = false;
            if (highlight) {
                this.timeoutField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.isCheckFileAge() && props.getFileAge().length() == 0) {
            valid = false;
            if (highlight) {
                this.fileAgeField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getFileSizeMinimum().length() == 0) {
            valid = false;
            if (highlight) {
                this.fileSizeMinimumField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (!props.isIgnoreFileSizeMaximum() && props.getFileSizeMaximum().length() == 0) {
            valid = false;
            if (highlight) {
                this.fileSizeMaximumField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        this.directoryField.setBackground(null);
        this.hostField.setBackground(null);
        this.pathField.setBackground(null);
        this.fileNameFilterField.setBackground(null);
        this.fileAgeField.setBackground(null);
        this.fileSizeMinimumField.setBackground(null);
        this.fileSizeMaximumField.setBackground(null);
        this.usernameField.setBackground(null);
        this.passwordField.setBackground(null);
        this.timeoutField.setBackground(null);
    }

    public void doLocalDecoration(ConnectorTypeDecoration connectorTypeDecoration) {
        if (FileScheme.FTP == this.schemeComboBox.getSelectedItem()) {
            this.hostLabel.setText("ftp" + (connectorTypeDecoration != null ? "s" : "") + "://");
        }
    }

    private void initComponents() {
        this.schemeLabel = new JLabel();
        this.schemeLabel.setText("Method:");
        this.schemeComboBox = new MirthComboBox();
        this.schemeComboBox.setModel(new DefaultComboBoxModel<FileScheme>(FileScheme.values()));
        this.schemeComboBox.setToolTipText("The basic method used to access files to be read - file (local filesystem), FTP, SFTP, S3, SMB, or WebDAV");
        this.schemeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.schemeComboBoxActionPerformed(evt);
            }
        });
        this.testConnectionButton = new JButton();
        this.testConnectionButton.setText("Test Read");
        this.testConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.testConnectionActionPerformed(evt);
            }
        });
        this.advancedSettingsButton = new JButton(new ImageIcon(Frame.class.getResource("images/wrench.png")));
        this.advancedSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileReader.this.advancedFileSettingsActionPerformed();
            }
        });
        this.summaryLabel = new JLabel("Advanced Options:");
        this.summaryField = new JLabel("");
        this.directoryLabel = new JLabel();
        this.directoryLabel.setText("Directory:");
        this.directoryField = new MirthTextField();
        this.directoryField.setToolTipText("The directory (folder) in which the files to be read can be found.");
        this.hostLabel = new JLabel();
        this.hostLabel.setText("ftp://");
        this.hostField = new MirthTextField();
        this.hostField.setToolTipText("The name or IP address of the host (computer) on which the files to be read can be found.");
        this.pathLabel = new JLabel();
        this.pathLabel.setText("/");
        this.pathField = new MirthTextField();
        this.pathField.setToolTipText("The directory (folder) in which the files to be read can be found.");
        this.filenameFilterLabel = new JLabel();
        this.filenameFilterLabel.setText("Filename Filter Pattern:");
        this.fileNameFilterField = new MirthTextField();
        this.fileNameFilterField.setToolTipText("<html>The pattern which names of files must match in order to be read.<br>Files with names that do not match the pattern will be ignored.</html>");
        this.filenameFilterRegexCheckBox = new MirthCheckBox();
        this.filenameFilterRegexCheckBox.setBackground(UIConstants.BACKGROUND_COLOR);
        this.filenameFilterRegexCheckBox.setText("Regular Expression");
        this.filenameFilterRegexCheckBox.setToolTipText("<html>If Regex is checked, the pattern is treated as a regular expression.<br>If Regex is not checked, it is treated as a pattern that supports wildcards and a comma separated list.</html>");
        this.directoryRecursionLabel = new JLabel();
        this.directoryRecursionLabel.setText("Include All Subdirectories:");
        this.directoryRecursionYesRadio = new MirthRadioButton();
        this.directoryRecursionYesRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.directoryRecursionYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.directoryRecursionYesRadio.setText("Yes");
        this.directoryRecursionYesRadio.setToolTipText("<html>Select Yes to traverse directories recursively and search for files in each one.</html>");
        this.directoryRecursionYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.directoryRecursionYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.directoryRecursionYesRadioActionPerformed(evt);
            }
        });
        this.directoryRecursionNoRadio = new MirthRadioButton();
        this.directoryRecursionNoRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.directoryRecursionNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.directoryRecursionNoRadio.setSelected(true);
        this.directoryRecursionNoRadio.setText("No");
        this.directoryRecursionNoRadio.setToolTipText("<html>Select No to only search for files in the selected directory/location, ignoring subdirectories.</html>");
        this.directoryRecursionNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.directoryRecursionButtonGroup = new ButtonGroup();
        this.directoryRecursionButtonGroup.add((AbstractButton)this.directoryRecursionYesRadio);
        this.directoryRecursionButtonGroup.add((AbstractButton)this.directoryRecursionNoRadio);
        this.ignoreDotFilesLabel = new JLabel();
        this.ignoreDotFilesLabel.setText("Ignore . files:");
        this.ignoreDotFilesYesRadio = new MirthRadioButton();
        this.ignoreDotFilesYesRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.ignoreDotFilesYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ignoreDotFilesYesRadio.setText("Yes");
        this.ignoreDotFilesYesRadio.setToolTipText("Select Yes to ignore all files starting with a period.");
        this.ignoreDotFilesYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.ignoreDotFilesNoRadio = new MirthRadioButton();
        this.ignoreDotFilesNoRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.ignoreDotFilesNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ignoreDotFilesNoRadio.setText("No");
        this.ignoreDotFilesNoRadio.setToolTipText("Select No to process files starting with a period.");
        this.ignoreDotFilesNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.ignoreDotFilesButtonGroup = new ButtonGroup();
        this.ignoreDotFilesButtonGroup.add((AbstractButton)this.ignoreDotFilesYesRadio);
        this.ignoreDotFilesButtonGroup.add((AbstractButton)this.ignoreDotFilesNoRadio);
        this.anonymousLabel = new JLabel();
        this.anonymousLabel.setText("Anonymous:");
        this.anonymousYesRadio = new MirthRadioButton();
        this.anonymousYesRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.anonymousYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.anonymousYesRadio.setText("Yes");
        this.anonymousYesRadio.setToolTipText("Connects to the file anonymously instead of using a username and password.");
        this.anonymousYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.anonymousYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.anonymousYesActionPerformed(evt);
            }
        });
        this.anonymousNoRadio = new MirthRadioButton();
        this.anonymousNoRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.anonymousNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.anonymousNoRadio.setSelected(true);
        this.anonymousNoRadio.setText("No");
        this.anonymousNoRadio.setToolTipText("Connects to the file using a username and password instead of anonymously.");
        this.anonymousNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.anonymousNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.anonymousNoActionPerformed(evt);
            }
        });
        this.anonymousButtonGroup = new ButtonGroup();
        this.anonymousButtonGroup.add((AbstractButton)this.anonymousYesRadio);
        this.anonymousButtonGroup.add((AbstractButton)this.anonymousNoRadio);
        this.usernameLabel = new JLabel();
        this.usernameLabel.setText("Username:");
        this.usernameField = new MirthTextField();
        this.usernameField.setToolTipText("The user name used to gain access to the server.");
        this.passwordLabel = new JLabel();
        this.passwordLabel.setText("Password:");
        this.passwordField = new MirthPasswordField();
        this.passwordField.setToolTipText("The password used to gain access to the server.");
        this.timeoutLabel = new JLabel();
        this.timeoutLabel.setText("Timeout (ms):");
        this.timeoutField = new MirthTextField();
        this.timeoutField.setToolTipText("The socket timeout (in ms) for connecting to the server.");
        this.secureModeLabel = new JLabel();
        this.secureModeLabel.setText("Secure Mode:");
        this.secureModeYesRadio = new MirthRadioButton();
        this.secureModeYesRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.secureModeYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.secureModeYesRadio.setText("Yes");
        this.secureModeYesRadio.setToolTipText("<html>Select Yes to connect to the server via HTTPS.<br>Select No to connect via HTTP.</html>");
        this.secureModeYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.secureModeYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.secureModeYesActionPerformed(evt);
            }
        });
        this.secureModeNoRadio = new MirthRadioButton();
        this.secureModeNoRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.secureModeNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.secureModeNoRadio.setSelected(true);
        this.secureModeNoRadio.setText("No");
        this.secureModeNoRadio.setToolTipText("<html>Select Yes to connect to the server via HTTPS.<br>Select No to connect via HTTP.</html>");
        this.secureModeNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.secureModeNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.secureModeNoActionPerformed(evt);
            }
        });
        this.secureModeButtonGroup = new ButtonGroup();
        this.secureModeButtonGroup.add((AbstractButton)this.secureModeYesRadio);
        this.secureModeButtonGroup.add((AbstractButton)this.secureModeNoRadio);
        this.passiveModeLabel = new JLabel();
        this.passiveModeLabel.setText("Passive Mode:");
        this.passiveModeYesRadio = new MirthRadioButton();
        this.passiveModeYesRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.passiveModeYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.passiveModeYesRadio.setText("Yes");
        this.passiveModeYesRadio.setToolTipText("<html>Select Yes to connect to the server in \"passive mode\".<br>Passive mode sometimes allows a connection through a firewall that normal mode does not.</html>");
        this.passiveModeYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.passiveModeNoRadio = new MirthRadioButton();
        this.passiveModeNoRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.passiveModeNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.passiveModeNoRadio.setSelected(true);
        this.passiveModeNoRadio.setText("No");
        this.passiveModeNoRadio.setToolTipText("Select Yes to connect to the server in \"normal mode\" as opposed to passive mode.");
        this.passiveModeNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.passiveModeButtonGroup = new ButtonGroup();
        this.passiveModeButtonGroup.add((AbstractButton)this.passiveModeYesRadio);
        this.passiveModeButtonGroup.add((AbstractButton)this.passiveModeNoRadio);
        this.validateConnectionLabel = new JLabel();
        this.validateConnectionLabel.setText("Validate Connection:");
        this.validateConnectionYesRadio = new MirthRadioButton();
        this.validateConnectionYesRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.validateConnectionYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.validateConnectionYesRadio.setText("Yes");
        this.validateConnectionYesRadio.setToolTipText("Select Yes to test the connection to the server before each operation.");
        this.validateConnectionYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.validateConnectionNoRadio = new MirthRadioButton();
        this.validateConnectionNoRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.validateConnectionNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.validateConnectionNoRadio.setText("No");
        this.validateConnectionNoRadio.setToolTipText("Select No to skip testing the connection to the server before each operation.");
        this.validateConnectionNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.validateConnectionButtonGroup = new ButtonGroup();
        this.validateConnectionButtonGroup.add((AbstractButton)this.validateConnectionYesRadio);
        this.validateConnectionButtonGroup.add((AbstractButton)this.validateConnectionNoRadio);
        this.afterProcessingActionLabel = new JLabel();
        this.afterProcessingActionLabel.setText("After Processing Action:");
        this.afterProcessingActionComboBox = new MirthComboBox();
        this.afterProcessingActionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Move", "Delete"}));
        this.afterProcessingActionComboBox.setToolTipText("<html>Select Move to move and/or rename the file after successful processing.<br/>Select Delete to delete the file after successful processing.</html>");
        this.afterProcessingActionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.afterProcessingActionComboBoxActionPerformed(evt);
            }
        });
        this.moveToDirectoryLabel = new JLabel();
        this.moveToDirectoryLabel.setText("Move-to Directory:");
        this.moveToDirectoryField = new MirthTextField();
        this.moveToDirectoryField.setToolTipText("<html>If successfully processed files should be moved to a different directory (folder), enter that directory here.<br>The directory name specified may include template substitutions from the list to the right.<br>If this field is left empty, successfully processed files will not be moved to a different directory.</html>");
        this.moveToFileNameLabel = new JLabel();
        this.moveToFileNameLabel.setText("Move-to File Name:");
        this.moveToFileNameField = new MirthTextField();
        this.moveToFileNameField.setToolTipText("<html>If successfully processed files should be renamed, enter the new name here.<br>The filename specified may include template substitutions from the list to the right.<br>If this field is left empty, successfully processed files will not be renamed.</html>");
        this.errorReadingActionLabel = new JLabel();
        this.errorReadingActionLabel.setText("Error Reading Action:");
        this.errorReadingActionComboBox = new MirthComboBox();
        this.errorReadingActionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Move", "Delete"}));
        this.errorReadingActionComboBox.setToolTipText("<html>Select Move to move and/or rename files that have failed to be read in.<br/>Select Delete to delete files that have failed to be read in.</html>");
        this.errorReadingActionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.errorReadingActionComboBoxActionPerformed(evt);
            }
        });
        this.errorResponseActionLabel = new JLabel();
        this.errorResponseActionLabel.setText("Error in Response Action:");
        this.errorResponseActionComboBox = new MirthComboBox();
        this.errorResponseActionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"After Processing Action", "Move", "Delete"}));
        this.errorResponseActionComboBox.setToolTipText("<html>Select Move to move and/or rename the file if an ERROR response is returned.<br/>Select Delete to delete the file if an ERROR response is returned.<br/>If After Processing Action is selected, the After Processing Action will apply.<br/>This action is only available if Process Batch Files is disabled.</html>");
        this.errorResponseActionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.errorResponseActionComboBoxActionPerformed(evt);
            }
        });
        this.errorMoveToDirectoryLabel = new JLabel();
        this.errorMoveToDirectoryLabel.setText("Error Move-to Directory:");
        this.errorMoveToDirectoryField = new MirthTextField();
        this.errorMoveToDirectoryField.setToolTipText("<html>If files which cause processing errors should be moved to a different directory (folder), enter that directory here.<br>The directory name specified may include template substitutions from the list to the right.<br>If this field is left empty, files which cause processing errors will not be moved to a different directory.</html>");
        this.errorMoveToFileNameLabel = new JLabel();
        this.errorMoveToFileNameLabel.setText("Error Move-to File Name:");
        this.errorMoveToFileNameField = new MirthTextField();
        this.errorMoveToFileNameField.setToolTipText("<html>If files which cause processing errors should be renamed, enter the new name here.<br/>The filename specified may include template substitutions from the list to the right.<br/>If this field is left empty, files which cause processing errors will not be renamed.</html>");
        this.variableListScrollPane = new JScrollPane();
        this.variableListScrollPane.setBorder(null);
        this.variableListScrollPane.setHorizontalScrollBarPolicy(31);
        this.variableListScrollPane.setVerticalScrollBarPolicy(21);
        this.mirthVariableList = new MirthVariableList();
        this.mirthVariableList.setBorder(BorderFactory.createEtchedBorder());
        this.mirthVariableList.setModel((ListModel)new AbstractListModel(){
            String[] strings = new String[]{"channelName", "channelId", "DATE", "COUNT", "UUID", "SYSTIME", "originalFilename"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.variableListScrollPane.setViewportView((Component)this.mirthVariableList);
        this.checkFileAgeLabel = new JLabel();
        this.checkFileAgeLabel.setText("Check File Age:");
        this.checkFileAgeYesRadio = new MirthRadioButton();
        this.checkFileAgeYesRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.checkFileAgeYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkFileAgeYesRadio.setText("Yes");
        this.checkFileAgeYesRadio.setToolTipText("Select Yes to skip files that are created within the specified age below.");
        this.checkFileAgeYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.checkFileAgeYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.checkFileAgeYesActionPerformed(evt);
            }
        });
        this.checkFileAgeNoRadio = new MirthRadioButton();
        this.checkFileAgeNoRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.checkFileAgeNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkFileAgeNoRadio.setSelected(true);
        this.checkFileAgeNoRadio.setText("No");
        this.checkFileAgeNoRadio.setToolTipText("Select No to process files regardless of age.");
        this.checkFileAgeNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.checkFileAgeNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.checkFileAgeNoActionPerformed(evt);
            }
        });
        this.checkFileAgeButtonGroup = new ButtonGroup();
        this.checkFileAgeButtonGroup.add((AbstractButton)this.checkFileAgeYesRadio);
        this.checkFileAgeButtonGroup.add((AbstractButton)this.checkFileAgeNoRadio);
        this.fileAgeLabel = new JLabel();
        this.fileAgeLabel.setText("File Age (ms):");
        this.fileAgeField = new MirthTextField();
        this.fileAgeField.setToolTipText("If Check File Age Yes is selected, only the files created that are older than the specified value in milliseconds will be processed.");
        this.fileSizeLabel = new JLabel();
        this.fileSizeLabel.setText("File Size (bytes):");
        this.fileSizeMinimumField = new MirthTextField();
        this.fileSizeMinimumField.setToolTipText("<html>The minimum size (in bytes) of files to be accepted.</html>");
        this.fileSizeDashLabel = new JLabel();
        this.fileSizeDashLabel.setText("-");
        this.fileSizeMaximumField = new MirthTextField();
        this.fileSizeMaximumField.setToolTipText("<html>The maximum size (in bytes) of files to be accepted.<br/>This option has no effect if Ignore Maximum is checked.</html>");
        this.ignoreFileSizeMaximumCheckBox = new MirthCheckBox();
        this.ignoreFileSizeMaximumCheckBox.setBackground(UIConstants.BACKGROUND_COLOR);
        this.ignoreFileSizeMaximumCheckBox.setText("Ignore Maximum");
        this.ignoreFileSizeMaximumCheckBox.setToolTipText("<html>If checked, only the minimum file size will be checked against incoming files.</html>");
        this.ignoreFileSizeMaximumCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.ignoreFileSizeMaximumCheckBoxActionPerformed(evt);
            }
        });
        this.sortFilesByLabel = new JLabel();
        this.sortFilesByLabel.setText("Sort Files By:");
        this.sortByComboBox = new MirthComboBox();
        this.sortByComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Date", "Name", "Size"}));
        this.sortByComboBox.setToolTipText("<html>Selects the order in which files should be processed, if there are multiple files available to be processed.<br>Files can be processed by Date (oldest last modification date first), Size (smallest first) or name (a before z, etc.).</html>");
        this.fileTypeLabel = new JLabel();
        this.fileTypeLabel.setText("File Type:");
        this.fileTypeBinary = new MirthRadioButton();
        this.fileTypeBinary.setBackground(UIConstants.BACKGROUND_COLOR);
        this.fileTypeBinary.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileTypeBinary.setText("Binary");
        this.fileTypeBinary.setToolTipText("<html>Select Binary if files contain binary data; the contents will be Base64 encoded before processing.<br>Select Text if files contain text data; the contents will be encoded using the specified character set encoding.</html>");
        this.fileTypeBinary.setMargin(new Insets(0, 0, 0, 0));
        this.fileTypeBinary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.fileTypeBinaryActionPerformed(evt);
            }
        });
        this.fileTypeText = new MirthRadioButton();
        this.fileTypeText.setBackground(UIConstants.BACKGROUND_COLOR);
        this.fileTypeText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileTypeText.setSelected(true);
        this.fileTypeText.setText("Text");
        this.fileTypeText.setToolTipText("<html>Select Binary if files contain binary data; the contents will be Base64 encoded before processing.<br>Select Text if files contain text data; the contents will be encoded using the specified character set encoding.</html>");
        this.fileTypeText.setMargin(new Insets(0, 0, 0, 0));
        this.fileTypeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileReader.this.fileTypeASCIIActionPerformed(evt);
            }
        });
        this.fileTypeButtonGroup = new ButtonGroup();
        this.fileTypeButtonGroup.add((AbstractButton)this.fileTypeBinary);
        this.fileTypeButtonGroup.add((AbstractButton)this.fileTypeText);
        this.encodingLabel = new JLabel();
        this.encodingLabel.setText("Encoding:");
        this.charsetEncodingComboBox = new MirthComboBox();
        this.charsetEncodingComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Default", "UTF-8", "ISO-8859-1", "UTF-16 (le)", "UTF-16 (be)", "UTF-16 (bom)", "US-ASCII"}));
        this.charsetEncodingComboBox.setToolTipText("If File Type Text is selected, select the character set encoding (ASCII, UTF-8, etc.) to be used in reading the contents of each file.");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 0, gapy 6", "[right,175]12[left]"));
        this.add(this.schemeLabel);
        this.add((Component)this.schemeComboBox, "split 3, spanx");
        this.add(this.testConnectionButton);
        this.add(this.advancedSettingsButton, "h 22!, w 22!");
        this.add(this.summaryLabel, "newline");
        this.add(this.summaryField, "growx, spanx");
        this.add(this.directoryLabel, "newline");
        this.add((Component)this.directoryField, "w 200!, spanx");
        this.add(this.hostLabel, "newline");
        this.add((Component)this.hostField, "w 200!, split 3, spanx");
        this.add(this.pathLabel, "gapleft 14");
        this.add((Component)this.pathField, "gapleft 14, w 200!");
        this.add(this.filenameFilterLabel, "newline");
        this.add((Component)this.fileNameFilterField, "w 200!, split 2, spanx");
        this.add((Component)this.filenameFilterRegexCheckBox, "gapleft 8");
        this.add(this.directoryRecursionLabel, "newline");
        this.add((Component)this.directoryRecursionYesRadio, "split 2, spanx");
        this.add((Component)this.directoryRecursionNoRadio);
        this.add(this.ignoreDotFilesLabel, "newline");
        this.add((Component)this.ignoreDotFilesYesRadio, "split 2, spanx");
        this.add((Component)this.ignoreDotFilesNoRadio);
        this.add(this.anonymousLabel, "newline");
        this.add((Component)this.anonymousYesRadio, "split 2, spanx");
        this.add((Component)this.anonymousNoRadio);
        this.add(this.usernameLabel, "newline");
        this.add((Component)this.usernameField, "w 125!, spanx");
        this.add(this.passwordLabel, "newline");
        this.add((Component)this.passwordField, "w 125!, spanx");
        this.add(this.timeoutLabel, "newline");
        this.add((Component)this.timeoutField, "w 75!, spanx");
        this.add(this.secureModeLabel, "newline");
        this.add((Component)this.secureModeYesRadio, "split 2, spanx");
        this.add((Component)this.secureModeNoRadio);
        this.add(this.passiveModeLabel, "newline");
        this.add((Component)this.passiveModeYesRadio, "split 2, spanx");
        this.add((Component)this.passiveModeNoRadio);
        this.add(this.validateConnectionLabel, "newline");
        this.add((Component)this.validateConnectionYesRadio, "split 2, spanx");
        this.add((Component)this.validateConnectionNoRadio);
        this.add(this.afterProcessingActionLabel, "newline");
        this.add((Component)this.afterProcessingActionComboBox, "w 55!, spanx");
        this.add(this.moveToDirectoryLabel, "newline");
        this.add((Component)this.moveToDirectoryField, "w 250!");
        this.add(this.variableListScrollPane, "spany 6, left, growy");
        this.add(this.moveToFileNameLabel, "newline");
        this.add((Component)this.moveToFileNameField, "w 250!");
        this.add(this.errorReadingActionLabel, "newline");
        this.add((Component)this.errorReadingActionComboBox, "w 55!");
        this.add(this.errorResponseActionLabel, "newline");
        this.add((Component)this.errorResponseActionComboBox, "w 140!");
        this.add(this.errorMoveToDirectoryLabel, "newline");
        this.add((Component)this.errorMoveToDirectoryField, "w 250!");
        this.add(this.errorMoveToFileNameLabel, "newline");
        this.add((Component)this.errorMoveToFileNameField, "w 250!");
        this.add(this.checkFileAgeLabel, "newline");
        this.add((Component)this.checkFileAgeYesRadio, "split 2, spanx");
        this.add((Component)this.checkFileAgeNoRadio);
        this.add(this.checkFileAgeLabel, "newline");
        this.add((Component)this.checkFileAgeYesRadio, "split 2, spanx");
        this.add((Component)this.checkFileAgeNoRadio);
        this.add(this.fileAgeLabel, "newline");
        this.add((Component)this.fileAgeField, "w 75!, spanx");
        this.add(this.fileSizeLabel, "newline");
        this.add((Component)this.fileSizeMinimumField, "w 75!, split 4, spanx");
        this.add(this.fileSizeDashLabel);
        this.add((Component)this.fileSizeMaximumField, "w 75!");
        this.add((Component)this.ignoreFileSizeMaximumCheckBox);
        this.add(this.sortFilesByLabel, "newline");
        this.add((Component)this.sortByComboBox, "w 75!, spanx");
        this.add(this.fileTypeLabel, "newline");
        this.add((Component)this.fileTypeBinary, "split 2, spanx");
        this.add((Component)this.fileTypeText);
        this.add(this.encodingLabel, "newline");
        this.add((Component)this.charsetEncodingComboBox, "w 125!, spanx");
    }

    private void anonymousNoActionPerformed(ActionEvent evt) {
        this.usernameLabel.setEnabled(true);
        this.usernameField.setEnabled(true);
        this.passwordLabel.setEnabled(true);
        this.passwordField.setEnabled(true);
        FileScheme scheme = (FileScheme)this.schemeComboBox.getSelectedItem();
        if (scheme == FileScheme.S3) {
            this.usernameField.setText("");
            this.passwordField.setText("");
        }
    }

    private void anonymousYesActionPerformed(ActionEvent evt) {
        this.usernameLabel.setEnabled(false);
        this.usernameField.setEnabled(false);
        this.passwordLabel.setEnabled(false);
        this.passwordField.setEnabled(false);
        FileScheme scheme = (FileScheme)this.schemeComboBox.getSelectedItem();
        if (scheme == FileScheme.S3) {
            this.usernameField.setText("");
            this.passwordField.setText("");
        } else {
            this.usernameField.setText("anonymous");
            this.passwordField.setText("anonymous");
        }
    }

    private void onSchemeChange(boolean enableHost, boolean anonymous, FileScheme scheme) {
        if (anonymous) {
            this.anonymousYesRadio.setSelected(true);
            this.anonymousYesActionPerformed(null);
        } else {
            this.anonymousNoRadio.setSelected(true);
            this.anonymousNoActionPerformed(null);
        }
        this.hostLabel.setEnabled(enableHost);
        this.hostField.setEnabled(enableHost);
        this.pathLabel.setEnabled(enableHost);
        this.pathField.setEnabled(enableHost);
        this.directoryLabel.setEnabled(!enableHost);
        this.directoryField.setEnabled(!enableHost);
        this.anonymousLabel.setEnabled(false);
        this.anonymousYesRadio.setEnabled(false);
        this.anonymousNoRadio.setEnabled(false);
        this.passiveModeLabel.setEnabled(false);
        this.passiveModeYesRadio.setEnabled(false);
        this.passiveModeNoRadio.setEnabled(false);
        this.validateConnectionLabel.setEnabled(false);
        this.validateConnectionYesRadio.setEnabled(false);
        this.validateConnectionNoRadio.setEnabled(false);
        this.secureModeLabel.setEnabled(false);
        this.secureModeYesRadio.setEnabled(false);
        this.secureModeNoRadio.setEnabled(false);
        this.timeoutLabel.setEnabled(false);
        this.timeoutField.setEnabled(false);
        this.advancedSettingsButton.setEnabled(false);
        this.advancedProperties = null;
        this.usernameLabel.setText("Username:");
        this.passwordLabel.setText("Password:");
        this.usernameField.setToolTipText("The user name used to gain access to the server.");
        this.passwordField.setToolTipText("The password used to gain access to the server.");
        this.moveToDirectoryLabel.setText("Move-to Directory:");
        this.errorMoveToDirectoryLabel.setText("Error Move-to Directory:");
        if (scheme == FileScheme.FTP) {
            this.anonymousLabel.setEnabled(true);
            this.anonymousYesRadio.setEnabled(true);
            this.anonymousNoRadio.setEnabled(true);
            this.passiveModeLabel.setEnabled(true);
            this.passiveModeYesRadio.setEnabled(true);
            this.passiveModeNoRadio.setEnabled(true);
            this.validateConnectionLabel.setEnabled(true);
            this.validateConnectionYesRadio.setEnabled(true);
            this.validateConnectionNoRadio.setEnabled(true);
            this.timeoutLabel.setEnabled(true);
            this.timeoutField.setEnabled(true);
            this.advancedSettingsButton.setEnabled(true);
            this.advancedProperties = new FTPSchemeProperties();
        } else if (scheme == FileScheme.SFTP) {
            this.timeoutLabel.setEnabled(true);
            this.timeoutField.setEnabled(true);
            this.advancedSettingsButton.setEnabled(true);
            this.advancedProperties = new SftpSchemeProperties();
        } else if (scheme == FileScheme.S3) {
            this.anonymousLabel.setEnabled(true);
            this.anonymousYesRadio.setEnabled(true);
            this.anonymousNoRadio.setEnabled(true);
            this.timeoutLabel.setEnabled(true);
            this.timeoutField.setEnabled(true);
            this.advancedSettingsButton.setEnabled(true);
            this.advancedProperties = new S3SchemeProperties();
            this.usernameLabel.setText("AWS Access Key ID:");
            this.usernameField.setToolTipText("The access key ID used to authenticate to AWS S3. This is optional when using the default credential provider chain.");
            this.passwordLabel.setText("AWS Secret Access Key:");
            this.passwordField.setToolTipText("The secret access key used to authenticate to AWS S3. This is optional when using the default credential provider chain.");
            this.moveToDirectoryLabel.setText("Move-to S3 Bucket / Directory:");
            this.errorMoveToDirectoryLabel.setText("Error Move-to S3 Bucket / Directory:");
        } else if (scheme == FileScheme.WEBDAV) {
            this.anonymousLabel.setEnabled(true);
            this.anonymousYesRadio.setEnabled(true);
            this.anonymousNoRadio.setEnabled(true);
            this.secureModeLabel.setEnabled(true);
            this.secureModeYesRadio.setEnabled(true);
            this.secureModeNoRadio.setEnabled(true);
            this.passiveModeNoRadio.setSelected(true);
        } else if (scheme == FileScheme.SMB) {
            this.timeoutLabel.setEnabled(true);
            this.timeoutField.setEnabled(true);
            this.advancedSettingsButton.setEnabled(true);
            this.advancedProperties = new SmbSchemeProperties();
        }
        this.setSummaryText();
    }

    private void advancedFileSettingsActionPerformed() {
        AdvancedSmbSettingsDialog dialog;
        if (this.selectedScheme == FileScheme.SFTP) {
            AdvancedSftpSettingsDialog dialog2 = new AdvancedSftpSettingsDialog((SftpSchemeProperties)this.advancedProperties);
            if (((AdvancedSettingsDialog)dialog2).wasSaved()) {
                this.advancedProperties = ((AdvancedSettingsDialog)dialog2).getSchemeProperties();
                this.setSummaryText();
            }
        } else if (this.selectedScheme == FileScheme.S3) {
            AdvancedS3SettingsDialog dialog3 = new AdvancedS3SettingsDialog((S3SchemeProperties)this.advancedProperties, this.anonymousYesRadio.isSelected());
            if (((AdvancedSettingsDialog)dialog3).wasSaved()) {
                this.advancedProperties = ((AdvancedSettingsDialog)dialog3).getSchemeProperties();
                this.setSummaryText();
            }
        } else if (this.selectedScheme == FileScheme.FTP) {
            AdvancedFTPSettingsDialog dialog4 = new AdvancedFTPSettingsDialog((FTPSchemeProperties)this.advancedProperties);
            if (((AdvancedSettingsDialog)dialog4).wasSaved()) {
                this.advancedProperties = ((AdvancedSettingsDialog)dialog4).getSchemeProperties();
                this.setSummaryText();
            }
        } else if (this.selectedScheme == FileScheme.SMB && ((AdvancedSettingsDialog)(dialog = new AdvancedSmbSettingsDialog((SmbSchemeProperties)this.advancedProperties))).wasSaved()) {
            this.advancedProperties = ((AdvancedSettingsDialog)dialog).getSchemeProperties();
            this.setSummaryText();
        }
    }

    private boolean isAdvancedDefault() {
        if (this.selectedScheme == FileScheme.SFTP) {
            return Objects.equals(this.advancedProperties, new SftpSchemeProperties());
        }
        if (this.selectedScheme == FileScheme.S3) {
            return Objects.equals(this.advancedProperties, new S3SchemeProperties());
        }
        if (this.selectedScheme == FileScheme.FTP) {
            return Objects.equals(this.advancedProperties, new FTPSchemeProperties());
        }
        if (this.selectedScheme == FileScheme.SMB) {
            return Objects.equals(this.advancedProperties, new SmbSchemeProperties());
        }
        return true;
    }

    private void schemeComboBoxActionPerformed(ActionEvent evt) {
        FileScheme scheme = (FileScheme)this.schemeComboBox.getSelectedItem();
        if (scheme != this.selectedScheme) {
            if (this.selectedScheme != null && !this.isAdvancedDefault() && JOptionPane.showConfirmDialog((Component)this.parent, "Are you sure you would like to change the scheme mode and lose all of the current properties?", "Select an Option", 0) != 0) {
                this.schemeComboBox.setSelectedItem((Object)this.selectedScheme);
                return;
            }
            if (scheme == FileScheme.FILE) {
                this.onSchemeChange(false, true, FileScheme.FILE);
                this.hostField.setText("");
            } else if (scheme == FileScheme.FTP) {
                this.onSchemeChange(true, this.anonymousYesRadio.isSelected(), FileScheme.FTP);
                this.hostLabel.setText("ftp://");
            } else if (scheme == FileScheme.SFTP) {
                this.onSchemeChange(true, false, FileScheme.SFTP);
                this.hostLabel.setText("sftp://");
            } else if (scheme == FileScheme.S3) {
                this.onSchemeChange(true, true, FileScheme.S3);
                this.hostLabel.setText("S3 Bucket:");
            } else if (scheme == FileScheme.SMB) {
                this.onSchemeChange(true, false, FileScheme.SMB);
                this.hostLabel.setText("smb://");
            } else if (scheme == FileScheme.WEBDAV) {
                this.onSchemeChange(true, this.anonymousYesRadio.isSelected(), FileScheme.WEBDAV);
                this.hostLabel.setText("https://");
            }
            this.decorateConnectorType();
        }
        this.selectedScheme = scheme;
    }

    private void fileTypeASCIIActionPerformed(ActionEvent evt) {
        this.encodingLabel.setEnabled(true);
        this.charsetEncodingComboBox.setEnabled(true);
    }

    private void fileTypeBinaryActionPerformed(ActionEvent evt) {
        this.encodingLabel.setEnabled(false);
        this.charsetEncodingComboBox.setEnabled(false);
        this.charsetEncodingComboBox.setSelectedIndex(0);
    }

    private void testConnectionActionPerformed(ActionEvent evt) {
        ResponseHandler handler = new ResponseHandler(){

            public void handle(Object response) {
                ConnectionTestResponse connectionTestResponse = (ConnectionTestResponse)response;
                if (connectionTestResponse == null) {
                    FileReader.this.parent.alertError((Component)FileReader.this.parent, "Failed to invoke service.");
                } else if (connectionTestResponse.getType().equals((Object)ConnectionTestResponse.Type.SUCCESS)) {
                    FileReader.this.parent.alertInformation((Component)FileReader.this.parent, connectionTestResponse.getMessage());
                } else {
                    FileReader.this.parent.alertWarning((Component)FileReader.this.parent, connectionTestResponse.getMessage());
                }
            }
        };
        try {
            ((FileConnectorServletInterface)this.getServlet(FileConnectorServletInterface.class, "Testing connection...", "Failed to invoke service: ", handler)).testRead(this.getChannelId(), this.getChannelName(), (FileReceiverProperties)this.getFilledProperties());
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    private void secureModeYesActionPerformed(ActionEvent evt) {
        this.hostLabel.setText("https://");
    }

    private void secureModeNoActionPerformed(ActionEvent evt) {
        this.hostLabel.setText("http://");
    }

    private void afterProcessingActionComboBoxActionPerformed(ActionEvent evt) {
        boolean enabled = (FileAction)this.afterProcessingActionComboBox.getSelectedItem() == FileAction.MOVE;
        this.moveToDirectoryLabel.setEnabled(enabled);
        this.moveToDirectoryField.setEnabled(enabled);
        this.moveToFileNameLabel.setEnabled(enabled);
        this.moveToFileNameField.setEnabled(enabled);
    }

    private void errorReadingActionComboBoxActionPerformed(ActionEvent evt) {
        this.updateErrorFields();
    }

    private void errorResponseActionComboBoxActionPerformed(ActionEvent evt) {
        this.updateErrorFields();
    }

    private void directoryRecursionYesRadioActionPerformed(ActionEvent evt) {
        if (!this.parent.alertOption((Component)this.parent, "<html>Including all subdirectories recursively is not recommended, especially if you are<br/>moving or deleting files.&nbsp;&nbsp;Are you sure you want to enable directory recursion?</html>")) {
            this.directoryRecursionNoRadio.setSelected(true);
        }
    }

    private void ignoreFileSizeMaximumCheckBoxActionPerformed(ActionEvent evt) {
        this.fileSizeDashLabel.setEnabled(!this.ignoreFileSizeMaximumCheckBox.isSelected());
        this.fileSizeMaximumField.setEnabled(!this.ignoreFileSizeMaximumCheckBox.isSelected());
    }

    private void updateErrorFields() {
        FileAction readAction = (FileAction)this.errorReadingActionComboBox.getSelectedItem();
        FileAction responseAction = (FileAction)this.errorResponseActionComboBox.getSelectedItem();
        boolean enabled = readAction == FileAction.MOVE || responseAction == FileAction.MOVE;
        this.errorMoveToDirectoryLabel.setEnabled(enabled);
        this.errorMoveToDirectoryField.setEnabled(enabled);
        this.errorMoveToFileNameLabel.setEnabled(enabled);
        this.errorMoveToFileNameField.setEnabled(enabled);
    }

    private void checkFileAgeNoActionPerformed(ActionEvent evt) {
        this.fileAgeLabel.setEnabled(false);
        this.fileAgeField.setEnabled(false);
    }

    private void checkFileAgeYesActionPerformed(ActionEvent evt) {
        this.fileAgeLabel.setEnabled(true);
        this.fileAgeField.setEnabled(true);
    }
}

