/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.tcp;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.ConnectorTypeDecoration;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthIconTextField;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthSyntaxTextArea;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.panels.connectors.ResponseHandler;
import com.mirth.connect.client.ui.util.PortUsageDialog;
import com.mirth.connect.connectors.tcp.TcpConnectorServletInterface;
import com.mirth.connect.connectors.tcp.TcpDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.transmission.TransmissionModeProperties;
import com.mirth.connect.plugins.BasicModeClientProvider;
import com.mirth.connect.plugins.TransmissionModeClientProvider;
import com.mirth.connect.plugins.TransmissionModePlugin;
import com.mirth.connect.util.ConnectionTestResponse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TcpSender
extends ConnectorSettingsPanel
implements ActionListener {
    private Logger logger = LogManager.getLogger(this.getClass());
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private TransmissionModeClientProvider defaultProvider;
    private TransmissionModeClientProvider transmissionModeProvider;
    private JComponent settingsPlaceHolder;
    private String selectedMode;
    private boolean modeLock = false;
    private JLabel modeLabel;
    public MirthRadioButton modeServerRadio;
    public MirthRadioButton modeClientRadio;
    private MirthTextField bufferSizeField;
    private MirthComboBox charsetEncodingCombobox;
    private ButtonGroup checkRemoteHostButtonGroup;
    private JLabel checkRemoteHostLabel;
    private MirthRadioButton checkRemoteHostNoRadio;
    private MirthRadioButton checkRemoteHostYesRadio;
    private MirthRadioButton dataTypeASCIIRadio;
    private MirthRadioButton dataTypeBinaryRadio;
    private ButtonGroup dataTypeButtonGroup;
    private JLabel dataTypeLabel;
    private JLabel charsetEncodingLabel;
    private MirthCheckBox ignoreResponseCheckBox;
    private JLabel bufferSizeLabel;
    private JLabel remotePortLabel;
    private JLabel remoteAddressLabel;
    private JLabel templateLabel;
    private ButtonGroup keepConnectionOpenGroup;
    private JLabel keepConnectionOpenLabel;
    private JLabel overrideLocalBindingLabel;
    private MirthRadioButton keepConnectionOpenNoRadio;
    private MirthRadioButton keepConnectionOpenYesRadio;
    private MirthIconTextField localAddressField;
    private JLabel localAddressLabel;
    private MirthTextField localPortField;
    private JLabel localPortLabel;
    private JLabel maxConnectionsLabel;
    private MirthTextField maxConnectionsField;
    private ButtonGroup overrideLocalBindingButtonGroup;
    private MirthRadioButton overrideLocalBindingNoRadio;
    private MirthRadioButton overrideLocalBindingYesRadio;
    private JButton portsInUse;
    private ButtonGroup queueOnResponseTimeoutButtonGroup;
    private JLabel queueOnResponseTimeoutLabel;
    private MirthRadioButton queueOnResponseTimeoutNoRadio;
    private MirthRadioButton queueOnResponseTimeoutYesRadio;
    private MirthIconTextField remoteAddressField;
    private MirthTextField remotePortField;
    private MirthTextField responseTimeoutField;
    private JLabel responseTimeoutLabel;
    private JLabel sampleLabel;
    private JLabel sampleValue;
    private MirthTextField sendTimeoutField;
    private JLabel sendTimeoutLabel;
    private MirthSyntaxTextArea templateTextArea;
    private JButton testConnection;
    private MirthComboBox transmissionModeComboBox;
    private JLabel transmissionModeLabel;

    public TcpSender() {
        this.initComponents();
        this.initLayout();
        this.sendTimeoutField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        this.bufferSizeField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        this.responseTimeoutField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("Basic TCP");
        this.selectedMode = "Basic TCP";
        for (String pluginPointName : LoadedExtensions.getInstance().getTransmissionModePlugins().keySet()) {
            model.addElement(pluginPointName);
            if (!pluginPointName.equals("MLLP")) continue;
            this.defaultProvider = ((TransmissionModePlugin)LoadedExtensions.getInstance().getTransmissionModePlugins().get(pluginPointName)).createProvider();
        }
        this.transmissionModeComboBox.setModel(model);
        this.parent.setupCharsetEncodingForConnector((JComboBox)this.charsetEncodingCombobox);
    }

    public String getConnectorName() {
        return new TcpDispatcherProperties().getName();
    }

    public ConnectorProperties getProperties() {
        TcpDispatcherProperties properties = new TcpDispatcherProperties();
        if (this.transmissionModeProvider != null) {
            properties.setTransmissionModeProperties(this.transmissionModeProvider.getProperties());
        }
        properties.setServerMode(this.modeServerRadio.isSelected());
        properties.setRemoteAddress(this.remoteAddressField.getText());
        properties.setRemotePort(this.remotePortField.getText());
        properties.setOverrideLocalBinding(this.overrideLocalBindingYesRadio.isSelected());
        properties.setLocalAddress(this.localAddressField.getText());
        properties.setLocalPort(this.localPortField.getText());
        properties.setMaxConnections(this.maxConnectionsField.getText());
        properties.setSendTimeout(this.sendTimeoutField.getText());
        properties.setBufferSize(this.bufferSizeField.getText());
        properties.setKeepConnectionOpen(this.keepConnectionOpenYesRadio.isSelected());
        properties.setCheckRemoteHost(this.checkRemoteHostYesRadio.isSelected());
        properties.setResponseTimeout(this.responseTimeoutField.getText());
        properties.setIgnoreResponse(this.ignoreResponseCheckBox.isSelected());
        properties.setQueueOnResponseTimeout(this.queueOnResponseTimeoutYesRadio.isSelected());
        properties.setDataTypeBinary(this.dataTypeBinaryRadio.isSelected());
        properties.setCharsetEncoding(this.parent.getSelectedEncodingForConnector((JComboBox)this.charsetEncodingCombobox));
        properties.setTemplate(this.templateTextArea.getText());
        this.logger.debug("getProperties: properties=" + String.valueOf(properties));
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        this.logger.debug("setProperties: properties=" + String.valueOf(properties));
        TcpDispatcherProperties props = (TcpDispatcherProperties)properties;
        TransmissionModeProperties modeProps = props.getTransmissionModeProperties();
        String name = "Basic TCP";
        if (modeProps != null && LoadedExtensions.getInstance().getTransmissionModePlugins().containsKey(modeProps.getPluginPointName())) {
            name = modeProps.getPluginPointName();
        }
        this.modeLock = true;
        this.transmissionModeComboBox.setSelectedItem((Object)name);
        this.transmissionModeComboBoxActionPerformed(null);
        this.modeLock = false;
        this.selectedMode = name;
        if (this.transmissionModeProvider != null) {
            this.transmissionModeProvider.setProperties(modeProps);
        }
        this.remoteAddressField.setText(props.getRemoteAddress());
        this.remotePortField.setText(props.getRemotePort());
        if (props.isOverrideLocalBinding()) {
            this.overrideLocalBindingYesRadio.setSelected(true);
            this.overrideLocalBindingYesRadioActionPerformed(null);
        } else {
            this.overrideLocalBindingNoRadio.setSelected(true);
            this.overrideLocalBindingNoRadioActionPerformed(null);
        }
        this.localAddressField.setText(props.getLocalAddress());
        this.localPortField.setText(props.getLocalPort());
        this.maxConnectionsField.setText(props.getMaxConnections());
        this.sendTimeoutField.setText(props.getSendTimeout());
        this.bufferSizeField.setText(props.getBufferSize());
        if (props.isKeepConnectionOpen()) {
            this.keepConnectionOpenYesRadio.setSelected(true);
            this.keepConnectionOpenYesRadioActionPerformed(null);
        } else {
            this.keepConnectionOpenNoRadio.setSelected(true);
            this.keepConnectionOpenNoRadioActionPerformed(null);
        }
        if (props.isServerMode()) {
            this.modeServerRadio.setSelected(true);
            this.modeServerRadioActionPerformed();
        } else {
            this.modeClientRadio.setSelected(true);
            this.modeClientRadioActionPerformed();
        }
        if (props.isCheckRemoteHost()) {
            this.checkRemoteHostYesRadio.setSelected(true);
        } else {
            this.checkRemoteHostNoRadio.setSelected(true);
        }
        this.responseTimeoutField.setText(String.valueOf(props.getResponseTimeout()));
        this.ignoreResponseCheckBox.setSelected(props.isIgnoreResponse());
        this.ignoreResponseCheckBoxActionPerformed(null);
        if (props.isQueueOnResponseTimeout()) {
            this.queueOnResponseTimeoutYesRadio.setSelected(true);
        } else {
            this.queueOnResponseTimeoutNoRadio.setSelected(true);
        }
        if (props.isDataTypeBinary()) {
            this.dataTypeBinaryRadio.setSelected(true);
            this.dataTypeBinaryRadioActionPerformed(null);
        } else {
            this.dataTypeASCIIRadio.setSelected(true);
            this.dataTypeASCIIRadioActionPerformed(null);
        }
        this.parent.setPreviousSelectedEncodingForConnector((JComboBox)this.charsetEncodingCombobox, props.getCharsetEncoding());
        this.templateTextArea.setText(props.getTemplate());
    }

    public ConnectorProperties getDefaults() {
        TcpDispatcherProperties props = new TcpDispatcherProperties();
        if (this.defaultProvider != null) {
            props.setTransmissionModeProperties(this.defaultProvider.getDefaultProperties());
        }
        return props;
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        this.logger.debug("checkProperties: properties=" + String.valueOf(properties));
        TcpDispatcherProperties props = (TcpDispatcherProperties)properties;
        boolean valid = true;
        if (this.transmissionModeProvider != null && !this.transmissionModeProvider.checkProperties(this.transmissionModeProvider.getProperties(), highlight)) {
            valid = false;
        }
        if (!props.isServerMode()) {
            if (props.getRemoteAddress().length() <= 3) {
                valid = false;
                if (highlight) {
                    this.remoteAddressField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
            if (props.getRemotePort().length() == 0) {
                valid = false;
                if (highlight) {
                    this.remotePortField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
        }
        if (props.isServerMode() || props.isOverrideLocalBinding()) {
            if (props.getLocalAddress().length() <= 3) {
                valid = false;
                if (highlight) {
                    this.localAddressField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
            if (props.getLocalPort().length() == 0) {
                valid = false;
                if (highlight) {
                    this.localPortField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
        }
        if (props.isServerMode() && (props.getMaxConnections().length() == 0 || NumberUtils.toInt((String)props.getMaxConnections()) <= 0)) {
            valid = false;
            if (highlight) {
                this.maxConnectionsField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (!props.isServerMode() && props.isKeepConnectionOpen() && props.getSendTimeout().length() == 0) {
            valid = false;
            if (highlight) {
                this.sendTimeoutField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getBufferSize().length() == 0) {
            valid = false;
            if (highlight) {
                this.bufferSizeField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getResponseTimeout().length() == 0) {
            valid = false;
            if (highlight) {
                this.responseTimeoutField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getTemplate().length() == 0) {
            valid = false;
            if (highlight) {
                this.templateTextArea.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        if (this.transmissionModeProvider != null) {
            this.transmissionModeProvider.resetInvalidProperties();
        }
        this.remoteAddressField.setBackground(null);
        this.remotePortField.setBackground(null);
        this.localAddressField.setBackground(null);
        this.localPortField.setBackground(null);
        this.decorateConnectorType();
        this.maxConnectionsField.setBackground(null);
        this.sendTimeoutField.setBackground(null);
        this.bufferSizeField.setBackground(null);
        this.responseTimeoutField.setBackground(null);
        this.templateTextArea.setBackground(null);
    }

    public ConnectorTypeDecoration getConnectorTypeDecoration() {
        return new ConnectorTypeDecoration(Connector.Mode.DESTINATION);
    }

    public void doLocalDecoration(ConnectorTypeDecoration connectorTypeDecoration) {
        if (connectorTypeDecoration != null) {
            if (this.modeServerRadio.isSelected()) {
                this.localAddressField.setIcon((Icon)connectorTypeDecoration.getIcon());
                this.localAddressField.setAlternateToolTipText(connectorTypeDecoration.getIconToolTipText());
                this.localAddressField.setIconPopupMenuComponent(connectorTypeDecoration.getIconPopupComponent());
                this.localAddressField.setBackground(connectorTypeDecoration.getHighlightColor());
                this.remoteAddressField.setIcon(null);
                this.remoteAddressField.setAlternateToolTipText(null);
                this.remoteAddressField.setIconPopupMenuComponent(null);
                this.remoteAddressField.setBackground(null);
            } else {
                this.localAddressField.setIcon(null);
                this.localAddressField.setAlternateToolTipText(null);
                this.localAddressField.setIconPopupMenuComponent(null);
                this.localAddressField.setBackground(null);
                this.remoteAddressField.setIcon((Icon)connectorTypeDecoration.getIcon());
                this.remoteAddressField.setAlternateToolTipText(connectorTypeDecoration.getIconToolTipText());
                this.remoteAddressField.setIconPopupMenuComponent(connectorTypeDecoration.getIconPopupComponent());
                this.remoteAddressField.setBackground(connectorTypeDecoration.getHighlightColor());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.transmissionModeProvider)) {
            if (evt.getActionCommand().equals("changesamplelabel")) {
                this.sampleLabel.setText(this.transmissionModeProvider.getSampleLabel());
            } else if (evt.getActionCommand().equals("changesamplevalue")) {
                this.sampleValue.setText(this.transmissionModeProvider.getSampleValue());
            }
        }
    }

    private void initComponents() {
        this.keepConnectionOpenGroup = new ButtonGroup();
        this.dataTypeButtonGroup = new ButtonGroup();
        this.overrideLocalBindingButtonGroup = new ButtonGroup();
        this.queueOnResponseTimeoutButtonGroup = new ButtonGroup();
        this.checkRemoteHostButtonGroup = new ButtonGroup();
        this.keepConnectionOpenLabel = new JLabel();
        this.bufferSizeLabel = new JLabel();
        this.sendTimeoutLabel = new JLabel();
        this.remotePortLabel = new JLabel();
        this.remoteAddressLabel = new JLabel();
        this.remotePortField = new MirthTextField();
        this.portsInUse = new JButton();
        this.sendTimeoutField = new MirthTextField();
        this.bufferSizeField = new MirthTextField();
        this.keepConnectionOpenYesRadio = new MirthRadioButton();
        this.keepConnectionOpenNoRadio = new MirthRadioButton();
        this.remoteAddressField = new MirthIconTextField();
        this.responseTimeoutField = new MirthTextField();
        this.responseTimeoutLabel = new JLabel();
        this.charsetEncodingCombobox = new MirthComboBox();
        this.charsetEncodingLabel = new JLabel();
        this.templateLabel = new JLabel();
        this.templateTextArea = new MirthSyntaxTextArea();
        this.ignoreResponseCheckBox = new MirthCheckBox();
        this.dataTypeASCIIRadio = new MirthRadioButton();
        this.dataTypeBinaryRadio = new MirthRadioButton();
        this.dataTypeLabel = new JLabel();
        this.testConnection = new JButton();
        this.transmissionModeComboBox = new MirthComboBox();
        this.transmissionModeLabel = new JLabel();
        this.sampleLabel = new JLabel();
        this.sampleValue = new JLabel();
        this.localAddressLabel = new JLabel();
        this.localAddressField = new MirthIconTextField();
        this.localPortLabel = new JLabel();
        this.localPortField = new MirthTextField();
        this.overrideLocalBindingLabel = new JLabel();
        this.overrideLocalBindingYesRadio = new MirthRadioButton();
        this.overrideLocalBindingNoRadio = new MirthRadioButton();
        this.settingsPlaceHolder = new JPanel();
        this.queueOnResponseTimeoutLabel = new JLabel();
        this.queueOnResponseTimeoutYesRadio = new MirthRadioButton();
        this.queueOnResponseTimeoutNoRadio = new MirthRadioButton();
        this.checkRemoteHostLabel = new JLabel();
        this.checkRemoteHostYesRadio = new MirthRadioButton();
        this.checkRemoteHostNoRadio = new MirthRadioButton();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.keepConnectionOpenLabel.setText("Keep Connection Open:");
        this.bufferSizeLabel.setText("Buffer Size (bytes):");
        this.sendTimeoutLabel.setText("Send Timeout (ms):");
        this.remotePortLabel.setText("Remote Port:");
        this.remoteAddressLabel.setText("Remote Address:");
        this.remotePortField.setToolTipText("<html>The port on which to connect.</html>");
        this.portsInUse.setText("Ports in Use");
        this.portsInUse.setToolTipText("View all ports currently used by BridgeLink.");
        this.portsInUse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpSender.this.portsInUseActionPerformed(evt);
            }
        });
        this.sendTimeoutField.setToolTipText("<html>The number of milliseconds to keep the connection<br/>to the host open, if Keep Connection Open is enabled.<br/>If zero, the connection will be kept open indefinitely.</html>");
        this.bufferSizeField.setToolTipText("<html>The size, in bytes, of the buffer to be used to hold messages waiting to be sent. Generally, the default value is fine.<html>");
        this.keepConnectionOpenYesRadio.setBackground(new Color(255, 255, 255));
        this.keepConnectionOpenYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.keepConnectionOpenGroup.add((AbstractButton)this.keepConnectionOpenYesRadio);
        this.keepConnectionOpenYesRadio.setText("Yes");
        this.keepConnectionOpenYesRadio.setToolTipText("<html>Select Yes to keep the connection to the host open across multiple messages.<br>Select No to immediately the close the connection to the host after sending each message.</html>");
        this.keepConnectionOpenYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.keepConnectionOpenYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpSender.this.keepConnectionOpenYesRadioActionPerformed(evt);
            }
        });
        this.keepConnectionOpenNoRadio.setBackground(new Color(255, 255, 255));
        this.keepConnectionOpenNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.keepConnectionOpenGroup.add((AbstractButton)this.keepConnectionOpenNoRadio);
        this.keepConnectionOpenNoRadio.setText("No");
        this.keepConnectionOpenNoRadio.setToolTipText("<html>Select Yes to keep the connection to the host open across multiple messages.<br>Select No to immediately the close the connection to the host after sending each message.</html>");
        this.keepConnectionOpenNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.keepConnectionOpenNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpSender.this.keepConnectionOpenNoRadioActionPerformed(evt);
            }
        });
        this.remoteAddressField.setToolTipText("<html>The DNS domain name or IP address on which to connect.</html>");
        this.responseTimeoutField.setToolTipText("<html>The number of milliseconds the connector should wait whenever attempting to read from the remote socket.</html>");
        this.responseTimeoutLabel.setText("Response Timeout (ms):");
        this.charsetEncodingCombobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Default", "UTF-8", "ISO-8859-1", "UTF-16 (le)", "UTF-16 (be)", "UTF-16 (bom)", "US-ASCII"}));
        this.charsetEncodingCombobox.setToolTipText("<html>The character set encoding to use when converting the outbound message to a byte stream if Data Type Text is selected.<br>Select Default to use the default character set encoding for the JVM running the BridgeLink server.</html>");
        this.charsetEncodingCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpSender.this.charsetEncodingComboboxActionPerformed(evt);
            }
        });
        this.charsetEncodingLabel.setText("Encoding:");
        this.templateLabel.setText("Template:");
        this.templateTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.ignoreResponseCheckBox.setBackground(new Color(255, 255, 255));
        this.ignoreResponseCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ignoreResponseCheckBox.setText("Ignore Response");
        this.ignoreResponseCheckBox.setToolTipText("<html>If checked, the connector will not wait for a response after sending a message.<br>If unchecked, the connector will wait for a response from the host after each message is sent.</html>");
        this.ignoreResponseCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.ignoreResponseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpSender.this.ignoreResponseCheckBoxActionPerformed(evt);
            }
        });
        this.dataTypeASCIIRadio.setBackground(new Color(255, 255, 255));
        this.dataTypeASCIIRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dataTypeButtonGroup.add((AbstractButton)this.dataTypeASCIIRadio);
        this.dataTypeASCIIRadio.setSelected(true);
        this.dataTypeASCIIRadio.setText("Text");
        this.dataTypeASCIIRadio.setToolTipText("<html>Select Binary if the outbound message is a Base64 string (will be decoded before it is sent out).<br/>Select Text if the outbound message is text (will be encoded with the specified character set encoding).</html>");
        this.dataTypeASCIIRadio.setMargin(new Insets(0, 0, 0, 0));
        this.dataTypeASCIIRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpSender.this.dataTypeASCIIRadioActionPerformed(evt);
            }
        });
        this.dataTypeBinaryRadio.setBackground(new Color(255, 255, 255));
        this.dataTypeBinaryRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dataTypeButtonGroup.add((AbstractButton)this.dataTypeBinaryRadio);
        this.dataTypeBinaryRadio.setText("Binary");
        this.dataTypeBinaryRadio.setToolTipText("<html>Select Binary if the outbound message is a Base64 string (will be decoded before it is sent out).<br/>Select Text if the outbound message is text (will be encoded with the specified character set encoding).</html>");
        this.dataTypeBinaryRadio.setMargin(new Insets(0, 0, 0, 0));
        this.dataTypeBinaryRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpSender.this.dataTypeBinaryRadioActionPerformed(evt);
            }
        });
        this.dataTypeLabel.setText("Data Type:");
        this.testConnection.setText("Test Connection");
        this.testConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpSender.this.testConnectionActionPerformed(evt);
            }
        });
        this.transmissionModeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"MLLP"}));
        this.transmissionModeComboBox.setToolTipText("<html>Select the transmission mode to use for sending and receiving data.<br/></html>");
        this.transmissionModeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpSender.this.transmissionModeComboBoxActionPerformed(evt);
            }
        });
        this.transmissionModeLabel.setText("Transmission Mode:");
        this.transmissionModeLabel.setToolTipText("<html>Select the transmission mode to use for sending and receiving data.<br/></html>");
        this.sampleLabel.setText("Sample Frame:");
        this.sampleValue.setForeground(new Color(153, 153, 153));
        this.sampleValue.setText("<html><b>&lt;VT&gt;</b> <i>&lt;Message Data&gt;</i> <b>&lt;FS&gt;&lt;CR&gt;</b></html>");
        this.sampleValue.setEnabled(false);
        this.localAddressLabel.setText("Local Address:");
        this.localAddressField.setToolTipText("<html>The local address that the client socket will be bound to, if Override Local Binding is set to Yes.<br/></html>");
        this.localPortLabel.setText("Local Port:");
        this.localPortField.setToolTipText("<html>The local port that the client socket will be bound to, if Override Local Binding is set to Yes.<br/><br/>Note that if a specific (non-zero) local port is chosen, then after a socket is closed it's up to the<br/>underlying OS to release the port before the next socket creation, otherwise the bind attempt will fail.<br/></html>");
        this.overrideLocalBindingLabel.setText("Override Local Binding:");
        this.overrideLocalBindingYesRadio.setBackground(new Color(255, 255, 255));
        this.overrideLocalBindingYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.overrideLocalBindingButtonGroup.add((AbstractButton)this.overrideLocalBindingYesRadio);
        this.overrideLocalBindingYesRadio.setText("Yes");
        this.overrideLocalBindingYesRadio.setToolTipText("<html>Select Yes to override the local address and port that the client socket will be bound to.<br/>Select No to use the default values of 0.0.0.0:0.<br/>A local port of zero (0) indicates that the OS should assign an ephemeral port automatically.<br/><br/>Note that if a specific (non-zero) local port is chosen, then after a socket is closed it's up to the<br/>underlying OS to release the port before the next socket creation, otherwise the bind attempt will fail.<br/></html>");
        this.overrideLocalBindingYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.overrideLocalBindingYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpSender.this.overrideLocalBindingYesRadioActionPerformed(evt);
            }
        });
        this.overrideLocalBindingNoRadio.setBackground(new Color(255, 255, 255));
        this.overrideLocalBindingNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.overrideLocalBindingButtonGroup.add((AbstractButton)this.overrideLocalBindingNoRadio);
        this.overrideLocalBindingNoRadio.setText("No");
        this.overrideLocalBindingNoRadio.setToolTipText("<html>Select Yes to override the local address and port that the client socket will be bound to.<br/>Select No to use the default values of 0.0.0.0:0.<br/>A local port of zero (0) indicates that the OS should assign an ephemeral port automatically.<br/><br/>Note that if a specific (non-zero) local port is chosen, then after a socket is closed it's up to the<br/>underlying OS to release the port before the next socket creation, otherwise the bind attempt will fail.<br/></html>");
        this.overrideLocalBindingNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.overrideLocalBindingNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpSender.this.overrideLocalBindingNoRadioActionPerformed(evt);
            }
        });
        this.queueOnResponseTimeoutLabel.setText("Queue on Response Timeout:");
        this.queueOnResponseTimeoutYesRadio.setBackground(new Color(255, 255, 255));
        this.queueOnResponseTimeoutYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.queueOnResponseTimeoutButtonGroup.add((AbstractButton)this.queueOnResponseTimeoutYesRadio);
        this.queueOnResponseTimeoutYesRadio.setText("Yes");
        this.queueOnResponseTimeoutYesRadio.setToolTipText("<html>If enabled, the message is queued when a timeout occurs while waiting for a response.<br/>Otherwise, the message is set to errored when a timeout occurs while waiting for a response.<br/>This setting has no effect unless queuing is enabled for the connector.</html>");
        this.queueOnResponseTimeoutYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.queueOnResponseTimeoutNoRadio.setBackground(new Color(255, 255, 255));
        this.queueOnResponseTimeoutNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.queueOnResponseTimeoutButtonGroup.add((AbstractButton)this.queueOnResponseTimeoutNoRadio);
        this.queueOnResponseTimeoutNoRadio.setText("No");
        this.queueOnResponseTimeoutNoRadio.setToolTipText("<html>If enabled, the message is queued when a timeout occurs while waiting for a response.<br/>Otherwise, the message is set to errored when a timeout occurs while waiting for a response.<br/>This setting has no effect unless queuing is enabled for the connector.</html>");
        this.queueOnResponseTimeoutNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.checkRemoteHostLabel.setText("Check Remote Host:");
        this.checkRemoteHostYesRadio.setBackground(new Color(255, 255, 255));
        this.checkRemoteHostYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkRemoteHostButtonGroup.add((AbstractButton)this.checkRemoteHostYesRadio);
        this.checkRemoteHostYesRadio.setText("Yes");
        this.checkRemoteHostYesRadio.setToolTipText("<html>Select Yes to check if the remote host has closed the connection before each message.<br>Select No to assume the remote host has not closed the connection.<br>Checking the remote host will decrease throughput but will prevent the message from<br>erroring if the remote side closed the connection and queueing is disabled.</html>");
        this.checkRemoteHostYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.checkRemoteHostNoRadio.setBackground(new Color(255, 255, 255));
        this.checkRemoteHostNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkRemoteHostButtonGroup.add((AbstractButton)this.checkRemoteHostNoRadio);
        this.checkRemoteHostNoRadio.setText("No");
        this.checkRemoteHostNoRadio.setToolTipText("<html>Select Yes to check if the remote host has closed the connection before each message.<br>Select No to assume the remote host has not closed the connection.<br>Checking the remote host will decrease throughput but will prevent the message from<br>erroring if the remote side closed the connection and queueing is disabled.</html>");
        this.checkRemoteHostNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.modeLabel = new JLabel("Mode:");
        ButtonGroup modeButtonGroup = new ButtonGroup();
        String toolTipText = "<html>Select Server to listen for connections from clients, or Client to connect to a TCP Server.</html>";
        this.modeServerRadio = new MirthRadioButton("Server");
        this.modeServerRadio.setToolTipText(toolTipText);
        this.modeServerRadio.setBackground(this.getBackground());
        this.modeServerRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpSender.this.modeServerRadioActionPerformed();
            }
        });
        modeButtonGroup.add((AbstractButton)this.modeServerRadio);
        this.modeClientRadio = new MirthRadioButton("Client");
        this.modeClientRadio.setToolTipText(toolTipText);
        this.modeClientRadio.setBackground(this.getBackground());
        this.modeClientRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpSender.this.modeClientRadioActionPerformed();
            }
        });
        modeButtonGroup.add((AbstractButton)this.modeClientRadio);
        this.maxConnectionsLabel = new JLabel("Max Connections:");
        this.maxConnectionsField = new MirthTextField();
        this.maxConnectionsField.setToolTipText("<html>The maximum number of client connections to accept.<br/>After this number has been reached, subsequent socket requests will result in a rejection.</html>");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, gap 12 6", "", "[][]4[]4[][]4[]4[][][][]4[]4[]4[]4[]4[][]"));
        this.add(this.transmissionModeLabel, "right");
        this.add((Component)this.transmissionModeComboBox, "h 22!, split 2");
        this.settingsPlaceHolder.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.add(this.settingsPlaceHolder, "gapbefore 6, h 22!");
        this.add(this.sampleLabel, "newline, right");
        this.add(this.sampleValue, "growx, sx");
        this.add(this.modeLabel, "newline, right");
        this.add((Component)this.modeClientRadio, "split 2");
        this.add((Component)this.modeServerRadio);
        this.add(this.remoteAddressLabel, "newline, right");
        this.add((Component)this.remoteAddressField, "w 200!, split 2, sx");
        this.add(this.testConnection, "gapleft 6");
        this.add(this.remotePortLabel, "newline, right");
        this.add((Component)this.remotePortField, "w 50!, sx");
        this.add(this.overrideLocalBindingLabel, "newline, right");
        this.add((Component)this.overrideLocalBindingYesRadio, "split 2");
        this.add((Component)this.overrideLocalBindingNoRadio);
        this.add(this.localAddressLabel, "newline, right");
        this.add((Component)this.localAddressField, "w 200!, sx");
        this.add(this.localPortLabel, "newline, right");
        this.add((Component)this.localPortField, "w 50!, split 2, sx");
        this.add(this.portsInUse, "gapleft 6");
        this.add(this.maxConnectionsLabel, "newline, right");
        this.add((Component)this.maxConnectionsField, "w 75!, sx");
        this.add(this.keepConnectionOpenLabel, "newline, right");
        this.add((Component)this.keepConnectionOpenYesRadio, "split 2");
        this.add((Component)this.keepConnectionOpenNoRadio);
        this.add(this.checkRemoteHostLabel, "newline, right");
        this.add((Component)this.checkRemoteHostYesRadio, "split 2");
        this.add((Component)this.checkRemoteHostNoRadio);
        this.add(this.sendTimeoutLabel, "newline, right");
        this.add((Component)this.sendTimeoutField, "w 75!, sx");
        this.add(this.bufferSizeLabel, "newline, right");
        this.add((Component)this.bufferSizeField, "w 75!, sx");
        this.add(this.responseTimeoutLabel, "newline, right");
        this.add((Component)this.responseTimeoutField, "w 75!, split 2, spanx");
        this.add((Component)this.ignoreResponseCheckBox, "gapleft 8");
        this.add(this.queueOnResponseTimeoutLabel, "newline, right");
        this.add((Component)this.queueOnResponseTimeoutYesRadio, "split 2");
        this.add((Component)this.queueOnResponseTimeoutNoRadio);
        this.add(this.dataTypeLabel, "newline, right");
        this.add((Component)this.dataTypeBinaryRadio, "split 2");
        this.add((Component)this.dataTypeASCIIRadio);
        this.add(this.charsetEncodingLabel, "newline, right");
        this.add((Component)this.charsetEncodingCombobox);
        this.add(this.templateLabel, "newline, aligny top, right");
        this.add((Component)this.templateTextArea, "w 425, h 105, grow, span, push");
    }

    private void dataTypeBinaryRadioActionPerformed(ActionEvent evt) {
        this.charsetEncodingLabel.setEnabled(false);
        this.charsetEncodingCombobox.setEnabled(false);
        this.charsetEncodingCombobox.setSelectedIndex(0);
    }

    private void dataTypeASCIIRadioActionPerformed(ActionEvent evt) {
        this.charsetEncodingLabel.setEnabled(true);
        this.charsetEncodingCombobox.setEnabled(true);
    }

    private void ignoreResponseCheckBoxActionPerformed(ActionEvent evt) {
        boolean selected = this.ignoreResponseCheckBox.isSelected();
        this.queueOnResponseTimeoutLabel.setEnabled(!selected);
        this.queueOnResponseTimeoutYesRadio.setEnabled(!selected);
        this.queueOnResponseTimeoutNoRadio.setEnabled(!selected);
    }

    private void testConnectionActionPerformed(ActionEvent evt) {
        ResponseHandler handler = new ResponseHandler(){

            public void handle(Object response) {
                ConnectionTestResponse connectionTestResponse = (ConnectionTestResponse)response;
                if (connectionTestResponse == null) {
                    TcpSender.this.parent.alertError((Component)TcpSender.this.parent, "Failed to invoke service.");
                } else if (connectionTestResponse.getType().equals((Object)ConnectionTestResponse.Type.SUCCESS)) {
                    TcpSender.this.parent.alertInformation((Component)TcpSender.this.parent, connectionTestResponse.getMessage());
                } else {
                    TcpSender.this.parent.alertWarning((Component)TcpSender.this.parent, connectionTestResponse.getMessage());
                }
            }
        };
        try {
            ((TcpConnectorServletInterface)this.getServlet(TcpConnectorServletInterface.class, "Testing connection...", "Failed to test connection: ", handler)).testConnection(this.getChannelId(), this.getChannelName(), (TcpDispatcherProperties)this.getFilledProperties());
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    private void updateKeepConnectionOpenUI() {
        if (this.keepConnectionOpenYesRadio.isSelected()) {
            this.keepConnectionOpenYesRadioActionPerformed(null);
        } else {
            this.keepConnectionOpenNoRadioActionPerformed(null);
        }
    }

    private void keepConnectionOpenYesRadioActionPerformed(ActionEvent evt) {
        this.sendTimeoutLabel.setEnabled(true);
        this.sendTimeoutField.setEnabled(true);
        this.checkRemoteHostLabel.setEnabled(true);
        this.checkRemoteHostYesRadio.setEnabled(true);
        this.checkRemoteHostNoRadio.setEnabled(true);
    }

    private void keepConnectionOpenNoRadioActionPerformed(ActionEvent evt) {
        this.sendTimeoutLabel.setEnabled(false);
        this.sendTimeoutField.setEnabled(false);
        this.checkRemoteHostLabel.setEnabled(false);
        this.checkRemoteHostYesRadio.setEnabled(false);
        this.checkRemoteHostNoRadio.setEnabled(false);
    }

    private void transmissionModeComboBoxActionPerformed(ActionEvent evt) {
        String name = (String)this.transmissionModeComboBox.getSelectedItem();
        if (!this.modeLock && this.transmissionModeProvider != null && !this.transmissionModeProvider.getDefaultProperties().equals((Object)this.transmissionModeProvider.getProperties()) && JOptionPane.showConfirmDialog((Component)this.parent, "Are you sure you would like to change the transmission mode and lose all of the current transmission properties?", "Select an Option", 0) != 0) {
            this.modeLock = true;
            this.transmissionModeComboBox.setSelectedItem((Object)this.selectedMode);
            this.modeLock = false;
            return;
        }
        this.selectedMode = name;
        if (name.equals("Basic TCP")) {
            this.transmissionModeProvider = new BasicModeClientProvider();
        } else {
            for (TransmissionModePlugin plugin : LoadedExtensions.getInstance().getTransmissionModePlugins().values()) {
                if (!plugin.getPluginPointName().equals(name)) continue;
                this.transmissionModeProvider = plugin.createProvider();
            }
        }
        if (this.transmissionModeProvider != null) {
            this.transmissionModeProvider.initialize((ActionListener)this);
            this.settingsPlaceHolder.removeAll();
            this.settingsPlaceHolder.add(this.transmissionModeProvider.getSettingsComponent());
        }
    }

    private void modeClientRadioActionPerformed() {
        this.remoteAddressLabel.setEnabled(true);
        this.remoteAddressField.setEnabled(true);
        this.remotePortLabel.setEnabled(true);
        this.remotePortField.setEnabled(true);
        this.testConnection.setEnabled(true);
        this.overrideLocalBindingLabel.setEnabled(true);
        this.overrideLocalBindingYesRadio.setEnabled(true);
        this.overrideLocalBindingNoRadio.setEnabled(true);
        this.keepConnectionOpenLabel.setEnabled(true);
        this.keepConnectionOpenYesRadio.setEnabled(true);
        this.keepConnectionOpenNoRadio.setEnabled(true);
        this.updateOverrideLocalBindingUI();
        this.updateKeepConnectionOpenUI();
        this.maxConnectionsLabel.setEnabled(false);
        this.maxConnectionsField.setEnabled(false);
    }

    private void modeServerRadioActionPerformed() {
        this.remoteAddressLabel.setEnabled(false);
        this.remoteAddressField.setEnabled(false);
        this.remotePortLabel.setEnabled(false);
        this.remotePortField.setEnabled(false);
        this.testConnection.setEnabled(false);
        this.overrideLocalBindingLabel.setEnabled(false);
        this.overrideLocalBindingYesRadio.setEnabled(false);
        this.overrideLocalBindingNoRadio.setEnabled(false);
        this.keepConnectionOpenLabel.setEnabled(false);
        this.keepConnectionOpenYesRadio.setEnabled(false);
        this.keepConnectionOpenNoRadio.setEnabled(false);
        this.checkRemoteHostLabel.setEnabled(false);
        this.checkRemoteHostYesRadio.setEnabled(false);
        this.checkRemoteHostNoRadio.setEnabled(false);
        this.sendTimeoutLabel.setEnabled(false);
        this.sendTimeoutField.setEnabled(false);
        this.localAddressLabel.setEnabled(true);
        this.localAddressField.setEnabled(true);
        this.localPortLabel.setEnabled(true);
        this.localPortField.setEnabled(true);
        this.portsInUse.setEnabled(true);
        this.maxConnectionsLabel.setEnabled(true);
        this.maxConnectionsField.setEnabled(true);
    }

    private void updateOverrideLocalBindingUI() {
        if (this.overrideLocalBindingYesRadio.isSelected()) {
            this.overrideLocalBindingYesRadioActionPerformed(null);
        } else {
            this.overrideLocalBindingNoRadioActionPerformed(null);
        }
    }

    private void overrideLocalBindingYesRadioActionPerformed(ActionEvent evt) {
        this.localAddressField.setEnabled(true);
        this.localAddressLabel.setEnabled(true);
        this.localPortField.setEnabled(true);
        this.localPortLabel.setEnabled(true);
        this.portsInUse.setEnabled(true);
    }

    private void overrideLocalBindingNoRadioActionPerformed(ActionEvent evt) {
        this.localAddressField.setEnabled(false);
        this.localAddressLabel.setEnabled(false);
        this.localPortField.setEnabled(false);
        this.localPortLabel.setEnabled(false);
        this.portsInUse.setEnabled(false);
    }

    private void charsetEncodingComboboxActionPerformed(ActionEvent evt) {
    }

    private void portsInUseActionPerformed(ActionEvent evt) {
        PortUsageDialog dialog = new PortUsageDialog((Window)this.parent);
    }
}

