/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.util;

import com.mirth.connect.donkey.model.message.InvalidMapValue;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MapUtil {
    private static Logger logger = LogManager.getLogger(MapUtil.class);

    public static String serializeMap(Serializer serializer, Map<String, Object> map) {
        if (MapUtil.hasInvalidValues(map)) {
            try {
                DonkeyElement mapElement = new DonkeyElement("<map/>");
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    DonkeyElement entryElement = mapElement.addChildElement("entry");
                    entryElement.addChildElement("string", entry.getKey());
                    String valueXML = "";
                    if (entry.getValue() instanceof InvalidMapValue) {
                        valueXML = ((InvalidMapValue)entry.getValue()).getValueXML();
                    } else {
                        try {
                            valueXML = serializer.serialize(entry.getValue());
                        }
                        catch (Exception e) {
                            logger.warn("Non-serializable value found in map, converting value to string with key: " + entry.getKey());
                            valueXML = String.valueOf(entry.getValue() == null ? "" : entry.getValue().toString());
                        }
                    }
                    entryElement.addChildElementFromXml(valueXML);
                }
                return mapElement.toXml();
            }
            catch (DonkeyElement.DonkeyElementException e) {
                throw new SerializerException(e);
            }
        }
        try {
            return serializer.serialize(map);
        }
        catch (Exception e) {
            TreeMap<String, Object> newMap = new TreeMap<String, Object>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object value = entry.getValue();
                try {
                    serializer.serialize(value);
                    newMap.put(entry.getKey(), value);
                }
                catch (Exception e2) {
                    logger.warn("Non-serializable value found in map, converting value to string with key: " + entry.getKey());
                    newMap.put(entry.getKey(), value == null ? "" : value.toString());
                }
            }
            return serializer.serialize(newMap);
        }
    }

    public static boolean hasInvalidValues(Map<String, Object> map) {
        for (Object mapValue : map.values()) {
            if (!(mapValue instanceof InvalidMapValue)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> deserializeMap(Serializer serializer, String serializedMap) {
        try {
            return serializer.deserialize(serializedMap, Map.class);
        }
        catch (Exception e) {
            try {
                return MapUtil.deserializeMapWithInvalidValues(serializer, new DonkeyElement(serializedMap));
            }
            catch (DonkeyElement.DonkeyElementException e2) {
                throw new SerializerException(e2);
            }
        }
    }

    public static Map<String, Object> deserializeMapWithInvalidValues(Serializer serializer, DonkeyElement mapElement) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (DonkeyElement entry : mapElement.getChildElements()) {
            if (!entry.getNodeName().equalsIgnoreCase("entry")) {
                map.putAll(MapUtil.deserializeMapWithInvalidValues(serializer, entry));
                continue;
            }
            if (entry.getChildElements().size() <= 1) continue;
            String key = entry.getChildElements().get(0).getTextContent();
            String valueXML = "";
            Object value = null;
            try {
                valueXML = entry.getChildElements().get(1).toXml();
                value = serializer.deserialize(valueXML, Object.class);
            }
            catch (Exception e2) {
                value = new InvalidMapValue(valueXML);
            }
            map.put(key, value);
        }
        return map;
    }
}

