/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.PEX_P07_TIMING_QTY;
import ca.uhn.hl7v2.model.v27.segment.PRT;
import ca.uhn.hl7v2.model.v27.segment.RXE;
import ca.uhn.hl7v2.model.v27.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PEX_P07_RX_ORDER
extends AbstractGroup {
    public PEX_P07_RX_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RXE.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(PEX_P07_TIMING_QTY.class, true, true, false);
            this.add(RXR.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PEX_P07_RX_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public RXE getRXE() {
        RXE retVal = (RXE)this.getTyped("RXE", RXE.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public PEX_P07_TIMING_QTY getTIMING_QTY() {
        PEX_P07_TIMING_QTY retVal = (PEX_P07_TIMING_QTY)this.getTyped("TIMING_QTY", PEX_P07_TIMING_QTY.class);
        return retVal;
    }

    public PEX_P07_TIMING_QTY getTIMING_QTY(int rep) {
        PEX_P07_TIMING_QTY retVal = (PEX_P07_TIMING_QTY)this.getTyped("TIMING_QTY", rep, PEX_P07_TIMING_QTY.class);
        return retVal;
    }

    public int getTIMING_QTYReps() {
        return this.getReps("TIMING_QTY");
    }

    public List<PEX_P07_TIMING_QTY> getTIMING_QTYAll() throws HL7Exception {
        return this.getAllAsList("TIMING_QTY", PEX_P07_TIMING_QTY.class);
    }

    public void insertTIMING_QTY(PEX_P07_TIMING_QTY structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_QTY", (Structure)structure, rep);
    }

    public PEX_P07_TIMING_QTY insertTIMING_QTY(int rep) throws HL7Exception {
        return (PEX_P07_TIMING_QTY)super.insertRepetition("TIMING_QTY", rep);
    }

    public PEX_P07_TIMING_QTY removeTIMING_QTY(int rep) throws HL7Exception {
        return (PEX_P07_TIMING_QTY)super.removeRepetition("TIMING_QTY", rep);
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public RXR getRXR(int rep) {
        RXR retVal = (RXR)this.getTyped("RXR", rep, RXR.class);
        return retVal;
    }

    public int getRXRReps() {
        return this.getReps("RXR");
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", (Structure)structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }
}

