/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CQ;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.CX;
import ca.uhn.hl7v2.model.v27.datatype.DR;
import ca.uhn.hl7v2.model.v27.datatype.DTM;
import ca.uhn.hl7v2.model.v27.datatype.EI;
import ca.uhn.hl7v2.model.v27.datatype.EIP;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.NM;
import ca.uhn.hl7v2.model.v27.datatype.SI;
import ca.uhn.hl7v2.model.v27.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class SPM
extends AbstractSegment {
    public SPM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - SPM");
            this.add(EIP.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen ID");
            this.add(EIP.class, false, 0, 0, new Object[]{this.getMessage()}, "Specimen Parent IDs");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Specimen Type");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Specimen Type Modifier");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Specimen Additives");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Collection Method");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Source Site");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Specimen Source Site Modifier");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Collection Site");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Specimen Role");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Collection Amount");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Grouped Specimen Count");
            this.add(ST.class, false, 0, 0, new Object[]{this.getMessage()}, "Specimen Description");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Specimen Handling Code");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Specimen Risk Code");
            this.add(DR.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Collection Date/Time");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Received Date/Time");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Expiration Date/Time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Specimen Availability");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Specimen Reject Reason");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Quality");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Appropriateness");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Specimen Condition");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Current Quantity");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Number of Specimen Containers");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Container Type");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Container Condition");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Child Role");
            this.add(CX.class, false, 0, 0, new Object[]{this.getMessage()}, "Accession ID");
            this.add(CX.class, false, 0, 0, new Object[]{this.getMessage()}, "Other Specimen ID");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Shipment ID");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SPM - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDSPM() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getSpm1_SetIDSPM() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public EIP getSpecimenID() {
        EIP retVal = (EIP)this.getTypedField(2, 0);
        return retVal;
    }

    public EIP getSpm2_SpecimenID() {
        EIP retVal = (EIP)this.getTypedField(2, 0);
        return retVal;
    }

    public EIP[] getSpecimenParentIDs() {
        EIP[] retVal = (EIP[])this.getTypedField(3, (Type[])new EIP[0]);
        return retVal;
    }

    public EIP[] getSpm3_SpecimenParentIDs() {
        EIP[] retVal = (EIP[])this.getTypedField(3, (Type[])new EIP[0]);
        return retVal;
    }

    public int getSpecimenParentIDsReps() {
        return this.getReps(3);
    }

    public EIP getSpecimenParentIDs(int rep) {
        EIP retVal = (EIP)this.getTypedField(3, rep);
        return retVal;
    }

    public EIP getSpm3_SpecimenParentIDs(int rep) {
        EIP retVal = (EIP)this.getTypedField(3, rep);
        return retVal;
    }

    public int getSpm3_SpecimenParentIDsReps() {
        return this.getReps(3);
    }

    public EIP insertSpecimenParentIDs(int rep) throws HL7Exception {
        return (EIP)super.insertRepetition(3, rep);
    }

    public EIP insertSpm3_SpecimenParentIDs(int rep) throws HL7Exception {
        return (EIP)super.insertRepetition(3, rep);
    }

    public EIP removeSpecimenParentIDs(int rep) throws HL7Exception {
        return (EIP)super.removeRepetition(3, rep);
    }

    public EIP removeSpm3_SpecimenParentIDs(int rep) throws HL7Exception {
        return (EIP)super.removeRepetition(3, rep);
    }

    public CWE getSpecimenType() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getSpm4_SpecimenType() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE[] getSpecimenTypeModifier() {
        CWE[] retVal = (CWE[])this.getTypedField(5, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getSpm5_SpecimenTypeModifier() {
        CWE[] retVal = (CWE[])this.getTypedField(5, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSpecimenTypeModifierReps() {
        return this.getReps(5);
    }

    public CWE getSpecimenTypeModifier(int rep) {
        CWE retVal = (CWE)this.getTypedField(5, rep);
        return retVal;
    }

    public CWE getSpm5_SpecimenTypeModifier(int rep) {
        CWE retVal = (CWE)this.getTypedField(5, rep);
        return retVal;
    }

    public int getSpm5_SpecimenTypeModifierReps() {
        return this.getReps(5);
    }

    public CWE insertSpecimenTypeModifier(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(5, rep);
    }

    public CWE insertSpm5_SpecimenTypeModifier(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(5, rep);
    }

    public CWE removeSpecimenTypeModifier(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(5, rep);
    }

    public CWE removeSpm5_SpecimenTypeModifier(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(5, rep);
    }

    public CWE[] getSpecimenAdditives() {
        CWE[] retVal = (CWE[])this.getTypedField(6, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getSpm6_SpecimenAdditives() {
        CWE[] retVal = (CWE[])this.getTypedField(6, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSpecimenAdditivesReps() {
        return this.getReps(6);
    }

    public CWE getSpecimenAdditives(int rep) {
        CWE retVal = (CWE)this.getTypedField(6, rep);
        return retVal;
    }

    public CWE getSpm6_SpecimenAdditives(int rep) {
        CWE retVal = (CWE)this.getTypedField(6, rep);
        return retVal;
    }

    public int getSpm6_SpecimenAdditivesReps() {
        return this.getReps(6);
    }

    public CWE insertSpecimenAdditives(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(6, rep);
    }

    public CWE insertSpm6_SpecimenAdditives(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(6, rep);
    }

    public CWE removeSpecimenAdditives(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(6, rep);
    }

    public CWE removeSpm6_SpecimenAdditives(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(6, rep);
    }

    public CWE getSpecimenCollectionMethod() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getSpm7_SpecimenCollectionMethod() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getSpecimenSourceSite() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getSpm8_SpecimenSourceSite() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE[] getSpecimenSourceSiteModifier() {
        CWE[] retVal = (CWE[])this.getTypedField(9, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getSpm9_SpecimenSourceSiteModifier() {
        CWE[] retVal = (CWE[])this.getTypedField(9, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSpecimenSourceSiteModifierReps() {
        return this.getReps(9);
    }

    public CWE getSpecimenSourceSiteModifier(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public CWE getSpm9_SpecimenSourceSiteModifier(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getSpm9_SpecimenSourceSiteModifierReps() {
        return this.getReps(9);
    }

    public CWE insertSpecimenSourceSiteModifier(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE insertSpm9_SpecimenSourceSiteModifier(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE removeSpecimenSourceSiteModifier(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public CWE removeSpm9_SpecimenSourceSiteModifier(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public CWE getSpecimenCollectionSite() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getSpm10_SpecimenCollectionSite() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE[] getSpecimenRole() {
        CWE[] retVal = (CWE[])this.getTypedField(11, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getSpm11_SpecimenRole() {
        CWE[] retVal = (CWE[])this.getTypedField(11, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSpecimenRoleReps() {
        return this.getReps(11);
    }

    public CWE getSpecimenRole(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public CWE getSpm11_SpecimenRole(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public int getSpm11_SpecimenRoleReps() {
        return this.getReps(11);
    }

    public CWE insertSpecimenRole(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE insertSpm11_SpecimenRole(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE removeSpecimenRole(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public CWE removeSpm11_SpecimenRole(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public CQ getSpecimenCollectionAmount() {
        CQ retVal = (CQ)this.getTypedField(12, 0);
        return retVal;
    }

    public CQ getSpm12_SpecimenCollectionAmount() {
        CQ retVal = (CQ)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getGroupedSpecimenCount() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getSpm13_GroupedSpecimenCount() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public ST[] getSpecimenDescription() {
        ST[] retVal = (ST[])this.getTypedField(14, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getSpm14_SpecimenDescription() {
        ST[] retVal = (ST[])this.getTypedField(14, (Type[])new ST[0]);
        return retVal;
    }

    public int getSpecimenDescriptionReps() {
        return this.getReps(14);
    }

    public ST getSpecimenDescription(int rep) {
        ST retVal = (ST)this.getTypedField(14, rep);
        return retVal;
    }

    public ST getSpm14_SpecimenDescription(int rep) {
        ST retVal = (ST)this.getTypedField(14, rep);
        return retVal;
    }

    public int getSpm14_SpecimenDescriptionReps() {
        return this.getReps(14);
    }

    public ST insertSpecimenDescription(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(14, rep);
    }

    public ST insertSpm14_SpecimenDescription(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(14, rep);
    }

    public ST removeSpecimenDescription(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(14, rep);
    }

    public ST removeSpm14_SpecimenDescription(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(14, rep);
    }

    public CWE[] getSpecimenHandlingCode() {
        CWE[] retVal = (CWE[])this.getTypedField(15, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getSpm15_SpecimenHandlingCode() {
        CWE[] retVal = (CWE[])this.getTypedField(15, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSpecimenHandlingCodeReps() {
        return this.getReps(15);
    }

    public CWE getSpecimenHandlingCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(15, rep);
        return retVal;
    }

    public CWE getSpm15_SpecimenHandlingCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(15, rep);
        return retVal;
    }

    public int getSpm15_SpecimenHandlingCodeReps() {
        return this.getReps(15);
    }

    public CWE insertSpecimenHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE insertSpm15_SpecimenHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE removeSpecimenHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public CWE removeSpm15_SpecimenHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public CWE[] getSpecimenRiskCode() {
        CWE[] retVal = (CWE[])this.getTypedField(16, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getSpm16_SpecimenRiskCode() {
        CWE[] retVal = (CWE[])this.getTypedField(16, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSpecimenRiskCodeReps() {
        return this.getReps(16);
    }

    public CWE getSpecimenRiskCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(16, rep);
        return retVal;
    }

    public CWE getSpm16_SpecimenRiskCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(16, rep);
        return retVal;
    }

    public int getSpm16_SpecimenRiskCodeReps() {
        return this.getReps(16);
    }

    public CWE insertSpecimenRiskCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(16, rep);
    }

    public CWE insertSpm16_SpecimenRiskCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(16, rep);
    }

    public CWE removeSpecimenRiskCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(16, rep);
    }

    public CWE removeSpm16_SpecimenRiskCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(16, rep);
    }

    public DR getSpecimenCollectionDateTime() {
        DR retVal = (DR)this.getTypedField(17, 0);
        return retVal;
    }

    public DR getSpm17_SpecimenCollectionDateTime() {
        DR retVal = (DR)this.getTypedField(17, 0);
        return retVal;
    }

    public DTM getSpecimenReceivedDateTime() {
        DTM retVal = (DTM)this.getTypedField(18, 0);
        return retVal;
    }

    public DTM getSpm18_SpecimenReceivedDateTime() {
        DTM retVal = (DTM)this.getTypedField(18, 0);
        return retVal;
    }

    public DTM getSpecimenExpirationDateTime() {
        DTM retVal = (DTM)this.getTypedField(19, 0);
        return retVal;
    }

    public DTM getSpm19_SpecimenExpirationDateTime() {
        DTM retVal = (DTM)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getSpecimenAvailability() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getSpm20_SpecimenAvailability() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE[] getSpecimenRejectReason() {
        CWE[] retVal = (CWE[])this.getTypedField(21, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getSpm21_SpecimenRejectReason() {
        CWE[] retVal = (CWE[])this.getTypedField(21, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSpecimenRejectReasonReps() {
        return this.getReps(21);
    }

    public CWE getSpecimenRejectReason(int rep) {
        CWE retVal = (CWE)this.getTypedField(21, rep);
        return retVal;
    }

    public CWE getSpm21_SpecimenRejectReason(int rep) {
        CWE retVal = (CWE)this.getTypedField(21, rep);
        return retVal;
    }

    public int getSpm21_SpecimenRejectReasonReps() {
        return this.getReps(21);
    }

    public CWE insertSpecimenRejectReason(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(21, rep);
    }

    public CWE insertSpm21_SpecimenRejectReason(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(21, rep);
    }

    public CWE removeSpecimenRejectReason(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(21, rep);
    }

    public CWE removeSpm21_SpecimenRejectReason(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(21, rep);
    }

    public CWE getSpecimenQuality() {
        CWE retVal = (CWE)this.getTypedField(22, 0);
        return retVal;
    }

    public CWE getSpm22_SpecimenQuality() {
        CWE retVal = (CWE)this.getTypedField(22, 0);
        return retVal;
    }

    public CWE getSpecimenAppropriateness() {
        CWE retVal = (CWE)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE getSpm23_SpecimenAppropriateness() {
        CWE retVal = (CWE)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE[] getSpecimenCondition() {
        CWE[] retVal = (CWE[])this.getTypedField(24, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getSpm24_SpecimenCondition() {
        CWE[] retVal = (CWE[])this.getTypedField(24, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSpecimenConditionReps() {
        return this.getReps(24);
    }

    public CWE getSpecimenCondition(int rep) {
        CWE retVal = (CWE)this.getTypedField(24, rep);
        return retVal;
    }

    public CWE getSpm24_SpecimenCondition(int rep) {
        CWE retVal = (CWE)this.getTypedField(24, rep);
        return retVal;
    }

    public int getSpm24_SpecimenConditionReps() {
        return this.getReps(24);
    }

    public CWE insertSpecimenCondition(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(24, rep);
    }

    public CWE insertSpm24_SpecimenCondition(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(24, rep);
    }

    public CWE removeSpecimenCondition(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(24, rep);
    }

    public CWE removeSpm24_SpecimenCondition(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(24, rep);
    }

    public CQ getSpecimenCurrentQuantity() {
        CQ retVal = (CQ)this.getTypedField(25, 0);
        return retVal;
    }

    public CQ getSpm25_SpecimenCurrentQuantity() {
        CQ retVal = (CQ)this.getTypedField(25, 0);
        return retVal;
    }

    public NM getNumberOfSpecimenContainers() {
        NM retVal = (NM)this.getTypedField(26, 0);
        return retVal;
    }

    public NM getSpm26_NumberOfSpecimenContainers() {
        NM retVal = (NM)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getContainerType() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE getSpm27_ContainerType() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE getContainerCondition() {
        CWE retVal = (CWE)this.getTypedField(28, 0);
        return retVal;
    }

    public CWE getSpm28_ContainerCondition() {
        CWE retVal = (CWE)this.getTypedField(28, 0);
        return retVal;
    }

    public CWE getSpecimenChildRole() {
        CWE retVal = (CWE)this.getTypedField(29, 0);
        return retVal;
    }

    public CWE getSpm29_SpecimenChildRole() {
        CWE retVal = (CWE)this.getTypedField(29, 0);
        return retVal;
    }

    public CX[] getAccessionID() {
        CX[] retVal = (CX[])this.getTypedField(30, (Type[])new CX[0]);
        return retVal;
    }

    public CX[] getSpm30_AccessionID() {
        CX[] retVal = (CX[])this.getTypedField(30, (Type[])new CX[0]);
        return retVal;
    }

    public int getAccessionIDReps() {
        return this.getReps(30);
    }

    public CX getAccessionID(int rep) {
        CX retVal = (CX)this.getTypedField(30, rep);
        return retVal;
    }

    public CX getSpm30_AccessionID(int rep) {
        CX retVal = (CX)this.getTypedField(30, rep);
        return retVal;
    }

    public int getSpm30_AccessionIDReps() {
        return this.getReps(30);
    }

    public CX insertAccessionID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(30, rep);
    }

    public CX insertSpm30_AccessionID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(30, rep);
    }

    public CX removeAccessionID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(30, rep);
    }

    public CX removeSpm30_AccessionID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(30, rep);
    }

    public CX[] getOtherSpecimenID() {
        CX[] retVal = (CX[])this.getTypedField(31, (Type[])new CX[0]);
        return retVal;
    }

    public CX[] getSpm31_OtherSpecimenID() {
        CX[] retVal = (CX[])this.getTypedField(31, (Type[])new CX[0]);
        return retVal;
    }

    public int getOtherSpecimenIDReps() {
        return this.getReps(31);
    }

    public CX getOtherSpecimenID(int rep) {
        CX retVal = (CX)this.getTypedField(31, rep);
        return retVal;
    }

    public CX getSpm31_OtherSpecimenID(int rep) {
        CX retVal = (CX)this.getTypedField(31, rep);
        return retVal;
    }

    public int getSpm31_OtherSpecimenIDReps() {
        return this.getReps(31);
    }

    public CX insertOtherSpecimenID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(31, rep);
    }

    public CX insertSpm31_OtherSpecimenID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(31, rep);
    }

    public CX removeOtherSpecimenID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(31, rep);
    }

    public CX removeSpm31_OtherSpecimenID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(31, rep);
    }

    public EI getShipmentID() {
        EI retVal = (EI)this.getTypedField(32, 0);
        return retVal;
    }

    public EI getSpm32_ShipmentID() {
        EI retVal = (EI)this.getTypedField(32, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new EIP(this.getMessage());
            }
            case 2: {
                return new EIP(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new CQ(this.getMessage());
            }
            case 12: {
                return new NM(this.getMessage());
            }
            case 13: {
                return new ST(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new DR(this.getMessage());
            }
            case 17: {
                return new DTM(this.getMessage());
            }
            case 18: {
                return new DTM(this.getMessage());
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 20: {
                return new CWE(this.getMessage());
            }
            case 21: {
                return new CWE(this.getMessage());
            }
            case 22: {
                return new CWE(this.getMessage());
            }
            case 23: {
                return new CWE(this.getMessage());
            }
            case 24: {
                return new CQ(this.getMessage());
            }
            case 25: {
                return new NM(this.getMessage());
            }
            case 26: {
                return new CWE(this.getMessage());
            }
            case 27: {
                return new CWE(this.getMessage());
            }
            case 28: {
                return new CWE(this.getMessage());
            }
            case 29: {
                return new CX(this.getMessage());
            }
            case 30: {
                return new CX(this.getMessage());
            }
            case 31: {
                return new EI(this.getMessage());
            }
        }
        return null;
    }
}

