/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.connectors.file.SchemeProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import software.amazon.awssdk.regions.Region;

public class S3SchemeProperties
extends SchemeProperties {
    private boolean useDefaultCredentialProviderChain;
    private boolean useTemporaryCredentials;
    private int duration;
    private String region;
    private Map<String, List<String>> customHeaders;

    public S3SchemeProperties() {
        this.useDefaultCredentialProviderChain = true;
        this.useTemporaryCredentials = false;
        this.duration = 7200;
        this.region = Region.US_EAST_1.id();
        this.customHeaders = new LinkedHashMap<String, List<String>>();
    }

    public S3SchemeProperties(S3SchemeProperties props) {
        this.useDefaultCredentialProviderChain = props.isUseDefaultCredentialProviderChain();
        this.useTemporaryCredentials = props.isUseTemporaryCredentials();
        this.duration = props.getDuration();
        this.region = props.getRegion();
        this.customHeaders = new LinkedHashMap<String, List<String>>();
        if (MapUtils.isNotEmpty(props.getCustomHeaders())) {
            for (Map.Entry<String, List<String>> entry : props.getCustomHeaders().entrySet()) {
                this.customHeaders.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
        }
    }

    public boolean isUseDefaultCredentialProviderChain() {
        return this.useDefaultCredentialProviderChain;
    }

    public void setUseDefaultCredentialProviderChain(boolean useDefaultCredentialProviderChain) {
        this.useDefaultCredentialProviderChain = useDefaultCredentialProviderChain;
    }

    public boolean isUseTemporaryCredentials() {
        return this.useTemporaryCredentials;
    }

    public void setUseTemporaryCredentials(boolean useTemporaryCredentials) {
        this.useTemporaryCredentials = useTemporaryCredentials;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Map<String, List<String>> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, List<String>> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("useDefaultCredentialProviderChain", this.useDefaultCredentialProviderChain);
        purgedProperties.put("useTemporaryCredentials", this.useTemporaryCredentials);
        purgedProperties.put("duration", this.duration);
        try {
            Region regionValue = Region.of((String)this.region);
            purgedProperties.put("region", regionValue.id());
        }
        catch (Exception exception) {
            // empty catch block
        }
        purgedProperties.put("customHeadersCount", this.customHeaders != null ? this.customHeaders.size() : 0);
        return purgedProperties;
    }

    @Override
    public SchemeProperties getFileSchemeProperties() {
        return this;
    }

    @Override
    public String getSummaryText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Using ");
        try {
            Region regionValue = Region.of((String)this.region);
            builder.append("region ").append(regionValue.id());
        }
        catch (Exception e) {
            builder.append("variable region");
        }
        builder.append(", ");
        if (this.useDefaultCredentialProviderChain) {
            builder.append("Default Credential Provider Chain");
        } else {
            builder.append("Explicit Credentials");
        }
        if (this.useTemporaryCredentials) {
            builder.append(" with STS temporary access");
        }
        return builder.toString();
    }

    @Override
    public String toFormattedString() {
        StringBuilder builder = new StringBuilder();
        String newLine = "\n";
        builder.append("REGION: ").append(this.region).append(newLine);
        if (MapUtils.isNotEmpty(this.customHeaders)) {
            builder.append(newLine);
            builder.append("[CUSTOM HEADERS]");
            builder.append(newLine);
            for (Map.Entry<String, List<String>> entry : this.customHeaders.entrySet()) {
                for (String value : entry.getValue()) {
                    builder.append(entry.getKey());
                    builder.append(": ");
                    builder.append(value);
                    builder.append(newLine);
                }
            }
        }
        return builder.toString();
    }

    @Override
    public SchemeProperties clone() {
        return new S3SchemeProperties(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }
}

