/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.connectors.file.SchemeProperties;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class SftpSchemeProperties
extends SchemeProperties {
    private boolean passwordAuth;
    private boolean keyAuth;
    private String keyFile;
    private String passPhrase;
    private String hostKeyChecking;
    private String knownHostsFile;
    private Map<String, String> configurationSettings;

    public SftpSchemeProperties() {
        this.passwordAuth = true;
        this.keyAuth = false;
        this.keyFile = "";
        this.passPhrase = "";
        this.hostKeyChecking = "ask";
        this.knownHostsFile = "";
        this.configurationSettings = new LinkedHashMap<String, String>();
    }

    public SftpSchemeProperties(SftpSchemeProperties props) {
        this.passwordAuth = props.isPasswordAuth();
        this.keyAuth = props.isKeyAuth();
        this.keyFile = props.getKeyFile();
        this.passPhrase = props.getPassPhrase();
        this.hostKeyChecking = props.getHostChecking();
        this.knownHostsFile = props.getKnownHostsFile();
        this.configurationSettings = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : props.getConfigurationSettings().entrySet()) {
            this.configurationSettings.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean isPasswordAuth() {
        return this.passwordAuth;
    }

    public void setPasswordAuth(boolean passwordAuth) {
        this.passwordAuth = passwordAuth;
    }

    public boolean isKeyAuth() {
        return this.keyAuth;
    }

    public void setKeyAuth(boolean keyAuth) {
        this.keyAuth = keyAuth;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public void setKeyFile(String keyFile) {
        this.keyFile = keyFile;
    }

    public String getHostChecking() {
        return this.hostKeyChecking;
    }

    public void setHostChecking(String hostKeyChecking) {
        this.hostKeyChecking = hostKeyChecking;
    }

    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    public void setKnownHostsFile(String knownHostsFile) {
        this.knownHostsFile = knownHostsFile;
    }

    public Map<String, String> getConfigurationSettings() {
        return this.configurationSettings;
    }

    public void setConfigurationSettings(Map<String, String> configurationSettings) {
        this.configurationSettings = configurationSettings;
    }

    @Override
    public SchemeProperties getFileSchemeProperties() {
        return this;
    }

    @Override
    public String toFormattedString() {
        StringBuilder builder = new StringBuilder();
        String newLine = "\n";
        builder.append("HOST CHECKING: ");
        builder.append(this.hostKeyChecking);
        builder.append(newLine);
        if (MapUtils.isNotEmpty(this.configurationSettings)) {
            builder.append("[CONFIGURATION OPTIONS]");
            builder.append(newLine);
            for (Map.Entry<String, String> setting : this.configurationSettings.entrySet()) {
                builder.append(setting.getKey().toString());
                builder.append(": ");
                builder.append(setting.getValue().toString());
                builder.append(newLine);
            }
        }
        return builder.toString();
    }

    @Override
    public String getSummaryText() {
        StringBuilder builder = new StringBuilder();
        if (this.passwordAuth && this.keyAuth) {
            builder.append("Password and Public Key");
        } else if (this.keyAuth) {
            builder.append("Public Key");
        } else {
            builder.append("Password");
        }
        builder.append(" Authentication / Hostname Checking ");
        if (StringUtils.equals((CharSequence)this.hostKeyChecking, (CharSequence)"yes")) {
            builder.append("On");
        } else if (StringUtils.equals((CharSequence)this.hostKeyChecking, (CharSequence)"no")) {
            builder.append("Off");
        } else {
            builder.append("Ask");
        }
        return builder.toString();
    }

    @Override
    public SchemeProperties clone() {
        return new SftpSchemeProperties(this);
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("passwordAuth", this.passwordAuth);
        purgedProperties.put("keyAuth", this.keyAuth);
        purgedProperties.put("hostKeyChecking", this.hostKeyChecking);
        purgedProperties.put("configurationSettingsCount", this.configurationSettings.size());
        return purgedProperties;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }
}

