/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.commons.encryption;

import com.mirth.commons.encryption.EncryptionException;
import com.mirth.commons.encryption.Output;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;

public class Digester {
    public static final int DEFAULT_SALT_SIZE = 8;
    public static final int DEFAULT_ITERATIONS = 600000;
    public static final int DEFAULT_KEY_SIZE_BITS = 256;
    private String algorithm = "PBKDF2WithHmacSHA256";
    private Provider provider;
    private Output format = Output.BASE64;
    private boolean initialized = false;
    private SecureRandom saltGenerator;
    private int saltSizeBytes = 8;
    private int iterations = 600000;
    private boolean usePBE = true;
    private int keySizeBits = 256;
    private String fallbackAlgorithm;
    private int fallbackSaltSizeBytes = 8;
    private int fallbackIterations = 1000;
    private boolean fallbackUsePBE = false;
    private int fallbackKeySizeBits = 256;
    private Digester fallbackDigester;
    private Charset charset = Charset.forName(System.getProperty("mirth.digester.charset", StandardCharsets.UTF_8.name()));

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Output getFormat() {
        return this.format;
    }

    public void setFormat(Output format) {
        this.format = format;
    }

    public String getFallbackAlgorithm() {
        return this.fallbackAlgorithm;
    }

    public void setFallbackAlgorithm(String fallbackAlgorithm) {
        this.fallbackAlgorithm = fallbackAlgorithm;
    }

    public int getFallbackSaltSizeBytes() {
        return this.fallbackSaltSizeBytes;
    }

    public void setFallbackSaltSizeBytes(Integer fallbackSaltSizeBytes) {
        if (fallbackSaltSizeBytes != null) {
            this.fallbackSaltSizeBytes = fallbackSaltSizeBytes;
        }
    }

    public int getFallbackIterations() {
        return this.fallbackIterations;
    }

    public void setFallbackIterations(Integer fallbackIterations) {
        if (fallbackIterations != null) {
            this.fallbackIterations = fallbackIterations;
        }
    }

    public boolean isFallbackUsePBE() {
        return this.fallbackUsePBE;
    }

    public void setFallbackUsePBE(Boolean fallbackUsePBE) {
        if (fallbackUsePBE != null) {
            this.fallbackUsePBE = fallbackUsePBE;
        }
    }

    public int getFallbackKeySizeBits() {
        return this.fallbackKeySizeBits;
    }

    public void setFallbackKeySizeBits(Integer fallbackKeySizeBits) {
        if (fallbackKeySizeBits != null) {
            this.fallbackKeySizeBits = fallbackKeySizeBits;
        }
    }

    public SecureRandom getSaltGenerator() {
        return this.saltGenerator;
    }

    public void setSaltGenerator(SecureRandom saltGenerator) {
        this.saltGenerator = saltGenerator;
    }

    public int getSaltSizeBytes() {
        return this.saltSizeBytes;
    }

    public void setSaltSizeBytes(int saltSizeBytes) {
        this.saltSizeBytes = saltSizeBytes;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public boolean isUsePBE() {
        return this.usePBE;
    }

    public void setUsePBE(boolean usePBE) {
        this.usePBE = usePBE;
    }

    public int getKeySizeBits() {
        return this.keySizeBits;
    }

    public void setKeySizeBits(int keySizeBits) {
        this.keySizeBits = keySizeBits;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void initialize() throws EncryptionException {
        if (!this.isInitialized()) {
            try {
                this.saltGenerator = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                throw new EncryptionException(e);
            }
            this.setInitialized(true);
        }
    }

    public String digest(String message) throws EncryptionException {
        if (message == null) {
            return null;
        }
        try {
            if (!this.isInitialized()) {
                this.initialize();
            }
            byte[] salt = this.saltGenerator.generateSeed(this.saltSizeBytes);
            byte[] digest = this.digest(message, salt);
            if (this.format == Output.HEXADECIMAL) {
                return Hex.encodeHexString((byte[])digest);
            }
            return new String(Base64.encodeBase64Chunked((byte[])digest), this.charset);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    private byte[] digest(String message, byte[] salt) throws Exception {
        byte[] digestBytes;
        if (StringUtils.startsWithIgnoreCase((CharSequence)this.algorithm, (CharSequence)"Argon2")) {
            int mode = 2;
            if (StringUtils.equalsIgnoreCase((CharSequence)this.algorithm, (CharSequence)"Argon2i")) {
                mode = 1;
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.algorithm, (CharSequence)"Argon2d")) {
                mode = 0;
            }
            Argon2Parameters.Builder builder = new Argon2Parameters.Builder(mode).withVersion(19).withIterations(this.iterations).withMemoryAsKB(12288).withParallelism(1).withSalt(salt);
            Argon2BytesGenerator gen = new Argon2BytesGenerator();
            gen.init(builder.build());
            digestBytes = new byte[32];
            gen.generateBytes(message.getBytes(this.charset), digestBytes);
        } else if (this.usePBE) {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(this.algorithm, this.provider);
            PBEKeySpec keySpec = new PBEKeySpec(message.toCharArray(), salt, this.iterations, this.keySizeBits);
            digestBytes = keyFactory.generateSecret(keySpec).getEncoded();
        } else {
            MessageDigest messageDigest = MessageDigest.getInstance(this.algorithm, this.provider);
            messageDigest.reset();
            messageDigest.update(salt);
            messageDigest.update(message.getBytes(this.charset));
            digestBytes = messageDigest.digest();
            for (int i = 0; i < this.iterations - 1; ++i) {
                messageDigest.reset();
                digestBytes = messageDigest.digest(digestBytes);
            }
        }
        return ArrayUtils.addAll((byte[])salt, (byte[])digestBytes);
    }

    public boolean matches(String message, String digest) throws EncryptionException {
        boolean matches = false;
        EncryptionException firstCause = null;
        try {
            matches = this.doMatches(message, digest);
        }
        catch (EncryptionException e) {
            firstCause = e;
        }
        if (!matches && this.getFallback() != null) {
            try {
                matches = this.getFallback().matches(message, digest);
            }
            catch (EncryptionException e) {
                throw firstCause != null ? firstCause : e;
            }
        }
        return matches;
    }

    private boolean doMatches(String message, String digest) throws EncryptionException {
        try {
            byte[] digestBytes = null;
            digestBytes = this.format == Output.HEXADECIMAL ? Hex.decodeHex((char[])digest.toCharArray()) : Base64.decodeBase64((byte[])digest.getBytes(this.charset));
            return this.matches(message, digestBytes);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    private boolean matches(String message, byte[] digest) throws Exception {
        byte[] salt = new byte[this.saltSizeBytes];
        System.arraycopy(digest, 0, salt, 0, this.saltSizeBytes);
        return Arrays.equals(this.digest(message, salt), digest);
    }

    private Digester getFallback() {
        if (this.fallbackDigester == null && this.fallbackAlgorithm != null) {
            this.fallbackDigester = new Digester();
            this.fallbackDigester.setProvider(this.provider);
            this.fallbackDigester.setAlgorithm(this.fallbackAlgorithm);
            this.fallbackDigester.setSaltSizeBytes(this.fallbackSaltSizeBytes);
            this.fallbackDigester.setIterations(this.fallbackIterations);
            this.fallbackDigester.setUsePBE(this.fallbackUsePBE);
            this.fallbackDigester.setKeySizeBits(this.fallbackKeySizeBits);
            this.fallbackDigester.setFormat(this.format);
        }
        return this.fallbackDigester;
    }
}

