/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.mllpmode;

import com.mirth.connect.model.transmission.TransmissionModeProperties;
import com.mirth.connect.model.transmission.framemode.FrameModeProperties;
import com.mirth.connect.plugins.FrameTransmissionModeClientProvider;
import com.mirth.connect.plugins.mllpmode.MLLPModeProperties;
import com.mirth.connect.plugins.mllpmode.MLLPModeSettingsDialog;
import com.mirth.connect.plugins.mllpmode.MLLPModeSettingsPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class MLLPModeClientProvider
extends FrameTransmissionModeClientProvider {
    static final String CHANGE_START_BYTES_COMMAND = "changeStartBytes";
    static final String CHANGE_END_BYTES_COMMAND = "changeEndBytes";
    protected MLLPModeSettingsPanel settingsPanel;
    private MLLPModeProperties mllpModeProperties;

    public void initialize(ActionListener actionListener) {
        super.initialize(actionListener);
        this.settingsPanel = new MLLPModeSettingsPanel((ActionListener)((Object)this));
        ((FrameTransmissionModeClientProvider)this).settingsPanel.switchComponent((JComponent)this.settingsPanel);
        this.setProperties((TransmissionModeProperties)new MLLPModeProperties());
    }

    public TransmissionModeProperties getProperties() {
        FrameModeProperties frameModeProperties = (FrameModeProperties)super.getProperties();
        this.mllpModeProperties.setStartOfMessageBytes(frameModeProperties.getStartOfMessageBytes());
        this.mllpModeProperties.setEndOfMessageBytes(frameModeProperties.getEndOfMessageBytes());
        return this.mllpModeProperties;
    }

    public TransmissionModeProperties getDefaultProperties() {
        return new MLLPModeProperties();
    }

    public void setProperties(TransmissionModeProperties properties) {
        super.setProperties(properties);
        if (properties instanceof MLLPModeProperties) {
            this.mllpModeProperties = (MLLPModeProperties)properties;
        } else {
            this.mllpModeProperties = new MLLPModeProperties();
            FrameModeProperties frameModeProperties = (FrameModeProperties)properties;
            this.mllpModeProperties.setStartOfMessageBytes(frameModeProperties.getStartOfMessageBytes());
            this.mllpModeProperties.setEndOfMessageBytes(frameModeProperties.getEndOfMessageBytes());
        }
        this.changeSampleValue();
    }

    public JComponent getSettingsComponent() {
        return this.settingsPanel;
    }

    public String getSampleLabel() {
        return "MLLP Sample Frame:";
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals(CHANGE_START_BYTES_COMMAND)) {
            ((FrameTransmissionModeClientProvider)this).settingsPanel.startOfMessageBytesField.setText(((JTextField)evt.getSource()).getText());
        } else if (evt.getActionCommand().equals(CHANGE_END_BYTES_COMMAND)) {
            ((FrameTransmissionModeClientProvider)this).settingsPanel.endOfMessageBytesField.setText(((JTextField)evt.getSource()).getText());
        } else {
            MLLPModeSettingsDialog settingsDialog = new MLLPModeSettingsDialog((ActionListener)((Object)this));
            settingsDialog.setProperties((TransmissionModeProperties)this.mllpModeProperties);
            settingsDialog.setVisible(true);
            if (settingsDialog.isSaved()) {
                this.setProperties(settingsDialog.getProperties());
            } else {
                this.setProperties((TransmissionModeProperties)this.mllpModeProperties);
            }
        }
    }
}

