/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.mllpmode;

import com.mirth.connect.client.ui.ByteAbbreviationList;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.model.transmission.TransmissionModeProperties;
import com.mirth.connect.plugins.mllpmode.MLLPModeProperties;
import com.mirth.connect.util.TcpUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.commons.lang3.StringUtils;

public class MLLPModeSettingsDialog
extends MirthDialog
implements DocumentListener {
    private boolean saved;
    private String startOfMessageAbbreviation;
    private String endOfMessageAbbreviation;
    private String ackAbbreviation;
    private String nackAbbreviation;
    private ActionListener actionListener;
    private JLabel ackBytes0XLabel;
    private JLabel ackBytesAbbrevLabel;
    private MirthTextField ackBytesField;
    private JLabel ackBytesLabel;
    private ByteAbbreviationList byteAbbreviationList1;
    private JButton cancelButton;
    private JLabel endOfMessageBytes0XLabel;
    private JLabel endOfMessageBytesAbbrevLabel;
    private MirthTextField endOfMessageBytesField;
    private JLabel endOfMessageBytesLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private MirthTextField maxRetryCountField;
    private JLabel maxRetryCountLabel;
    private JLabel nackBytes0XLabel;
    private JLabel nackBytesAbbrevLabel;
    private MirthTextField nackBytesField;
    private JLabel nackBytesLabel;
    private JButton okButton;
    private JLabel startOfMessageBytes0XLabel;
    private JLabel startOfMessageBytesAbbrevLabel;
    private MirthTextField startOfMessageBytesField;
    private JLabel startOfMessageBytesLabel;
    private ButtonGroup useMLLPv2ButtonGroup;
    private JLabel useMLLPv2Label;
    private MirthRadioButton useMLLPv2NoRadio;
    private MirthRadioButton useMLLPv2YesRadio;

    public MLLPModeSettingsDialog(ActionListener actionListener) {
        super((Window)PlatformUI.MIRTH_FRAME);
        this.initComponents();
        this.actionListener = actionListener;
        this.startOfMessageBytesField.setDocument((Document)new MirthFieldConstraints(0, true, false, false));
        this.endOfMessageBytesField.setDocument((Document)new MirthFieldConstraints(0, true, false, false));
        this.ackBytesField.setDocument((Document)new MirthFieldConstraints(0, true, false, false));
        this.nackBytesField.setDocument((Document)new MirthFieldConstraints(0, true, false, false));
        this.maxRetryCountField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        this.startOfMessageBytesField.getDocument().addDocumentListener(this);
        this.endOfMessageBytesField.getDocument().addDocumentListener(this);
        this.ackBytesField.getDocument().addDocumentListener(this);
        this.nackBytesField.getDocument().addDocumentListener(this);
        this.startOfMessageAbbreviation = "";
        this.endOfMessageAbbreviation = "";
        this.ackAbbreviation = "";
        this.nackAbbreviation = "";
    }

    public void setVisible(boolean b) {
        if (b) {
            Dimension dlgSize = this.getPreferredSize();
            Dimension frmSize = this.getParent().getSize();
            Point loc = this.getParent().getLocation();
            if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
                this.setLocationRelativeTo(null);
            } else {
                this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            }
            this.saved = false;
            this.resetInvalidProperties();
        }
        super.setVisible(b);
    }

    public TransmissionModeProperties getProperties() {
        MLLPModeProperties props = new MLLPModeProperties();
        props.setStartOfMessageBytes(this.startOfMessageBytesField.getText());
        props.setEndOfMessageBytes(this.endOfMessageBytesField.getText());
        props.setUseMLLPv2(this.useMLLPv2YesRadio.isSelected());
        props.setAckBytes(this.ackBytesField.getText());
        props.setNackBytes(this.nackBytesField.getText());
        props.setMaxRetries(this.maxRetryCountField.getText());
        return props;
    }

    public void setProperties(TransmissionModeProperties properties) {
        MLLPModeProperties props = (MLLPModeProperties)properties;
        this.startOfMessageBytesField.setText(props.getStartOfMessageBytes());
        this.endOfMessageBytesField.setText(props.getEndOfMessageBytes());
        if (props.isUseMLLPv2()) {
            this.useMLLPv2YesRadio.setSelected(true);
            this.useMLLPv2YesRadioActionPerformed(null);
        } else {
            this.useMLLPv2NoRadio.setSelected(true);
            this.useMLLPv2NoRadioActionPerformed(null);
        }
        this.ackBytesField.setText(props.getAckBytes());
        this.nackBytesField.setText(props.getNackBytes());
        this.maxRetryCountField.setText(props.getMaxRetries());
        this.startOfMessageAbbreviation = TcpUtil.convertHexToAbbreviation((String)this.startOfMessageBytesField.getText());
        this.endOfMessageAbbreviation = TcpUtil.convertHexToAbbreviation((String)this.endOfMessageBytesField.getText());
        this.ackAbbreviation = TcpUtil.convertHexToAbbreviation((String)this.ackBytesField.getText());
        this.nackAbbreviation = TcpUtil.convertHexToAbbreviation((String)this.nackBytesField.getText());
    }

    public String checkProperties() {
        this.resetInvalidProperties();
        Object errors = "";
        if (!this.validBytes(this.startOfMessageBytesField.getText())) {
            errors = (String)errors + "Invalid start of message bytes.\r\n";
            this.startOfMessageBytesField.setBackground(UIConstants.INVALID_COLOR);
        }
        if (!this.validBytes(this.endOfMessageBytesField.getText())) {
            errors = (String)errors + "Invalid end of message bytes.\r\n";
            this.endOfMessageBytesField.setBackground(UIConstants.INVALID_COLOR);
        }
        if (this.useMLLPv2YesRadio.isSelected()) {
            if (!this.validBytes(this.ackBytesField.getText())) {
                errors = (String)errors + "Invalid affirmative commit acknowledgement bytes.\r\n";
                this.ackBytesField.setBackground(UIConstants.INVALID_COLOR);
            }
            if (!this.validBytes(this.nackBytesField.getText())) {
                errors = (String)errors + "Invalid negative commit acknowledgement bytes.\r\n";
                this.nackBytesField.setBackground(UIConstants.INVALID_COLOR);
            }
            if (this.maxRetryCountField.getText().length() == 0) {
                errors = (String)errors + "Invalid maximum retry count.\r\n";
                this.maxRetryCountField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return errors;
    }

    public void resetInvalidProperties() {
        this.startOfMessageBytesField.setBackground(null);
        this.endOfMessageBytesField.setBackground(null);
        this.ackBytesField.setBackground(null);
        this.nackBytesField.setBackground(null);
        this.maxRetryCountField.setBackground(null);
    }

    public boolean isSaved() {
        return this.saved;
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.changeAbbreviation(evt);
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.changeAbbreviation(evt);
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.changeAbbreviation(evt);
    }

    private void changeAbbreviation(DocumentEvent evt) {
        String text = "";
        try {
            text = evt.getDocument().getText(0, evt.getDocument().getLength()).trim();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (evt.getDocument().equals(this.startOfMessageBytesField.getDocument())) {
            this.startOfMessageAbbreviation = TcpUtil.convertHexToAbbreviation((String)text);
            this.actionListener.actionPerformed(new ActionEvent(this.startOfMessageBytesField, 1001, "changeStartBytes"));
        } else if (evt.getDocument().equals(this.endOfMessageBytesField.getDocument())) {
            this.endOfMessageAbbreviation = TcpUtil.convertHexToAbbreviation((String)text);
            this.actionListener.actionPerformed(new ActionEvent(this.endOfMessageBytesField, 1001, "changeEndBytes"));
        } else if (evt.getDocument().equals(this.ackBytesField.getDocument())) {
            this.ackAbbreviation = TcpUtil.convertHexToAbbreviation((String)text);
        } else {
            this.nackAbbreviation = TcpUtil.convertHexToAbbreviation((String)text);
        }
        this.changeAbbreviation();
    }

    private void changeAbbreviation() {
        this.startOfMessageBytesAbbrevLabel.setText(this.startOfMessageAbbreviation);
        this.endOfMessageBytesAbbrevLabel.setText(this.endOfMessageAbbreviation);
        this.ackBytesAbbrevLabel.setText(this.ackAbbreviation);
        this.nackBytesAbbrevLabel.setText(this.nackAbbreviation);
        this.pack();
    }

    private boolean validBytes(String byteString) {
        return StringUtils.isNotBlank((CharSequence)byteString) && TcpUtil.isValidHexString((String)byteString);
    }

    private void initComponents() {
        this.useMLLPv2ButtonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.ackBytesLabel = new JLabel();
        this.startOfMessageBytesAbbrevLabel = new JLabel();
        this.maxRetryCountLabel = new JLabel();
        this.startOfMessageBytesLabel = new JLabel();
        this.endOfMessageBytesLabel = new JLabel();
        this.startOfMessageBytesField = new MirthTextField();
        this.nackBytesLabel = new JLabel();
        this.startOfMessageBytes0XLabel = new JLabel();
        this.endOfMessageBytesAbbrevLabel = new JLabel();
        this.endOfMessageBytesField = new MirthTextField();
        this.endOfMessageBytes0XLabel = new JLabel();
        this.ackBytesAbbrevLabel = new JLabel();
        this.ackBytesField = new MirthTextField();
        this.ackBytes0XLabel = new JLabel();
        this.nackBytesAbbrevLabel = new JLabel();
        this.nackBytesField = new MirthTextField();
        this.nackBytes0XLabel = new JLabel();
        this.maxRetryCountField = new MirthTextField();
        this.useMLLPv2Label = new JLabel();
        this.useMLLPv2YesRadio = new MirthRadioButton();
        this.useMLLPv2NoRadio = new MirthRadioButton();
        this.jSeparator1 = new JSeparator();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.byteAbbreviationList1 = new ByteAbbreviationList();
        this.setDefaultCloseOperation(2);
        this.setTitle("Transmission Mode Settings");
        this.setModal(true);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("MLLP Settings"));
        this.jPanel2.setMinimumSize(new Dimension(323, 0));
        this.ackBytesLabel.setText("Commit ACK Bytes:");
        this.ackBytesLabel.setToolTipText("<html>The MLLPv2 Affirmative Commit Acknowledgement bytes to expect after successfully sending a message,<br/>and to send after successfully receiving a message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.startOfMessageBytesAbbrevLabel.setText("<VT>");
        this.startOfMessageBytesAbbrevLabel.setToolTipText("<html>The MLLPv2 Start Block bytes before the beginning of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.maxRetryCountLabel.setText("Max Retry Count:");
        this.maxRetryCountLabel.setToolTipText("<html>The maximum number of times to retry unsuccessful dispatches before giving up and logging an error.</html>");
        this.startOfMessageBytesLabel.setText("Start of Message Bytes:");
        this.startOfMessageBytesLabel.setToolTipText("<html>The MLLPv2 Start Block bytes before the beginning of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.endOfMessageBytesLabel.setText("End of Message Bytes:");
        this.endOfMessageBytesLabel.setToolTipText("<html>The MLLPv2 End Data/Block bytes after the end of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.startOfMessageBytesField.setToolTipText("<html>The MLLPv2 Start Block bytes before the beginning of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.startOfMessageBytesField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MLLPModeSettingsDialog.this.startOfMessageBytesFieldActionPerformed(evt);
            }
        });
        this.nackBytesLabel.setText("Commit NACK Bytes:");
        this.nackBytesLabel.setToolTipText("<html>The MLLPv2 Negative Commit Acknowledgement bytes to expect after unsuccessfully sending a message,<br/>and to send after unsuccessfully receiving a message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.startOfMessageBytes0XLabel.setText("0x");
        this.startOfMessageBytes0XLabel.setToolTipText("<html>The MLLPv2 Start Block bytes before the beginning of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.endOfMessageBytesAbbrevLabel.setText("<FS><CR>");
        this.endOfMessageBytesAbbrevLabel.setToolTipText("<html>The MLLPv2 End Data/Block bytes after the end of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.endOfMessageBytesField.setToolTipText("<html>The MLLPv2 End Data/Block bytes after the end of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.endOfMessageBytesField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MLLPModeSettingsDialog.this.endOfMessageBytesFieldActionPerformed(evt);
            }
        });
        this.endOfMessageBytes0XLabel.setText("0x");
        this.endOfMessageBytes0XLabel.setToolTipText("<html>The MLLPv2 End Data/Block bytes after the end of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.ackBytesAbbrevLabel.setText("<ACK>");
        this.ackBytesAbbrevLabel.setToolTipText("<html>The MLLPv2 Affirmative Commit Acknowledgement bytes to expect after successfully sending a message,<br/>and to send after successfully receiving a message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.ackBytesField.setToolTipText("<html>The MLLPv2 Affirmative Commit Acknowledgement bytes to expect after successfully sending a message,<br/>and to send after successfully receiving a message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.ackBytesField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MLLPModeSettingsDialog.this.ackBytesFieldActionPerformed(evt);
            }
        });
        this.ackBytes0XLabel.setText("0x");
        this.ackBytes0XLabel.setToolTipText("<html>The MLLPv2 Affirmative Commit Acknowledgement bytes to expect after successfully sending a message,<br/>and to send after successfully receiving a message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.nackBytesAbbrevLabel.setText("<NAK>");
        this.nackBytesAbbrevLabel.setToolTipText("<html>The MLLPv2 Negative Commit Acknowledgement bytes to expect after unsuccessfully sending a message,<br/>and to send after unsuccessfully receiving a message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.nackBytesField.setToolTipText("<html>The MLLPv2 Negative Commit Acknowledgement bytes to expect after unsuccessfully sending a message,<br/>and to send after unsuccessfully receiving a message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.nackBytesField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MLLPModeSettingsDialog.this.nackBytesFieldActionPerformed(evt);
            }
        });
        this.nackBytes0XLabel.setText("0x");
        this.nackBytes0XLabel.setToolTipText("<html>The MLLPv2 Negative Commit Acknowledgement bytes to expect after unsuccessfully sending a message,<br/>and to send after unsuccessfully receiving a message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.maxRetryCountField.setToolTipText("<html>The maximum number of times to retry unsuccessful dispatches before giving up and logging an error.</html>");
        this.maxRetryCountField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MLLPModeSettingsDialog.this.maxRetryCountFieldActionPerformed(evt);
            }
        });
        this.useMLLPv2Label.setText("Use MLLPv2:");
        this.useMLLPv2YesRadio.setBackground(new Color(255, 255, 255));
        this.useMLLPv2YesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useMLLPv2ButtonGroup.add((AbstractButton)this.useMLLPv2YesRadio);
        this.useMLLPv2YesRadio.setText("Yes");
        this.useMLLPv2YesRadio.setToolTipText("<html>Select Yes to use the MLLPv2 bi-directional transport layer,<br/>which includes reliable delivery assurance as per the HL7 specifications.</html>");
        this.useMLLPv2YesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.useMLLPv2YesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MLLPModeSettingsDialog.this.useMLLPv2YesRadioActionPerformed(evt);
            }
        });
        this.useMLLPv2NoRadio.setBackground(new Color(255, 255, 255));
        this.useMLLPv2NoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useMLLPv2ButtonGroup.add((AbstractButton)this.useMLLPv2NoRadio);
        this.useMLLPv2NoRadio.setSelected(true);
        this.useMLLPv2NoRadio.setText("No");
        this.useMLLPv2NoRadio.setToolTipText("<html>Select Yes to use the MLLPv2 bi-directional transport layer,<br/>which includes reliable delivery assurance as per the HL7 specifications.</html>");
        this.useMLLPv2NoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.useMLLPv2NoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MLLPModeSettingsDialog.this.useMLLPv2NoRadioActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startOfMessageBytesLabel, GroupLayout.Alignment.TRAILING).addComponent(this.endOfMessageBytesLabel, GroupLayout.Alignment.TRAILING).addComponent(this.useMLLPv2Label, GroupLayout.Alignment.TRAILING).addComponent(this.ackBytesLabel, GroupLayout.Alignment.TRAILING).addComponent(this.nackBytesLabel, GroupLayout.Alignment.TRAILING).addComponent(this.maxRetryCountLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.startOfMessageBytes0XLabel).addGap(3, 3, 3).addComponent((Component)this.startOfMessageBytesField, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startOfMessageBytesAbbrevLabel, -1, -1, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.endOfMessageBytes0XLabel).addGap(3, 3, 3).addComponent((Component)this.endOfMessageBytesField, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endOfMessageBytesAbbrevLabel, -1, -1, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.ackBytes0XLabel).addGap(3, 3, 3).addComponent((Component)this.ackBytesField, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ackBytesAbbrevLabel, -1, -1, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent((Component)this.useMLLPv2YesRadio, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.useMLLPv2NoRadio, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.maxRetryCountField, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.nackBytes0XLabel).addGap(3, 3, 3).addComponent((Component)this.nackBytesField, -2, 46, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nackBytesAbbrevLabel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startOfMessageBytesLabel).addComponent(this.startOfMessageBytes0XLabel).addComponent((Component)this.startOfMessageBytesField, -2, -1, -2).addComponent(this.startOfMessageBytesAbbrevLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.endOfMessageBytesLabel).addComponent(this.endOfMessageBytes0XLabel).addComponent((Component)this.endOfMessageBytesField, -2, -1, -2).addComponent(this.endOfMessageBytesAbbrevLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useMLLPv2Label).addComponent((Component)this.useMLLPv2YesRadio, -2, -1, -2).addComponent((Component)this.useMLLPv2NoRadio, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ackBytesLabel).addComponent(this.ackBytes0XLabel).addComponent((Component)this.ackBytesField, -2, -1, -2).addComponent(this.ackBytesAbbrevLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nackBytesLabel).addComponent(this.nackBytes0XLabel).addComponent((Component)this.nackBytesField, -2, -1, -2).addComponent(this.nackBytesAbbrevLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxRetryCountLabel).addComponent((Component)this.maxRetryCountField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MLLPModeSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MLLPModeSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.byteAbbreviationList1, -2, 125, -2))))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent((Component)this.byteAbbreviationList1, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void startOfMessageBytesFieldActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String errors = this.checkProperties();
        if (!errors.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error validating MLLPv2 transmission mode settings.\r\n\r\n" + errors, "Validation Error", 0);
        } else {
            this.saved = true;
            PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
            this.dispose();
        }
    }

    private void endOfMessageBytesFieldActionPerformed(ActionEvent evt) {
    }

    private void ackBytesFieldActionPerformed(ActionEvent evt) {
    }

    private void nackBytesFieldActionPerformed(ActionEvent evt) {
    }

    private void maxRetryCountFieldActionPerformed(ActionEvent evt) {
    }

    private void useMLLPv2YesRadioActionPerformed(ActionEvent evt) {
        this.ackBytesLabel.setEnabled(true);
        this.ackBytes0XLabel.setEnabled(true);
        this.ackBytesField.setEnabled(true);
        this.ackBytesAbbrevLabel.setEnabled(true);
        this.nackBytesLabel.setEnabled(true);
        this.nackBytes0XLabel.setEnabled(true);
        this.nackBytesField.setEnabled(true);
        this.nackBytesAbbrevLabel.setEnabled(true);
        this.maxRetryCountLabel.setEnabled(true);
        this.maxRetryCountField.setEnabled(true);
    }

    private void useMLLPv2NoRadioActionPerformed(ActionEvent evt) {
        this.ackBytesLabel.setEnabled(false);
        this.ackBytes0XLabel.setEnabled(false);
        this.ackBytesField.setEnabled(false);
        this.ackBytesAbbrevLabel.setEnabled(false);
        this.nackBytesLabel.setEnabled(false);
        this.nackBytes0XLabel.setEnabled(false);
        this.nackBytesField.setEnabled(false);
        this.nackBytesAbbrevLabel.setEnabled(false);
        this.maxRetryCountLabel.setEnabled(false);
        this.maxRetryCountField.setEnabled(false);
    }
}

