/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.ws;

import com.mirth.connect.connectors.ws.SSLSocketFactoryWrapper;
import com.mirth.connect.connectors.ws.WebServiceConfiguration;
import com.mirth.connect.connectors.ws.WebServiceDispatcher;
import com.mirth.connect.connectors.ws.WebServiceDispatcherProperties;
import com.mirth.connect.connectors.ws.WebServiceReceiver;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.util.MirthSSLUtil;
import com.sun.net.httpserver.HttpServer;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContexts;

public class DefaultWebServiceConfiguration
implements WebServiceConfiguration {
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private SSLContext sslContext;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;

    @Override
    public void configureConnectorDeploy(Connector connector) throws Exception {
        if (connector instanceof WebServiceDispatcher) {
            this.sslContext = SSLContexts.createSystemDefault();
            this.enabledProtocols = MirthSSLUtil.getEnabledHttpsProtocols((String[])this.configurationController.getHttpsClientProtocols());
            this.enabledCipherSuites = MirthSSLUtil.getEnabledHttpsCipherSuites((String[])this.configurationController.getHttpsCipherSuites());
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(this.sslContext, this.enabledProtocols, this.enabledCipherSuites, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            ((WebServiceDispatcher)connector).getSocketFactoryRegistry().register("https", (Object)sslConnectionSocketFactory);
        }
    }

    @Override
    public void configureConnectorUndeploy(Connector connector) {
    }

    @Override
    public void configureReceiver(WebServiceReceiver connector) throws Exception {
        connector.setServer(HttpServer.create());
    }

    @Override
    public void configureDispatcher(WebServiceDispatcher connector, WebServiceDispatcherProperties connectorProperties, Map<String, Object> requestContext) throws Exception {
        SSLSocketFactoryWrapper socketFactory = new SSLSocketFactoryWrapper(this.sslContext.getSocketFactory(), this.enabledProtocols, this.enabledCipherSuites);
        requestContext.put("com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory", socketFactory);
        requestContext.put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", socketFactory);
    }
}

