/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.ws;

import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.connectors.ws.DefinitionServiceMap;
import com.mirth.connect.connectors.ws.WebServiceConnectorServletInterface;
import com.mirth.connect.connectors.ws.WebServiceDispatcherProperties;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.util.ConnectorUtil;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.util.ConnectionTestResponse;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;

public class WebServiceConnectorServlet
extends MirthServlet
implements WebServiceConnectorServletInterface {
    protected static final int MAX_TIMEOUT = 300000;
    protected static final TemplateValueReplacer replacer = new TemplateValueReplacer();
    private static final Map<String, DefinitionServiceMap> definitionCache = new HashMap<String, DefinitionServiceMap>();
    private static final Map<String, Map<String, Map<String, Definition>>> wsdlInterfaceCache = new HashMap<String, Map<String, Map<String, Definition>>>();
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private static final Logger logger = LogManager.getLogger(WebServiceConnectorServlet.class);

    public WebServiceConnectorServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc, "Web Service Connector Service");
    }

    public Object cacheWsdlFromUrl(String channelId, String channelName, WebServiceDispatcherProperties properties) {
        try {
            String wsdlUrl = this.getWsdlUrl(channelId, channelName, properties.getWsdlUrl(), properties.getUsername(), properties.getPassword());
            this.cacheWsdlInterfaces(wsdlUrl, this.getDefinition(wsdlUrl, properties, channelId));
            return null;
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public boolean isWsdlCached(String channelId, String channelName, String wsdlUrl, String username, String password) {
        try {
            return definitionCache.get(this.getWsdlUrl(channelId, channelName, wsdlUrl, username, password)) != null;
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public DefinitionServiceMap getDefinition(String channelId, String channelName, String wsdlUrl, String username, String password) {
        try {
            wsdlUrl = this.getWsdlUrl(channelId, channelName, wsdlUrl, username, password);
            DefinitionServiceMap definition = definitionCache.get(wsdlUrl);
            if (definition == null) {
                throw new Exception("WSDL not cached for URL: " + wsdlUrl);
            }
            return definition;
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public String generateEnvelope(String channelId, String channelName, String wsdlUrl, String username, String password, String service, String port, String operation, boolean buildOptional) {
        try {
            wsdlUrl = this.getWsdlUrl(channelId, channelName, wsdlUrl, username, password);
            return this.buildEnvelope(this.getCachedDefinition(wsdlUrl, service, port, channelId, channelName), operation, buildOptional);
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public String getSoapAction(String channelId, String channelName, String wsdlUrl, String username, String password, String service, String port, String operation) {
        try {
            wsdlUrl = this.getWsdlUrl(channelId, channelName, wsdlUrl, username, password);
            Definition definition = this.getCachedDefinition(wsdlUrl, service, port, channelId, channelName);
            String soapOp = "";
            for (Object serviceObject : definition.getServices().values()) {
                Service defService = (Service)serviceObject;
                if (!MapUtils.isNotEmpty((Map)defService.getPorts())) continue;
                for (Object portObject : defService.getPorts().values()) {
                    Port defPort = (Port)portObject;
                    for (Object bindingOperation : defPort.getBinding().getBindingOperations()) {
                        List extensions = ((BindingOperation)bindingOperation).getExtensibilityElements();
                        if (extensions == null) continue;
                        for (int i = 0; i < extensions.size(); ++i) {
                            if (!StringUtils.equalsIgnoreCase((CharSequence)((BindingOperation)bindingOperation).getName(), (CharSequence)operation)) continue;
                            ExtensibilityElement extElement = (ExtensibilityElement)extensions.get(i);
                            if (extElement instanceof SOAPOperation) {
                                return ((SOAPOperation)extElement).getSoapActionURI();
                            }
                            if (!(extElement instanceof SOAP12Operation)) continue;
                            return ((SOAP12Operation)extElement).getSoapActionURI();
                        }
                    }
                }
            }
            return soapOp;
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public ConnectionTestResponse testConnection(String channelId, String channelName, WebServiceDispatcherProperties properties) {
        try {
            if (StringUtils.isNotBlank((CharSequence)properties.getLocationURI())) {
                return this.testConnection(channelId, channelName, properties.getLocationURI());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getWsdlUrl())) {
                return this.testConnection(channelId, channelName, properties.getWsdlUrl());
            }
            throw new Exception("Both WSDL URL and Location URI are blank. At least one must be populated in order to test connection.");
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    protected ConnectionTestResponse testConnection(String channelId, String channelName, String urlString) throws Exception {
        URL url = new URL(replacer.replaceValues(urlString, channelId, channelName));
        int port = url.getPort();
        return ConnectorUtil.testConnection((String)url.getHost(), (int)(port == -1 ? (StringUtils.equalsIgnoreCase((CharSequence)url.getProtocol(), (CharSequence)"https") ? 443 : 80) : port), (int)300000);
    }

    protected String getWsdlUrl(String channelId, String channelName, String wsdlUrl, String username, String password) throws Exception {
        wsdlUrl = replacer.replaceValues(wsdlUrl, channelId, channelName);
        username = replacer.replaceValues(username, channelId, channelName);
        password = replacer.replaceValues(password, channelId, channelName);
        return this.getURIWithCredentials(new URI(wsdlUrl), username, password).toURL().toString();
    }

    private Definition getCachedDefinition(String wsdlUrl, String service, String port, String channelId, String channelName) throws Exception {
        service = replacer.replaceValues(service, channelId, channelName);
        port = replacer.replaceValues(port, channelId, channelName);
        Map<String, Map<String, Definition>> serviceMap = wsdlInterfaceCache.get(wsdlUrl);
        if (serviceMap == null) {
            throw new Exception("WSDL not cached for URL: " + wsdlUrl);
        }
        Map<String, Definition> portMap = serviceMap.get(service);
        if (portMap == null) {
            throw new Exception("No service \"" + service + "\" found in cached WSDL.");
        }
        if (portMap.containsKey(port)) {
            Definition definition = portMap.get(port);
            if (definition == null) {
                throw new Exception("No interface found for port \"" + port + "\" and service \"" + service + "\" in cached WSDL.");
            }
            return definition;
        }
        throw new Exception("No port \"" + port + "\" found for service \"" + service + "\" in cached WSDL.");
    }

    public URI getURIWithCredentials(URI wsdlUrl, String username, String password) throws URISyntaxException {
        if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
            String hostWithCredentials = username + ":" + password + "@" + wsdlUrl.getHost();
            if (wsdlUrl.getPort() > -1) {
                hostWithCredentials = hostWithCredentials + ":" + wsdlUrl.getPort();
            }
            wsdlUrl = new URI(wsdlUrl.getScheme(), hostWithCredentials, wsdlUrl.getPath(), wsdlUrl.getQuery(), wsdlUrl.getFragment());
        }
        return wsdlUrl;
    }

    private Definition getDefinition(String wsdlUrl, WebServiceDispatcherProperties props, String channelId) throws Exception {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        int timeout = NumberUtils.toInt((String)props.getSocketTimeout());
        return this.importWsdlInterfaces(wsdlFactory, wsdlUrl, wsdlReader, timeout);
    }

    public Definition importWsdlInterfaces(WSDLFactory wsdlFactory, final String wsdlUrl, final WSDLReader wsdlReader, int timeout) throws Exception {
        try {
            Future<Definition> future = executor.submit(new Callable<Definition>(){

                @Override
                public Definition call() throws Exception {
                    return wsdlReader.readWSDL(null, wsdlUrl);
                }
            });
            timeout = timeout > 0 ? Math.min(timeout, 300000) : 300000;
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (e instanceof TimeoutException) {
                e = new Exception("WSDL import operation timed out");
            }
            throw e;
        }
    }

    public void cacheWsdlInterfaces(String wsdlUrl, Definition definition) throws Exception {
        LinkedHashMap wsdlInterfaceServiceMap;
        DefinitionServiceMap definitionServiceMap;
        if (definition != null) {
            definitionServiceMap = new DefinitionServiceMap();
            wsdlInterfaceServiceMap = new LinkedHashMap();
            if (MapUtils.isNotEmpty((Map)definition.getServices())) {
                for (Object serviceObject : definition.getServices().values()) {
                    Service service = (Service)serviceObject;
                    logger.debug("Service: " + service.getQName().toString());
                    DefinitionServiceMap.DefinitionPortMap definitionPortMap = new DefinitionServiceMap.DefinitionPortMap();
                    LinkedHashMap<String, Definition> wsdlInterfacePortMap = new LinkedHashMap<String, Definition>();
                    if (MapUtils.isNotEmpty((Map)service.getPorts())) {
                        for (Object portObject : service.getPorts().values()) {
                            Object element2;
                            Port port = (Port)portObject;
                            String portQName = new QName(service.getQName().getNamespaceURI(), port.getName()).toString();
                            logger.debug("    Port: " + String.valueOf(service));
                            String locationURI = null;
                            for (Object element2 : port.getExtensibilityElements()) {
                                if (element2 instanceof SOAPAddress) {
                                    locationURI = ((SOAPAddress)element2).getLocationURI();
                                    continue;
                                }
                                if (element2 instanceof SOAP12Address) {
                                    locationURI = ((SOAP12Address)element2).getLocationURI();
                                    continue;
                                }
                                if (element2 instanceof HTTPAddress) {
                                    locationURI = ((HTTPAddress)element2).getLocationURI();
                                    continue;
                                }
                                if (!(element2 instanceof HTTPOperation)) continue;
                                locationURI = ((HTTPOperation)element2).getLocationURI();
                            }
                            ArrayList<String> operations = new ArrayList<String>();
                            element2 = port.getBinding().getBindingOperations().iterator();
                            while (element2.hasNext()) {
                                Object bindingOperation = element2.next();
                                String operationName = ((BindingOperation)bindingOperation).getName();
                                logger.debug("        Operation: " + operationName);
                                operations.add(operationName);
                            }
                            ArrayList<String> actions = new ArrayList<String>();
                            if (port.getBinding().getBindingOperations() == null) continue;
                            for (Object bindOperationObject : port.getBinding().getBindingOperations()) {
                                logger.debug("        Interface: " + String.valueOf(bindOperationObject));
                                List extensions = ((BindingOperation)bindOperationObject).getExtensibilityElements();
                                if (extensions == null) continue;
                                for (int i = 0; i < extensions.size(); ++i) {
                                    SOAPOperation soapOp;
                                    ExtensibilityElement extElement = (ExtensibilityElement)extensions.get(i);
                                    if (extElement instanceof SOAPOperation) {
                                        soapOp = (SOAPOperation)extElement;
                                        actions.add(soapOp.getSoapActionURI());
                                        continue;
                                    }
                                    if (!(extElement instanceof SOAP12Operation)) continue;
                                    soapOp = (SOAP12Operation)extElement;
                                    actions.add(soapOp.getSoapActionURI());
                                }
                            }
                            definitionPortMap.getMap().put(portQName, new DefinitionServiceMap.PortInformation(operations, actions, locationURI));
                            wsdlInterfacePortMap.put(portQName, definition);
                        }
                    }
                    definitionServiceMap.getMap().put(service.getQName().toString(), definitionPortMap);
                    wsdlInterfaceServiceMap.put(service.getQName().toString(), wsdlInterfacePortMap);
                }
            }
        } else {
            throw new Exception("Could not find any definitions in " + wsdlUrl);
        }
        definitionCache.put(wsdlUrl, definitionServiceMap);
        wsdlInterfaceCache.put(wsdlUrl, wsdlInterfaceServiceMap);
    }

    private String buildEnvelope(Definition definition, String operationName, boolean buildOptional) throws Exception {
        String prefix = "ws";
        String isQualified = "";
        String isSchemaImportQualified = "";
        String urlString = definition.getTargetNamespace();
        Map nameSpaceMap = definition.getNamespaces();
        for (Map.Entry entry : nameSpaceMap.entrySet()) {
            String url = ((String)entry.getValue()).toString();
            if (!url.equals(urlString)) continue;
            if (StringUtils.isEmpty((CharSequence)((CharSequence)entry.getKey()))) break;
            prefix = (String)entry.getKey();
            break;
        }
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        SOAPHeader soapHeader = soapEnvelope.getHeader();
        SOAPBody soapBody = soapEnvelope.getBody();
        SOAPFactory soapFactory = SOAPFactory.newInstance();
        soapEnvelope.addNamespaceDeclaration(prefix, definition.getTargetNamespace());
        Name bodyName = soapFactory.createName(operationName, prefix, "");
        SOAPBodyElement bodyElement = soapBody.addBodyElement(bodyName);
        ArrayList<String> elementTags = new ArrayList<String>();
        HashMap<String, ArrayList<String>> elementTypes = new HashMap<String, ArrayList<String>>();
        List extensibilityElements = definition.getTypes().getExtensibilityElements();
        for (Object extensibilityElement : extensibilityElements) {
            if (!(extensibilityElement instanceof Schema)) continue;
            Schema schema = (Schema)extensibilityElement;
            if (schema.getImports() != null && !schema.getImports().isEmpty()) {
                Iterator schemaIt = schema.getImports().entrySet().iterator();
                Map.Entry schemaEntry = schemaIt.next();
                schema = ((SchemaImport)((Vector)schemaEntry.getValue()).get(0)).getReferencedSchema();
                isSchemaImportQualified = schema.getElement().getAttribute("elementFormDefault");
                urlString = schema.getElement().getAttribute("targetNamespace");
                for (int i = 0; i < schema.getElement().getAttributes().getLength(); ++i) {
                    String url;
                    Node schemaNode = schema.getElement().getAttributes().item(i);
                    if (schemaNode.getNamespaceURI() == null || !(url = schemaNode.getNodeValue()).equals(urlString)) continue;
                    prefix = schemaNode.getLocalName();
                    break;
                }
            } else {
                isQualified = schema.getElement().getAttribute("elementFormDefault");
            }
            for (int i = 1; i < schema.getElement().getChildNodes().getLength(); i += 2) {
                Node node = schema.getElement().getChildNodes().item(i);
                String name = "";
                try {
                    name = node.getAttributes().getNamedItem("name").getNodeValue();
                }
                catch (Exception e) {
                    name = null;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)operationName)) continue;
                while (node.getChildNodes().getLength() != 0) {
                    int j = node.getChildNodes().getLength();
                    for (int k = 1; k < j; k += 2) {
                        String tagName;
                        String string = tagName = node.getChildNodes().item(k).getAttributes().getNamedItem("name") != null ? node.getChildNodes().item(k).getAttributes().getNamedItem("name").getNodeValue() : null;
                        if (StringUtils.isEmpty(tagName)) continue;
                        elementTags.add(tagName);
                    }
                    if (!elementTags.isEmpty()) {
                        elementTypes.put(name, elementTags);
                    }
                    node = node.getChildNodes().item(1);
                }
            }
        }
        if (elementTypes.get(operationName) != null) {
            for (String element : (List)elementTypes.get(operationName)) {
                Name childName = null;
                childName = isSchemaImportQualified.equals("qualified") || isQualified.equals("qualified") ? soapFactory.createName(element, prefix, urlString) : soapFactory.createName(element);
                SOAPElement childElement = bodyElement.addChildElement(childName);
                childElement.addTextNode("?");
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        soapMessage.writeTo((OutputStream)out);
        String envelope = new String(out.toByteArray());
        StreamSource xmlInput = new StreamSource(new StringReader(envelope));
        StringWriter stringWriter = new StringWriter();
        StreamResult xmlOutput = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 2);
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(xmlInput, xmlOutput);
        return xmlOutput.getWriter().toString();
    }
}

