/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.PEX_P08_EXPERIENCE;
import ca.uhn.hl7v2.model.v23.group.PEX_P08_VISIT;
import ca.uhn.hl7v2.model.v23.segment.EVN;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.PD1;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PEX_P08
extends AbstractMessage {
    public PEX_P08() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public PEX_P08(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(NTE.class, false, true);
            this.add(PEX_P08_VISIT.class, false, false);
            this.add(PEX_P08_EXPERIENCE.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PEX_P08 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return (EVN)this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return (PD1)this.getTyped("PD1", PD1.class);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public PEX_P08_VISIT getVISIT() {
        return (PEX_P08_VISIT)this.getTyped("VISIT", PEX_P08_VISIT.class);
    }

    public PEX_P08_EXPERIENCE getEXPERIENCE() {
        return (PEX_P08_EXPERIENCE)this.getTyped("EXPERIENCE", PEX_P08_EXPERIENCE.class);
    }

    public PEX_P08_EXPERIENCE getEXPERIENCE(int rep) {
        return (PEX_P08_EXPERIENCE)this.getTyped("EXPERIENCE", rep, PEX_P08_EXPERIENCE.class);
    }

    public int getEXPERIENCEReps() {
        return this.getReps("EXPERIENCE");
    }

    public List<PEX_P08_EXPERIENCE> getEXPERIENCEAll() throws HL7Exception {
        return this.getAllAsList("EXPERIENCE", PEX_P08_EXPERIENCE.class);
    }

    public void insertEXPERIENCE(PEX_P08_EXPERIENCE structure, int rep) throws HL7Exception {
        super.insertRepetition("EXPERIENCE", (Structure)structure, rep);
    }

    public PEX_P08_EXPERIENCE insertEXPERIENCE(int rep) throws HL7Exception {
        return (PEX_P08_EXPERIENCE)super.insertRepetition("EXPERIENCE", rep);
    }

    public PEX_P08_EXPERIENCE removeEXPERIENCE(int rep) throws HL7Exception {
        return (PEX_P08_EXPERIENCE)super.removeRepetition("EXPERIENCE", rep);
    }
}

