/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.ws;

import com.mirth.connect.connectors.ws.DefinitionServiceMap;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class WebServiceDispatcherProperties
extends ConnectorProperties
implements DestinationConnectorPropertiesInterface {
    private DestinationConnectorProperties destinationConnectorProperties;
    private String wsdlUrl;
    private String service;
    private String port;
    private String operation;
    private String locationURI;
    private String socketTimeout;
    private boolean useAuthentication;
    private String username;
    private String password;
    private String envelope;
    private boolean oneWay;
    private Map<String, List<String>> headers;
    private String headersVariable;
    private boolean isUseHeadersVariable;
    private boolean useMtom;
    private List<String> attachmentNames;
    private List<String> attachmentContents;
    private List<String> attachmentTypes;
    private String attachmentsVariable;
    private boolean isUseAttachmentsVariable;
    private String soapAction;
    private DefinitionServiceMap wsdlDefinitionMap;
    public static final String WEBSERVICE_DEFAULT_DROPDOWN = "Press Get Operations";

    public WebServiceDispatcherProperties() {
        this.destinationConnectorProperties = new DestinationConnectorProperties(false);
        this.wsdlUrl = "";
        this.operation = WEBSERVICE_DEFAULT_DROPDOWN;
        this.wsdlDefinitionMap = new DefinitionServiceMap();
        this.service = "";
        this.port = "";
        this.locationURI = "";
        this.socketTimeout = "30000";
        this.useAuthentication = false;
        this.username = "";
        this.password = "";
        this.envelope = "";
        this.oneWay = false;
        this.headers = new LinkedHashMap<String, List<String>>();
        this.isUseHeadersVariable = false;
        this.headersVariable = "";
        this.useMtom = false;
        this.attachmentNames = new ArrayList<String>();
        this.attachmentContents = new ArrayList<String>();
        this.attachmentTypes = new ArrayList<String>();
        this.isUseAttachmentsVariable = false;
        this.attachmentsVariable = "";
        this.soapAction = "";
    }

    public WebServiceDispatcherProperties(WebServiceDispatcherProperties props) {
        super((ConnectorProperties)props);
        this.destinationConnectorProperties = new DestinationConnectorProperties(props.getDestinationConnectorProperties());
        this.wsdlUrl = props.getWsdlUrl();
        this.operation = props.getOperation();
        this.wsdlDefinitionMap = props.getWsdlDefinitionMap();
        this.service = props.getService();
        this.port = props.getPort();
        this.locationURI = props.getLocationURI();
        this.socketTimeout = props.getSocketTimeout();
        this.useAuthentication = props.isUseAuthentication();
        this.username = props.getUsername();
        this.password = props.getPassword();
        this.envelope = props.getEnvelope();
        this.oneWay = props.isOneWay();
        LinkedHashMap<String, List<String>> headerCopy = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : props.getHeadersMap().entrySet()) {
            headerCopy.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        this.headers = headerCopy;
        this.isUseHeadersVariable = props.isUseHeadersVariable();
        this.headersVariable = props.getHeadersVariable();
        this.useMtom = props.isUseMtom();
        this.attachmentNames = new ArrayList<String>(props.getAttachmentNames());
        this.attachmentContents = new ArrayList<String>(props.getAttachmentContents());
        this.attachmentTypes = new ArrayList<String>(props.getAttachmentTypes());
        this.isUseAttachmentsVariable = props.isUseAttachmentsVariable();
        this.attachmentsVariable = props.getAttachmentsVariable();
        this.soapAction = props.getSoapAction();
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    public void setWsdlUrl(String wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public void setLocationURI(String locationURI) {
        this.locationURI = locationURI;
    }

    public String getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(String socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public boolean isUseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean useAuthentication) {
        this.useAuthentication = useAuthentication;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(String envelope) {
        this.envelope = envelope;
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public void setOneWay(boolean oneWay) {
        this.oneWay = oneWay;
    }

    public String getHeadersVariable() {
        return this.headersVariable;
    }

    public void setHeadersVariable(String headersVariable) {
        this.headersVariable = headersVariable;
    }

    public boolean isUseHeadersVariable() {
        return this.isUseHeadersVariable;
    }

    public void setUseHeadersVariable(boolean isUseHeadersVariable) {
        this.isUseHeadersVariable = isUseHeadersVariable;
    }

    public Map<String, List<String>> getHeadersMap() {
        return this.headers;
    }

    public void setHeadersMap(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public boolean isUseMtom() {
        return this.useMtom;
    }

    public void setUseMtom(boolean useMtom) {
        this.useMtom = useMtom;
    }

    public String getAttachmentsVariable() {
        return this.attachmentsVariable;
    }

    public void setAttachmentsVariable(String attachmentsVariable) {
        this.attachmentsVariable = attachmentsVariable;
    }

    public List<String> getAttachmentNames() {
        return this.attachmentNames;
    }

    public void setAttachmentNames(List<String> attachmentNames) {
        this.attachmentNames = attachmentNames;
    }

    public List<String> getAttachmentContents() {
        return this.attachmentContents;
    }

    public void setAttachmentContents(List<String> attachmentContents) {
        this.attachmentContents = attachmentContents;
    }

    public List<String> getAttachmentTypes() {
        return this.attachmentTypes;
    }

    public void setAttachmentTypes(List<String> attachmentTypes) {
        this.attachmentTypes = attachmentTypes;
    }

    public boolean isUseAttachmentsVariable() {
        return this.isUseAttachmentsVariable;
    }

    public void setUseAttachmentsVariable(boolean isUseAttachmentsVariable) {
        this.isUseAttachmentsVariable = isUseAttachmentsVariable;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public DefinitionServiceMap getWsdlDefinitionMap() {
        return this.wsdlDefinitionMap;
    }

    public void setWsdlDefinitionMap(DefinitionServiceMap wsdlDefinitionMap) {
        this.wsdlDefinitionMap = wsdlDefinitionMap;
    }

    public String getProtocol() {
        return "WS";
    }

    public String getName() {
        return "Web Service Sender";
    }

    public String toFormattedString() {
        StringBuilder builder = new StringBuilder();
        String newLine = "\n";
        builder.append("WSDL URL: ");
        builder.append(this.wsdlUrl);
        builder.append(newLine);
        if (StringUtils.isNotBlank((CharSequence)this.username)) {
            builder.append("USERNAME: ");
            builder.append(this.username);
            builder.append(newLine);
        }
        if (StringUtils.isNotBlank((CharSequence)this.service)) {
            builder.append("SERVICE: ");
            builder.append(this.service);
            builder.append(newLine);
        }
        if (StringUtils.isNotBlank((CharSequence)this.port)) {
            builder.append("PORT / ENDPOINT: ");
            builder.append(this.port);
            builder.append(newLine);
        }
        if (StringUtils.isNotBlank((CharSequence)this.locationURI)) {
            builder.append("LOCATION URI: ");
            builder.append(this.locationURI);
            builder.append(newLine);
        }
        if (StringUtils.isNotBlank((CharSequence)this.soapAction)) {
            builder.append("SOAP ACTION: ");
            builder.append(this.soapAction);
            builder.append(newLine);
        }
        if (this.isUseHeadersVariable()) {
            builder.append(newLine);
            builder.append("[HEADERS]");
            builder.append(newLine);
            builder.append("Using variable '" + this.getHeadersVariable() + "'");
        } else if (MapUtils.isNotEmpty(this.headers)) {
            builder.append(newLine);
            builder.append("[HEADERS]");
            builder.append(newLine);
            for (Map.Entry<String, List<String>> header : this.headers.entrySet()) {
                for (String value : (ArrayList)header.getValue()) {
                    builder.append(header.getKey().toString());
                    builder.append(": ");
                    builder.append(value.toString());
                    builder.append(newLine);
                }
            }
        }
        builder.append(newLine);
        builder.append("[ATTACHMENTS]");
        if (this.isUseAttachmentsVariable()) {
            builder.append("Using variable '" + this.getAttachmentsVariable() + "'");
        } else {
            for (int i = 0; i < this.attachmentNames.size(); ++i) {
                builder.append(newLine);
                builder.append(this.attachmentNames.get(i));
                builder.append(" (");
                builder.append(this.attachmentTypes.get(i));
                builder.append(")");
            }
        }
        builder.append(newLine);
        builder.append(newLine);
        builder.append("[CONTENT]");
        builder.append(newLine);
        builder.append(this.envelope);
        return builder.toString();
    }

    public DestinationConnectorProperties getDestinationConnectorProperties() {
        return this.destinationConnectorProperties;
    }

    public ConnectorProperties clone() {
        return new WebServiceDispatcherProperties(this);
    }

    public boolean canValidateResponse() {
        return true;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        super.migrate3_1_0(element);
        element.removeChild("wsdlCacheId");
        element.addChildElementIfNotExists("locationURI", "");
        DonkeyElement operations = element.removeChild("wsdlOperations");
        String service = element.getChildElement("service").getTextContent();
        String port = element.getChildElement("port").getTextContent();
        if (StringUtils.isNotBlank((CharSequence)service) && StringUtils.isNotBlank((CharSequence)port)) {
            DefinitionServiceMap wsdlDefinitionMap = new DefinitionServiceMap();
            DefinitionServiceMap.DefinitionPortMap portMap = new DefinitionServiceMap.DefinitionPortMap();
            ArrayList<String> operationList = new ArrayList<String>();
            if (operations != null) {
                for (DonkeyElement operation : operations.getChildElements()) {
                    operationList.add(operation.getTextContent());
                }
            }
            portMap.getMap().put(port, new DefinitionServiceMap.PortInformation(operationList));
            wsdlDefinitionMap.getMap().put(service, portMap);
            try {
                if (element.getChildElement("wsdlDefinitionMap") == null) {
                    DonkeyElement definitionMapElement = element.addChildElementFromXml(ObjectXMLSerializer.getInstance().serialize((Object)wsdlDefinitionMap));
                    definitionMapElement.setNodeName("wsdlDefinitionMap");
                }
            }
            catch (DonkeyElement.DonkeyElementException e) {
                throw new SerializerException("Failed to migrate Web Service Sender operation list.", (Throwable)e);
            }
        }
        element.addChildElementIfNotExists("socketTimeout", "0");
        LinkedHashMap headers = new LinkedHashMap();
        try {
            if (element.getChildElement("headers") == null) {
                DonkeyElement headersElement = element.addChildElementFromXml(ObjectXMLSerializer.getInstance().serialize(headers));
                headersElement.setNodeName("headers");
            }
        }
        catch (DonkeyElement.DonkeyElementException e) {
            throw new SerializerException("Failed to migrate Web Service Sender headers.", (Throwable)e);
        }
    }

    public void migrate3_2_0(DonkeyElement element) {
        if (element.getChildElement("headers") != null) {
            DonkeyElement oldHeaders = element.removeChild("headers");
            DonkeyElement newHeaders = element.addChildElement("headers");
            newHeaders.setAttribute("class", "linked-hash-map");
            for (DonkeyElement oldEntry : oldHeaders.getChildElements()) {
                if (oldEntry.getChildElements().size() < 2) continue;
                DonkeyElement entry = newHeaders.addChildElement("entry");
                entry.addChildElement("string", ((DonkeyElement)oldEntry.getChildElements().get(0)).getTextContent());
                entry.addChildElement("list").addChildElement("string", ((DonkeyElement)oldEntry.getChildElements().get(1)).getTextContent());
            }
        }
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("destinationConnectorProperties", this.destinationConnectorProperties.getPurgedProperties());
        purgedProperties.put("useAuthentication", this.useAuthentication);
        purgedProperties.put("envelopeLines", PurgeUtil.countLines((String)this.envelope));
        purgedProperties.put("oneWay", this.oneWay);
        purgedProperties.put("headersCount", this.headers.size());
        purgedProperties.put("useMtom", this.useMtom);
        purgedProperties.put("attachmentNamesCount", this.attachmentNames.size());
        purgedProperties.put("attachmentContentCount", this.attachmentContents.size());
        purgedProperties.put("wsdlDefinitionMapCount", this.wsdlDefinitionMap != null ? this.wsdlDefinitionMap.getMap().size() : 0);
        purgedProperties.put("socketTimeout", PurgeUtil.getNumericValue((String)this.socketTimeout));
        return purgedProperties;
    }
}

