/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public abstract class AbstractXMLInputFactory
extends XMLInputFactory {
    private XMLEventAllocator allocator;
    private XMLResolver resolver;
    private XMLReporter reporter;
    private boolean coalescing;
    private boolean namespaceAware;
    private boolean replacingEntityReferences;
    private boolean supportingExternalEntities;
    private boolean validating;
    private boolean supportDTD;

    @Override
    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            InputStream input = streamSource.getInputStream();
            if (input != null) {
                if (streamSource.getSystemId() != null) {
                    return this.createXMLStreamReader(streamSource.getSystemId(), input);
                }
                return this.createXMLStreamReader(input);
            }
            Reader reader = streamSource.getReader();
            if (reader != null) {
                if (streamSource.getSystemId() != null) {
                    return this.createXMLStreamReader(streamSource.getSystemId(), reader);
                }
                return this.createXMLStreamReader(reader);
            }
            if (streamSource.getSystemId() != null) {
                try {
                    final InputStream stream = new URI(source.getSystemId()).toURL().openStream();
                    return new StreamReaderDelegate(this.createXMLStreamReader(streamSource.getSystemId(), stream)){

                        @Override
                        public void close() throws XMLStreamException {
                            super.close();
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    };
                }
                catch (URISyntaxException e) {
                    throw new XMLStreamException("Cannot parse system id for reading: " + source.getSystemId(), e);
                }
                catch (IOException e) {
                    throw new XMLStreamException("Cannot open system id as URL for reading: " + source.getSystemId(), e);
                }
            }
            throw new XMLStreamException("Invalid stream source: none of input, reader, systemId set");
        }
        throw new XMLStreamException("Unsupported source type: " + source.getClass());
    }

    @Override
    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(reader));
    }

    @Override
    public XMLEventReader createXMLEventReader(String systemId, Reader reader) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(systemId, reader));
    }

    @Override
    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(source));
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream stream) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(stream));
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream stream, String encoding) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(stream, encoding));
    }

    @Override
    public XMLEventReader createXMLEventReader(String systemId, InputStream stream) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(systemId, stream));
    }

    @Override
    public XMLStreamReader createFilteredReader(XMLStreamReader reader, final StreamFilter filter) throws XMLStreamException {
        return new StreamReaderDelegate(reader){

            @Override
            public boolean hasNext() throws XMLStreamException {
                while (super.hasNext()) {
                    if (filter.accept(this.getParent())) {
                        return true;
                    }
                    super.next();
                }
                return false;
            }

            @Override
            public int next() throws XMLStreamException {
                if (this.hasNext()) {
                    return this.getParent().getEventType();
                }
                throw new IllegalStateException("No more events");
            }
        };
    }

    @Override
    public XMLEventAllocator getEventAllocator() {
        return this.allocator;
    }

    @Override
    public void setEventAllocator(XMLEventAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public XMLResolver getXMLResolver() {
        return this.resolver;
    }

    @Override
    public void setXMLResolver(XMLResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public XMLReporter getXMLReporter() {
        return this.reporter;
    }

    @Override
    public void setXMLReporter(XMLReporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public boolean isPropertySupported(String name) {
        if ("javax.xml.stream.allocator".equals(name)) {
            return true;
        }
        if ("javax.xml.stream.isCoalescing".equals(name)) {
            return true;
        }
        if ("javax.xml.stream.isNamespaceAware".equals(name)) {
            return true;
        }
        if ("javax.xml.stream.isReplacingEntityReferences".equals(name)) {
            return true;
        }
        if ("javax.xml.stream.isSupportingExternalEntities".equals(name)) {
            return true;
        }
        if ("javax.xml.stream.isValidating".equals(name)) {
            return true;
        }
        if ("javax.xml.stream.reporter".equals(name)) {
            return true;
        }
        if ("javax.xml.stream.resolver".equals(name)) {
            return true;
        }
        return "javax.xml.stream.supportDTD".equals(name);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if ("javax.xml.stream.allocator".equals(name)) {
            return this.allocator;
        }
        if ("javax.xml.stream.isCoalescing".equals(name)) {
            return this.coalescing;
        }
        if ("javax.xml.stream.isNamespaceAware".equals(name)) {
            return this.namespaceAware;
        }
        if ("javax.xml.stream.isReplacingEntityReferences".equals(name)) {
            return this.replacingEntityReferences;
        }
        if ("javax.xml.stream.isSupportingExternalEntities".equals(name)) {
            return this.supportingExternalEntities;
        }
        if ("javax.xml.stream.isValidating".equals(name)) {
            return this.validating;
        }
        if ("javax.xml.stream.reporter".equals(name)) {
            return this.reporter;
        }
        if ("javax.xml.stream.resolver".equals(name)) {
            return this.resolver;
        }
        if ("javax.xml.stream.supportDTD".equals(name)) {
            return this.supportDTD;
        }
        throw new IllegalArgumentException("Unsupported property: " + name);
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if ("javax.xml.stream.allocator".equals(name)) {
            this.allocator = (XMLEventAllocator)value;
        } else if ("javax.xml.stream.isCoalescing".equals(name)) {
            this.coalescing = (Boolean)value;
        } else if ("javax.xml.stream.isNamespaceAware".equals(name)) {
            this.namespaceAware = (Boolean)value;
        } else if ("javax.xml.stream.isReplacingEntityReferences".equals(name)) {
            this.replacingEntityReferences = (Boolean)value;
        } else if ("javax.xml.stream.isSupportingExternalEntities".equals(name)) {
            this.supportingExternalEntities = (Boolean)value;
        } else if ("javax.xml.stream.isValidating".equals(name)) {
            this.validating = (Boolean)value;
        } else if ("javax.xml.stream.reporter".equals(name)) {
            this.reporter = (XMLReporter)value;
        } else if ("javax.xml.stream.resolver".equals(name)) {
            this.resolver = (XMLResolver)value;
        } else if ("javax.xml.stream.supportDTD".equals(name)) {
            this.supportDTD = (Boolean)value;
        } else {
            throw new IllegalArgumentException("Unsupported property: " + name);
        }
    }
}

