/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.jaxb;

import de.odysseus.staxon.json.jaxb.JsonXML;
import de.odysseus.staxon.json.jaxb.JsonXMLBinder;
import de.odysseus.staxon.json.jaxb.JsonXMLRootProvider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;

public class JsonXMLMapper<T> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Class<T> type;
    private final JsonXML config;
    private final JsonXMLBinder binder;
    private final JAXBContext context;

    private static final JsonXML getConfig(Class<?> type) throws JAXBException {
        JsonXML config = type.getAnnotation(JsonXML.class);
        if (config == null) {
            @JsonXML
            class Default {
                Default() {
                }
            }
            config = Default.class.getAnnotation(JsonXML.class);
        }
        return config;
    }

    public JsonXMLMapper(Class<T> type) throws JAXBException {
        this(type, JsonXMLMapper.getConfig(type));
    }

    public JsonXMLMapper(Class<T> type, JsonXML config) throws JAXBException {
        this.type = type;
        this.config = config;
        this.binder = this.createBinder(config);
        this.context = this.createContext(config);
    }

    protected JsonXMLBinder createBinder(JsonXML config) {
        return new JsonXMLBinder(new JsonXMLRootProvider(), true);
    }

    protected JAXBContext createContext(JsonXML config) throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{this.type});
    }

    public T readObject(Reader reader) throws JAXBException, XMLStreamException {
        return this.binder.readObject(this.type, this.config, this.context, reader);
    }

    public T readObject(InputStream input) throws JAXBException, XMLStreamException {
        return this.readObject(new InputStreamReader(input, UTF_8));
    }

    public void writeObject(Writer writer, T value) throws JAXBException, XMLStreamException {
        this.binder.writeObject(this.type, this.config, this.context, writer, value);
    }

    public void writeObject(OutputStream output, T value) throws JAXBException, XMLStreamException {
        this.writeObject(new OutputStreamWriter(output, UTF_8), value);
    }

    public List<T> readArray(Reader reader) throws JAXBException, XMLStreamException {
        return this.binder.readArray(this.type, this.config, this.context, reader);
    }

    public List<T> readArray(InputStream input) throws JAXBException, XMLStreamException {
        return this.readArray(new InputStreamReader(input, UTF_8));
    }

    public void writeArray(Writer writer, Collection<T> collection) throws JAXBException, XMLStreamException {
        this.binder.writeArray(this.type, this.config, this.context, writer, collection);
    }

    public void writeArray(OutputStream output, Collection<T> collection) throws JAXBException, XMLStreamException {
        this.writeArray(new OutputStreamWriter(output, UTF_8), collection);
    }
}

