/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.lingala.zip4j.crypto.AESDecrypter;
import net.lingala.zip4j.crypto.IDecrypter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.BaseInputStream;
import net.lingala.zip4j.unzip.UnzipEngine;

public class PartInputStream
extends BaseInputStream {
    private RandomAccessFile raf;
    private long bytesRead;
    private long length;
    private UnzipEngine unzipEngine;
    private IDecrypter decrypter;
    private byte[] oneByteBuff = new byte[1];
    private byte[] aesBlockByte = new byte[16];
    private int aesBytesReturned = 0;
    private boolean isAESEncryptedFile = false;
    private int count = -1;

    public PartInputStream(RandomAccessFile randomAccessFile, long l, long l2, UnzipEngine unzipEngine) {
        this.raf = randomAccessFile;
        this.unzipEngine = unzipEngine;
        this.decrypter = unzipEngine.getDecrypter();
        this.bytesRead = 0L;
        this.length = l2;
        this.isAESEncryptedFile = unzipEngine.getFileHeader().isEncrypted() && unzipEngine.getFileHeader().getEncryptionMethod() == 99;
    }

    @Override
    public int available() {
        long l = this.length - this.bytesRead;
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesRead >= this.length) {
            return -1;
        }
        if (this.isAESEncryptedFile) {
            if (this.aesBytesReturned == 0 || this.aesBytesReturned == 16) {
                if (this.read(this.aesBlockByte) == -1) {
                    return -1;
                }
                this.aesBytesReturned = 0;
            }
            return this.aesBlockByte[this.aesBytesReturned++] & 0xFF;
        }
        return this.read(this.oneByteBuff, 0, 1) == -1 ? -1 : this.oneByteBuff[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if ((long)n2 > this.length - this.bytesRead && (n2 = (int)(this.length - this.bytesRead)) == 0) {
            this.checkAndReadAESMacBytes();
            return -1;
        }
        if (this.unzipEngine.getDecrypter() instanceof AESDecrypter && this.bytesRead + (long)n2 < this.length && n2 % 16 != 0) {
            n2 -= n2 % 16;
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.count = this.raf.read(byArray, n, n2);
            if (this.count < n2 && this.unzipEngine.getZipModel().isSplitArchive()) {
                int n3;
                this.raf.close();
                this.raf = this.unzipEngine.startNextSplitFile();
                if (this.count < 0) {
                    this.count = 0;
                }
                if ((n3 = this.raf.read(byArray, this.count, n2 - this.count)) > 0) {
                    this.count += n3;
                }
            }
        }
        if (this.count > 0) {
            if (this.decrypter != null) {
                try {
                    this.decrypter.decryptData(byArray, n, this.count);
                }
                catch (ZipException zipException) {
                    throw new IOException(zipException.getMessage());
                }
            }
            this.bytesRead += (long)this.count;
        }
        if (this.bytesRead >= this.length) {
            this.checkAndReadAESMacBytes();
        }
        return this.count;
    }

    protected void checkAndReadAESMacBytes() throws IOException {
        if (this.isAESEncryptedFile && this.decrypter != null && this.decrypter instanceof AESDecrypter) {
            if (((AESDecrypter)this.decrypter).getStoredMac() != null) {
                return;
            }
            byte[] byArray = new byte[10];
            int n = -1;
            n = this.raf.read(byArray);
            if (n != 10) {
                if (this.unzipEngine.getZipModel().isSplitArchive()) {
                    this.raf.close();
                    this.raf = this.unzipEngine.startNextSplitFile();
                    int n2 = this.raf.read(byArray, n, 10 - n);
                    n += n2;
                } else {
                    throw new IOException("Error occured while reading stored AES authentication bytes");
                }
            }
            ((AESDecrypter)this.unzipEngine.getDecrypter()).setStoredMac(byArray);
        }
    }

    @Override
    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (l > this.length - this.bytesRead) {
            l = this.length - this.bytesRead;
        }
        this.bytesRead += l;
        return l;
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public void seek(long l) throws IOException {
        this.raf.seek(l);
    }

    @Override
    public UnzipEngine getUnzipEngine() {
        return this.unzipEngine;
    }
}

